package com.ejianc.business.budget.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.budget.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 预算记录明细
 *
 * @author generator
 *
 */
public class BudgetRecordDetailVO extends BaseVO  implements ITreeNodeB{
    private static final long serialVersionUID = 1L;

    private Long budgetId; // 主表ID
    private Long recordId; // 变更主键
    private Long budgetDetailId; // 预算明细ID
    private String treeIndex; // 序号
    private String buildingNo; // 楼号
    private String buildContent; // 施工内容
    private String craft; // 工艺
    private String stages; // 工序
    private java.math.BigDecimal budgetNum; // 收入预算工程量
    private String budgetUnit; // 收入预算单位
    private java.math.BigDecimal budgetPrice; // 收入预算综合单价
    private java.math.BigDecimal budgetMoney; // 收入预算合价
    private java.math.BigDecimal costNum; // 劳务预算工程量
    private java.math.BigDecimal costPrice; // 劳务预算综合单价
    private java.math.BigDecimal costMoney; // 劳务预算合价
    private Long materialId; // 物料ID
    private String materialName; // 物料名称
    private java.math.BigDecimal materialWeightScale; // 材料预算产值权重
    private java.math.BigDecimal materialUsedScale; // 材料预算材料使用率
    private java.math.BigDecimal materialUsedNum; // 材料预算耗量
    private java.math.BigDecimal materialPlanNum; // 材料预算计划用量
    private java.math.BigDecimal materialPrice; // 材料预算综合单价
    private String materialUnit; // 材料预算单位
    private BigDecimal materialMoney; // 材料预算合价
    private String memo; // 备注
    private Long parentId; // 父ID
    private Boolean leafFlag; // 是否末级
    private Integer levelNo; // 级次
    private Long changeId; // 变更主键
    private Long changeBid; // 变更子表主键
    private Integer changeType; // 变更类型

    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;

    private String shadowId;
    private List<ITreeNodeB> children;

    /**
     * 主表ID
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 主表ID
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 变更主键
     */
    public Long getRecordId() {
        return recordId;
    }

    /**
     * 变更主键
     */
    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }
    /**
     * 预算明细ID
     */
    public Long getBudgetDetailId() {
        return budgetDetailId;
    }

    /**
     * 预算明细ID
     */
    public void setBudgetDetailId(Long budgetDetailId) {
        this.budgetDetailId = budgetDetailId;
    }
    /**
     * 序号
     */
    public String getTreeIndex() {
        return treeIndex;
    }

    /**
     * 序号
     */
    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }
    /**
     * 楼号
     */
    public String getBuildingNo() {
        return buildingNo;
    }

    /**
     * 楼号
     */
    public void setBuildingNo(String buildingNo) {
        this.buildingNo = buildingNo;
    }
    /**
     * 施工内容
     */
    public String getBuildContent() {
        return buildContent;
    }

    /**
     * 施工内容
     */
    public void setBuildContent(String buildContent) {
        this.buildContent = buildContent;
    }
    /**
     * 工艺
     */
    public String getCraft() {
        return craft;
    }

    /**
     * 工艺
     */
    public void setCraft(String craft) {
        this.craft = craft;
    }
    /**
     * 工序
     */
    public String getStages() {
        return stages;
    }

    /**
     * 工序
     */
    public void setStages(String stages) {
        this.stages = stages;
    }
    /**
     * 收入预算工程量
     */
    public java.math.BigDecimal getBudgetNum() {
        return budgetNum;
    }

    /**
     * 收入预算工程量
     */
    public void setBudgetNum(java.math.BigDecimal budgetNum) {
        this.budgetNum = budgetNum;
    }
    /**
     * 收入预算单位
     */
    public String getBudgetUnit() {
        return budgetUnit;
    }

    /**
     * 收入预算单位
     */
    public void setBudgetUnit(String budgetUnit) {
        this.budgetUnit = budgetUnit;
    }
    /**
     * 收入预算综合单价
     */
    public java.math.BigDecimal getBudgetPrice() {
        return budgetPrice;
    }

    /**
     * 收入预算综合单价
     */
    public void setBudgetPrice(java.math.BigDecimal budgetPrice) {
        this.budgetPrice = budgetPrice;
    }
    /**
     * 收入预算合价
     */
    public java.math.BigDecimal getBudgetMoney() {
        return budgetMoney;
    }

    /**
     * 收入预算合价
     */
    public void setBudgetMoney(java.math.BigDecimal budgetMoney) {
        this.budgetMoney = budgetMoney;
    }
    /**
     * 劳务预算工程量
     */
    public java.math.BigDecimal getCostNum() {
        return costNum;
    }

    /**
     * 劳务预算工程量
     */
    public void setCostNum(java.math.BigDecimal costNum) {
        this.costNum = costNum;
    }
    /**
     * 劳务预算综合单价
     */
    public java.math.BigDecimal getCostPrice() {
        return costPrice;
    }

    /**
     * 劳务预算综合单价
     */
    public void setCostPrice(java.math.BigDecimal costPrice) {
        this.costPrice = costPrice;
    }
    /**
     * 劳务预算合价
     */
    public java.math.BigDecimal getCostMoney() {
        return costMoney;
    }

    /**
     * 劳务预算合价
     */
    public void setCostMoney(java.math.BigDecimal costMoney) {
        this.costMoney = costMoney;
    }
    /**
     * 物料ID
     */
    @ReferSerialTransfer(referCode="Material001")
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物料ID
     */
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料预算产值权重
     */
    public java.math.BigDecimal getMaterialWeightScale() {
        return materialWeightScale;
    }

    /**
     * 材料预算产值权重
     */
    public void setMaterialWeightScale(java.math.BigDecimal materialWeightScale) {
        this.materialWeightScale = materialWeightScale;
    }
    /**
     * 材料预算材料使用率
     */
    public java.math.BigDecimal getMaterialUsedScale() {
        return materialUsedScale;
    }

    /**
     * 材料预算材料使用率
     */
    public void setMaterialUsedScale(java.math.BigDecimal materialUsedScale) {
        this.materialUsedScale = materialUsedScale;
    }
    /**
     * 材料预算耗量
     */
    public java.math.BigDecimal getMaterialUsedNum() {
        return materialUsedNum;
    }

    /**
     * 材料预算耗量
     */
    public void setMaterialUsedNum(java.math.BigDecimal materialUsedNum) {
        this.materialUsedNum = materialUsedNum;
    }
    /**
     * 材料预算计划用量
     */
    public java.math.BigDecimal getMaterialPlanNum() {
        return materialPlanNum;
    }

    /**
     * 材料预算计划用量
     */
    public void setMaterialPlanNum(java.math.BigDecimal materialPlanNum) {
        this.materialPlanNum = materialPlanNum;
    }
    /**
     * 材料预算综合单价
     */
    public java.math.BigDecimal getMaterialPrice() {
        return materialPrice;
    }

    /**
     * 材料预算综合单价
     */
    public void setMaterialPrice(java.math.BigDecimal materialPrice) {
        this.materialPrice = materialPrice;
    }
    /**
     * 材料预算单位
     */
    public String getMaterialUnit() {
        return materialUnit;
    }

    /**
     * 材料预算单位
     */
    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }
    /**
     * 材料预算合价
     */
    public BigDecimal getMaterialMoney() {
        return materialMoney;
    }

    /**
     * 材料预算合价
     */
    public void setMaterialMoney(BigDecimal materialMoney) {
        this.materialMoney = materialMoney;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    /**
     * 级次
     */
    public Integer getLevelNo() {
        return levelNo;
    }

    /**
     * 级次
     */
    public void setLevelNo(Integer levelNo) {
        this.levelNo = levelNo;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }
    /**
     * 变更类型
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * 变更类型
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;

    }
}
