package com.ejianc.business.budget.vo;


import com.ejianc.business.budget.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 预算变更明细
 *
 * @author generator
 *
 */
public class BudgetChangeDetailVO extends BaseVO implements ITreeNodeB{
    private static final long serialVersionUID = 1L;

    private Long budgetId; // 主表ID
    private Long changeId; // 变更主键
    private Long srcBid; // 预算子表主键
    private String treeIndex; // 序号
    private String buildingNo; // 楼号
    private String buildContent; // 施工内容
    private String craft; // 工艺
    private String stages; // 工序
    private  BigDecimal budgetNum; // 收入预算工程量
    private  BigDecimal beforeBudgetNum; // 变更前收入预算工程量
    private String budgetUnit; // 收入预算单位
    private String beforeBudgetUnit; // 变更前收入预算单位
    private  BigDecimal budgetPrice; // 收入预算综合单价
    private  BigDecimal beforeBudgetPrice; // 变更前收入预算综合单价
    private  BigDecimal budgetMoney; // 收入预算合价
    private  BigDecimal beforeBudgetMoney; // 变更前收入预算合价
    private BigDecimal costNum; // 劳务预算工程量
    private  BigDecimal beforeCostNum; // 变更前劳务预算工程量
    private  BigDecimal costPrice; // 劳务预算综合单价
    private  BigDecimal beforeCostPrice; // 变更前劳务预算综合单价
    private  BigDecimal costMoney; // 劳务预算合价
    private  BigDecimal beforeCostMoney; // 变更前劳务预算合价
    private Long materialId; // 物料ID
    private String materialName; // 物料名称
    private  BigDecimal materialWeightScale; // 材料预算产值权重
    private  BigDecimal beforeMaterialWeightScale; // 变更前材料预算产值权重
    private  BigDecimal materialUsedScale; // 材料预算材料使用率
    private  BigDecimal beforeMaterialUsedScale; // 变更前材料预算材料使用率
    private  BigDecimal materialUsedNum; // 材料预算耗量
    private  BigDecimal beforeMaterialUsedNum; // 变更前材料预算耗量
    private  BigDecimal materialPlanNum; // 材料预算计划用量
    private  BigDecimal beforeMaterialPlanNum; // 变更前材料预算计划用量
    private  BigDecimal materialPrice; // 材料预算综合单价
    private  BigDecimal beforeMaterialPrice; // 变更前材料预算综合单价
    private String materialUnit; // 材料预算单位
    private String beforeMaterialUnit; // 变更前材料预算单位
    private BigDecimal materialMoney; // 材料预算合价
    private BigDecimal beforeMaterialMoney; // 变更前材料预算合价
    private String memo; // 备注
    private Long parentId; // 父ID
    private Boolean leafFlag; // 是否末级
    private Integer levelNo; // 级次
    private Integer changeType; // 变更类型


    private String tid;
    private String tpid;
    //错误类型
    private String warnType;
    // 列是否可以导入，true=可以导入，false=不可导入
    private Boolean importFlag;
    // 是否是父级错误
    private Boolean parentWarn;

    private String shadowId;
    private List<ITreeNodeB> children;

    /**
     * 主表ID
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 主表ID
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 预算子表主键
     */
    public Long getSrcBid() {
        return srcBid;
    }

    /**
     * 预算子表主键
     */
    public void setSrcBid(Long srcBid) {
        this.srcBid = srcBid;
    }
    /**
     * 序号
     */
    public String getTreeIndex() {
        return treeIndex;
    }

    /**
     * 序号
     */
    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }
    /**
     * 楼号
     */
    public String getBuildingNo() {
        return buildingNo;
    }

    /**
     * 楼号
     */
    public void setBuildingNo(String buildingNo) {
        this.buildingNo = buildingNo;
    }
    /**
     * 施工内容
     */
    public String getBuildContent() {
        return buildContent;
    }

    /**
     * 施工内容
     */
    public void setBuildContent(String buildContent) {
        this.buildContent = buildContent;
    }
    /**
     * 工艺
     */
    public String getCraft() {
        return craft;
    }

    /**
     * 工艺
     */
    public void setCraft(String craft) {
        this.craft = craft;
    }
    /**
     * 工序
     */
    public String getStages() {
        return stages;
    }

    /**
     * 工序
     */
    public void setStages(String stages) {
        this.stages = stages;
    }
    /**
     * 收入预算工程量
     */
    public  BigDecimal getBudgetNum() {
        return budgetNum;
    }

    /**
     * 收入预算工程量
     */
    public void setBudgetNum( BigDecimal budgetNum) {
        this.budgetNum = budgetNum;
    }
    /**
     * 变更前收入预算工程量
     */
    public  BigDecimal getBeforeBudgetNum() {
        return beforeBudgetNum;
    }

    /**
     * 变更前收入预算工程量
     */
    public void setBeforeBudgetNum( BigDecimal beforeBudgetNum) {
        this.beforeBudgetNum = beforeBudgetNum;
    }
    /**
     * 收入预算单位
     */
    public String getBudgetUnit() {
        return budgetUnit;
    }

    /**
     * 收入预算单位
     */
    public void setBudgetUnit(String budgetUnit) {
        this.budgetUnit = budgetUnit;
    }
    /**
     * 变更前收入预算单位
     */
    public String getBeforeBudgetUnit() {
        return beforeBudgetUnit;
    }

    /**
     * 变更前收入预算单位
     */
    public void setBeforeBudgetUnit(String beforeBudgetUnit) {
        this.beforeBudgetUnit = beforeBudgetUnit;
    }
    /**
     * 收入预算综合单价
     */
    public  BigDecimal getBudgetPrice() {
        return budgetPrice;
    }

    /**
     * 收入预算综合单价
     */
    public void setBudgetPrice( BigDecimal budgetPrice) {
        this.budgetPrice = budgetPrice;
    }
    /**
     * 变更前收入预算综合单价
     */
    public  BigDecimal getBeforeBudgetPrice() {
        return beforeBudgetPrice;
    }

    /**
     * 变更前收入预算综合单价
     */
    public void setBeforeBudgetPrice( BigDecimal beforeBudgetPrice) {
        this.beforeBudgetPrice = beforeBudgetPrice;
    }
    /**
     * 收入预算合价
     */
    public  BigDecimal getBudgetMoney() {
        return budgetMoney;
    }

    /**
     * 收入预算合价
     */
    public void setBudgetMoney( BigDecimal budgetMoney) {
        this.budgetMoney = budgetMoney;
    }
    /**
     * 变更前收入预算合价
     */
    public  BigDecimal getBeforeBudgetMoney() {
        return beforeBudgetMoney;
    }

    /**
     * 变更前收入预算合价
     */
    public void setBeforeBudgetMoney( BigDecimal beforeBudgetMoney) {
        this.beforeBudgetMoney = beforeBudgetMoney;
    }
    /**
     * 劳务预算工程量
     */
    public  BigDecimal getCostNum() {
        return costNum;
    }

    /**
     * 劳务预算工程量
     */
    public void setCostNum( BigDecimal costNum) {
        this.costNum = costNum;
    }
    /**
     * 变更前劳务预算工程量
     */
    public  BigDecimal getBeforeCostNum() {
        return beforeCostNum;
    }

    /**
     * 变更前劳务预算工程量
     */
    public void setBeforeCostNum( BigDecimal beforeCostNum) {
        this.beforeCostNum = beforeCostNum;
    }
    /**
     * 劳务预算综合单价
     */
    public  BigDecimal getCostPrice() {
        return costPrice;
    }

    /**
     * 劳务预算综合单价
     */
    public void setCostPrice( BigDecimal costPrice) {
        this.costPrice = costPrice;
    }
    /**
     * 变更前劳务预算综合单价
     */
    public  BigDecimal getBeforeCostPrice() {
        return beforeCostPrice;
    }

    /**
     * 变更前劳务预算综合单价
     */
    public void setBeforeCostPrice( BigDecimal beforeCostPrice) {
        this.beforeCostPrice = beforeCostPrice;
    }
    /**
     * 劳务预算合价
     */
    public  BigDecimal getCostMoney() {
        return costMoney;
    }

    /**
     * 劳务预算合价
     */
    public void setCostMoney( BigDecimal costMoney) {
        this.costMoney = costMoney;
    }
    /**
     * 变更前劳务预算合价
     */
    public  BigDecimal getBeforeCostMoney() {
        return beforeCostMoney;
    }

    /**
     * 变更前劳务预算合价
     */
    public void setBeforeCostMoney( BigDecimal beforeCostMoney) {
        this.beforeCostMoney = beforeCostMoney;
    }
    /**
     * 物料ID
     */
    @ReferSerialTransfer(referCode="Material001")
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物料ID
     */
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物料名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物料名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 材料预算产值权重
     */
    public  BigDecimal getMaterialWeightScale() {
        return materialWeightScale;
    }

    /**
     * 材料预算产值权重
     */
    public void setMaterialWeightScale( BigDecimal materialWeightScale) {
        this.materialWeightScale = materialWeightScale;
    }
    /**
     * 变更前材料预算产值权重
     */
    public  BigDecimal getBeforeMaterialWeightScale() {
        return beforeMaterialWeightScale;
    }

    /**
     * 变更前材料预算产值权重
     */
    public void setBeforeMaterialWeightScale( BigDecimal beforeMaterialWeightScale) {
        this.beforeMaterialWeightScale = beforeMaterialWeightScale;
    }
    /**
     * 材料预算材料使用率
     */
    public  BigDecimal getMaterialUsedScale() {
        return materialUsedScale;
    }

    /**
     * 材料预算材料使用率
     */
    public void setMaterialUsedScale( BigDecimal materialUsedScale) {
        this.materialUsedScale = materialUsedScale;
    }
    /**
     * 变更前材料预算材料使用率
     */
    public  BigDecimal getBeforeMaterialUsedScale() {
        return beforeMaterialUsedScale;
    }

    /**
     * 变更前材料预算材料使用率
     */
    public void setBeforeMaterialUsedScale( BigDecimal beforeMaterialUsedScale) {
        this.beforeMaterialUsedScale = beforeMaterialUsedScale;
    }
    /**
     * 材料预算耗量
     */
    public  BigDecimal getMaterialUsedNum() {
        return materialUsedNum;
    }

    /**
     * 材料预算耗量
     */
    public void setMaterialUsedNum( BigDecimal materialUsedNum) {
        this.materialUsedNum = materialUsedNum;
    }
    /**
     * 变更前材料预算耗量
     */
    public  BigDecimal getBeforeMaterialUsedNum() {
        return beforeMaterialUsedNum;
    }

    /**
     * 变更前材料预算耗量
     */
    public void setBeforeMaterialUsedNum( BigDecimal beforeMaterialUsedNum) {
        this.beforeMaterialUsedNum = beforeMaterialUsedNum;
    }
    /**
     * 材料预算计划用量
     */
    public  BigDecimal getMaterialPlanNum() {
        return materialPlanNum;
    }

    /**
     * 材料预算计划用量
     */
    public void setMaterialPlanNum( BigDecimal materialPlanNum) {
        this.materialPlanNum = materialPlanNum;
    }
    /**
     * 变更前材料预算计划用量
     */
    public  BigDecimal getBeforeMaterialPlanNum() {
        return beforeMaterialPlanNum;
    }

    /**
     * 变更前材料预算计划用量
     */
    public void setBeforeMaterialPlanNum( BigDecimal beforeMaterialPlanNum) {
        this.beforeMaterialPlanNum = beforeMaterialPlanNum;
    }
    /**
     * 材料预算综合单价
     */
    public  BigDecimal getMaterialPrice() {
        return materialPrice;
    }

    /**
     * 材料预算综合单价
     */
    public void setMaterialPrice( BigDecimal materialPrice) {
        this.materialPrice = materialPrice;
    }
    /**
     * 变更前材料预算综合单价
     */
    public  BigDecimal getBeforeMaterialPrice() {
        return beforeMaterialPrice;
    }

    /**
     * 变更前材料预算综合单价
     */
    public void setBeforeMaterialPrice( BigDecimal beforeMaterialPrice) {
        this.beforeMaterialPrice = beforeMaterialPrice;
    }
    /**
     * 材料预算单位
     */
    public String getMaterialUnit() {
        return materialUnit;
    }

    /**
     * 材料预算单位
     */
    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }
    /**
     * 变更前材料预算单位
     */
    public String getBeforeMaterialUnit() {
        return beforeMaterialUnit;
    }

    /**
     * 变更前材料预算单位
     */
    public void setBeforeMaterialUnit(String beforeMaterialUnit) {
        this.beforeMaterialUnit = beforeMaterialUnit;
    }
    /**
     * 材料预算合价
     */
    public BigDecimal getMaterialMoney() {
        return materialMoney;
    }

    /**
     * 材料预算合价
     */
    public void setMaterialMoney(BigDecimal materialMoney) {
        this.materialMoney = materialMoney;
    }
    /**
     * 变更前材料预算合价
     */
    public BigDecimal getBeforeMaterialMoney() {
        return beforeMaterialMoney;
    }

    /**
     * 变更前材料预算合价
     */
    public void setBeforeMaterialMoney(BigDecimal beforeMaterialMoney) {
        this.beforeMaterialMoney = beforeMaterialMoney;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 父ID
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * 父ID
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    /**
     * 是否末级
     */
    public Boolean getLeafFlag() {
        return leafFlag;
    }

    /**
     * 是否末级
     */
    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }
    /**
     * 级次
     */
    public Integer getLevelNo() {
        return levelNo;
    }

    /**
     * 级次
     */
    public void setLevelNo(Integer levelNo) {
        this.levelNo = levelNo;
    }
    /**
     * 变更类型
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * 变更类型
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getWarnType() {
        return warnType;
    }

    public void setWarnType(String warnType) {
        this.warnType = warnType;
    }

    public Boolean getImportFlag() {
        return importFlag;
    }

    public void setImportFlag(Boolean importFlag) {
        this.importFlag = importFlag;
    }

    public Boolean getParentWarn() {
        return parentWarn;
    }

    public void setParentWarn(Boolean parentWarn) {
        this.parentWarn = parentWarn;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;

    }
}
