/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.utils;

import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelImportUtil {
    public static List<Map<String, Object>> treeData(List<Map> list) {
        ArrayList<Map<String, Object>> resp = new ArrayList<Map<String, Object>>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, Map> listMap = new HashMap<String, Map>();
        for (Map item : list) {
            listMap.put(item.get("tid").toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            Map item;
            item = list.get(i);
            String parentId = item.get("tpid") != null ? item.get("tpid").toString() : "";
            Map parent = (Map)listMap.get(parentId);
            if (parent != null) {
                List child = (List)parent.get("children");
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<Map> children = new ArrayList<Map>();
                children.add(item);
                parent.put("children", children);
                continue;
            }
            rootItems.add(item.get("tid").toString());
        }
        for (String rootId : rootItems) {
            resp.add((Map<String, Object>)listMap.get(rootId));
        }
        return resp;
    }

    public static List<Map<String, Object>> dealWeightScale(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            List child = (List)map.get("children");
            if (child == null) continue;
            List<Map<String, Object>> mapList = ExcelImportUtil.dealWeightScale(child);
            if ((Integer)map.get("levelNo") == 3) {
                BigDecimal total = BigDecimal.ZERO;
                for (Map<String, Object> childMap : mapList) {
                    if (null == childMap.get("materialWeightScale")) continue;
                    total = ComputeUtil.safeAdd((BigDecimal)total, (BigDecimal)((BigDecimal)childMap.get("materialWeightScale")));
                }
                if (total.compareTo(new BigDecimal(100)) != 0) {
                    if (!((Boolean)map.get("importFlag")).booleanValue()) {
                        map.put("warnType", map.get("warnType") + ",\u6743\u91cd\u548c\u4e0d\u4e3a1");
                    } else {
                        map.put("importFlag", false);
                        map.put("warnType", "\u6743\u91cd\u548c\u4e0d\u4e3a1");
                    }
                    for (Map<String, Object> childMap : mapList) {
                        if (!((Boolean)map.get("importFlag")).booleanValue()) {
                            childMap.put("warnType", map.get("warnType") + ",\u6743\u91cd\u548c\u4e0d\u4e3a1");
                            continue;
                        }
                        childMap.put("importFlag", false);
                        childMap.put("warnType", "\u6743\u91cd\u548c\u4e0d\u4e3a1");
                    }
                }
            }
            map.put("children", mapList);
        }
        return list;
    }

    public static List<Map<String, Object>> importFlagToFalse(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            map.put("importFlag", false);
            List child = (List)map.get("children");
            if (child != null) {
                map.put("leafFlag", false);
            } else {
                map.put("leafFlag", true);
            }
            if (child == null) continue;
            map.put("children", ExcelImportUtil.importFlagToFalse(child));
        }
        return list;
    }

    public static List<List<Map<String, Object>>> separate(List<Map<String, Object>> list, List<Map<String, Object>> falseList) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> stringObjectMap = list.get(i);
            if (!((Boolean)stringObjectMap.get("importFlag")).booleanValue()) {
                falseList.add(stringObjectMap);
                list.remove(i);
                --i;
                continue;
            }
            List child = (List)stringObjectMap.get("children");
            if (child == null) continue;
            stringObjectMap.put("children", ExcelImportUtil.separate(child, falseList).get(0));
        }
        ArrayList<List<Map<String, Object>>> lists = new ArrayList<List<Map<String, Object>>>();
        lists.add(list);
        lists.add(falseList);
        return lists;
    }

    public static List<Map<String, Object>> treeToList(List<Map<String, Object>> list) {
        ArrayList<Map<String, Object>> reList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> stringObjectMap : list) {
            List child = (List)stringObjectMap.get("children");
            String warnType = (String)stringObjectMap.get("warnType");
            if (null == warnType || warnType.length() < 1) {
                stringObjectMap.put("warnType", "\u4e0a\u7ea7\u6216\u4e0b\u7ea7\u5b58\u5728\u9519\u8bef\uff01");
            }
            stringObjectMap.put("id", stringObjectMap.get("tid"));
            if (null != child) {
                List<Map<String, Object>> childrenList = ExcelImportUtil.treeToList(child);
                stringObjectMap.put("children", null);
                reList.add(stringObjectMap);
                reList.addAll(childrenList);
                continue;
            }
            reList.add(stringObjectMap);
        }
        return reList;
    }
}

