package com.ejianc.business.budget.utils;


import com.ejianc.business.budget.vo.BudgetDetailVO;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author beibeiup
 */
public class TreeNodeBUtil {

  /**
   * 构建树
   *
   * @param values 需要组建树的数据List
   * @param <T> 数据类型
   * @return 树的根节点
   */
  public static <T extends ITreeNodeB> List<T> buildTree(List<T> values) {
    Map<Long, T> nodeMap = new HashMap<>();
    List<T> result = new ArrayList<>();
    List<T> emptyValueList = new ArrayList<>();
    for (T value : values) {
      if (null==value.getParentID()||value.getParentID()==0) {
        result.add(value);
      } else {
        T parentNode = nodeMap.get(value.getParentID());
        if (parentNode == null) {
          emptyValueList.add(value);
        } else {
          parentNode.getChildren().add(value);
        }
      }
      nodeMap.put(value.getNodeID(), value);
    }
    if (!emptyValueList.isEmpty()) {
      for (T value : emptyValueList) {
        T parentNode = nodeMap.get(value.getParentID());
        if (parentNode == null) {
          result.add(value);
        } else {
          parentNode.getChildren().add(value);
        }
      }
    }
    return result;
  }


  /**
   * 构建树
   *
   * @param values 需要组建树的数据List
   * @return 树的根节点
   */
  public static List<BudgetDetailVO> buildTreeByTid(List<BudgetDetailVO> values) {
    Map<String, BudgetDetailVO> nodeMap = new HashMap<>();
    List<BudgetDetailVO> result = new ArrayList<>();
    List<BudgetDetailVO> emptyValueList = new ArrayList<>();
    for (BudgetDetailVO value : values) {
      if (StringUtils.isBlank(value.getTpid())) {
        result.add(value);
      } else {
        BudgetDetailVO parentNode = nodeMap.get(value.getTpid());
        if (parentNode == null) {
          emptyValueList.add(value);
        } else {
          parentNode.getChildren().add(value);
        }
      }
      nodeMap.put(value.getTid(), value);
    }
    if (!emptyValueList.isEmpty()) {
      for (BudgetDetailVO value : emptyValueList) {
        BudgetDetailVO parentNode = nodeMap.get(value.getTpid());
        if (parentNode == null) {
          result.add(value);
        } else {
          parentNode.getChildren().add(value);
        }
      }
    }
    return result;
  }
}
