/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.budget.utils;

import com.ejianc.business.budget.utils.ITreeNodeB;
import com.ejianc.business.budget.vo.BudgetDetailVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TreeNodeBUtil {
    public static <T extends ITreeNodeB> List<T> buildTree(List<T> values) {
        ITreeNodeB parentNode;
        HashMap<Long, ITreeNodeB> nodeMap = new HashMap<Long, ITreeNodeB>();
        ArrayList<ITreeNodeB> result = new ArrayList<ITreeNodeB>();
        ArrayList<ITreeNodeB> emptyValueList = new ArrayList<ITreeNodeB>();
        for (ITreeNodeB value : values) {
            if (null == value.getParentID() || value.getParentID() == 0L) {
                result.add(value);
            } else {
                parentNode = (ITreeNodeB)nodeMap.get(value.getParentID());
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
            nodeMap.put(value.getNodeID(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (ITreeNodeB value : emptyValueList) {
                parentNode = (ITreeNodeB)nodeMap.get(value.getParentID());
                if (parentNode == null) {
                    result.add(value);
                    continue;
                }
                parentNode.getChildren().add(value);
            }
        }
        return result;
    }

    public static List<BudgetDetailVO> buildTreeByTid(List<BudgetDetailVO> values) {
        BudgetDetailVO parentNode;
        HashMap<String, BudgetDetailVO> nodeMap = new HashMap<String, BudgetDetailVO>();
        ArrayList<BudgetDetailVO> result = new ArrayList<BudgetDetailVO>();
        ArrayList<BudgetDetailVO> emptyValueList = new ArrayList<BudgetDetailVO>();
        for (BudgetDetailVO value : values) {
            if (StringUtils.isBlank((CharSequence)value.getTpid())) {
                result.add(value);
            } else {
                parentNode = (BudgetDetailVO)nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    emptyValueList.add(value);
                } else {
                    parentNode.getChildren().add(value);
                }
            }
            nodeMap.put(value.getTid(), value);
        }
        if (!emptyValueList.isEmpty()) {
            for (BudgetDetailVO value : emptyValueList) {
                parentNode = (BudgetDetailVO)nodeMap.get(value.getTpid());
                if (parentNode == null) {
                    result.add(value);
                    continue;
                }
                parentNode.getChildren().add(value);
            }
        }
        return result;
    }
}

