package com.ejianc.business.budget.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 变更记录
 *
 * @author generator
 *
 */
public class BudgetChangeRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long budgetId; // 总计划主键
    private String billCode; // 单据编号
    private String historyCode; // 单据编号
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private BigDecimal baseIncomebudgetMny; // 初始收入预算金额
    private BigDecimal beforeIncomebudgetMny; // 变更前收入预算金额
    private BigDecimal incomebudgetMny; // 收入预算金额
    private BigDecimal changingIncomebudgetMny; // 变更中收入预算金额
    private BigDecimal baseCostbudgetMny; // 初始成本预算金额
    private BigDecimal beforeCostbudgetMny; // 变更前成本预算金额
    private BigDecimal costbudgetMny; // 成本预算金额
    private BigDecimal changingCostbudgetMny; // 变更中成本预算金额
    private BigDecimal baseLaborMny; // 初始人工费
    private BigDecimal beforeLaborMny; // 变更前人工费
    private BigDecimal laborMny; // 人工费
    private BigDecimal changingLaborMny; // 变更中人工费
    private BigDecimal baseMaterialMny; // 初始材料费
    private BigDecimal beforeMaterialMny; // 变更前材料费
    private BigDecimal materialMny; // 材料费
    private BigDecimal changingMaterialMny; // 变更中材料费
    private BigDecimal baseManageRate; // 初始管理费率
    private BigDecimal beforeManageRate; // 变更前管理费率
    private BigDecimal manageRate; // 管理费率
    private BigDecimal changingManageRate; // 变更中管理费率
    private BigDecimal baseManageMny; // 初始管理费
    private BigDecimal beforeManageMny; // 变更前管理费
    private BigDecimal manageMny; // 管理费
    private BigDecimal changingManageMny; // 变更中管理费
    private BigDecimal baseIncomebudgetAdjustMny; // 初始收入预算调整金额
    private BigDecimal beforeIncomebudgetAdjustMny; // 变更前收入预算调整金额
    private BigDecimal incomebudgetAdjustMny; // 收入预算调整金额
    private BigDecimal changingIncomebudgetAdjustMny; // 变更中收入预算调整金额
    private String changeReason; // 变更原因(1-业主原因，2-施工方原因，3-其他)
    private String changeDescription; // 变更描述
    private Integer changeVersion; // 变更版本
    private Integer billState; // 单据状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date usedTime; // 生效时间

    /**
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getHistoryCode() {
        return historyCode;
    }

    public void setHistoryCode(String historyCode) {
        this.historyCode = historyCode;
    }

    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 变更原因(1-业主原因，2-施工方原因，3-其他)
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因(1-业主原因，2-施工方原因，3-其他)
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 变更描述
     */
    public String getChangeDescription() {
        return changeDescription;
    }

    /**
     * 变更描述
     */
    public void setChangeDescription(String changeDescription) {
        this.changeDescription = changeDescription;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public BigDecimal getBaseIncomebudgetMny() {
        return baseIncomebudgetMny;
    }

    public void setBaseIncomebudgetMny(BigDecimal baseIncomebudgetMny) {
        this.baseIncomebudgetMny = baseIncomebudgetMny;
    }

    public BigDecimal getBeforeIncomebudgetMny() {
        return beforeIncomebudgetMny;
    }

    public void setBeforeIncomebudgetMny(BigDecimal beforeIncomebudgetMny) {
        this.beforeIncomebudgetMny = beforeIncomebudgetMny;
    }

    public BigDecimal getIncomebudgetMny() {
        return incomebudgetMny;
    }

    public void setIncomebudgetMny(BigDecimal incomebudgetMny) {
        this.incomebudgetMny = incomebudgetMny;
    }

    public BigDecimal getChangingIncomebudgetMny() {
        return changingIncomebudgetMny;
    }

    public void setChangingIncomebudgetMny(BigDecimal changingIncomebudgetMny) {
        this.changingIncomebudgetMny = changingIncomebudgetMny;
    }

    public BigDecimal getBaseCostbudgetMny() {
        return baseCostbudgetMny;
    }

    public void setBaseCostbudgetMny(BigDecimal baseCostbudgetMny) {
        this.baseCostbudgetMny = baseCostbudgetMny;
    }

    public BigDecimal getBeforeCostbudgetMny() {
        return beforeCostbudgetMny;
    }

    public void setBeforeCostbudgetMny(BigDecimal beforeCostbudgetMny) {
        this.beforeCostbudgetMny = beforeCostbudgetMny;
    }

    public BigDecimal getCostbudgetMny() {
        return costbudgetMny;
    }

    public void setCostbudgetMny(BigDecimal costbudgetMny) {
        this.costbudgetMny = costbudgetMny;
    }

    public BigDecimal getChangingCostbudgetMny() {
        return changingCostbudgetMny;
    }

    public void setChangingCostbudgetMny(BigDecimal changingCostbudgetMny) {
        this.changingCostbudgetMny = changingCostbudgetMny;
    }

    public BigDecimal getBaseLaborMny() {
        return baseLaborMny;
    }

    public void setBaseLaborMny(BigDecimal baseLaborMny) {
        this.baseLaborMny = baseLaborMny;
    }

    public BigDecimal getBeforeLaborMny() {
        return beforeLaborMny;
    }

    public void setBeforeLaborMny(BigDecimal beforeLaborMny) {
        this.beforeLaborMny = beforeLaborMny;
    }

    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }

    public BigDecimal getChangingLaborMny() {
        return changingLaborMny;
    }

    public void setChangingLaborMny(BigDecimal changingLaborMny) {
        this.changingLaborMny = changingLaborMny;
    }

    public BigDecimal getBaseMaterialMny() {
        return baseMaterialMny;
    }

    public void setBaseMaterialMny(BigDecimal baseMaterialMny) {
        this.baseMaterialMny = baseMaterialMny;
    }

    public BigDecimal getBeforeMaterialMny() {
        return beforeMaterialMny;
    }

    public void setBeforeMaterialMny(BigDecimal beforeMaterialMny) {
        this.beforeMaterialMny = beforeMaterialMny;
    }

    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }

    public BigDecimal getChangingMaterialMny() {
        return changingMaterialMny;
    }

    public void setChangingMaterialMny(BigDecimal changingMaterialMny) {
        this.changingMaterialMny = changingMaterialMny;
    }

    public BigDecimal getBaseManageRate() {
        return baseManageRate;
    }

    public void setBaseManageRate(BigDecimal baseManageRate) {
        this.baseManageRate = baseManageRate;
    }

    public BigDecimal getBeforeManageRate() {
        return beforeManageRate;
    }

    public void setBeforeManageRate(BigDecimal beforeManageRate) {
        this.beforeManageRate = beforeManageRate;
    }

    public BigDecimal getManageRate() {
        return manageRate;
    }

    public void setManageRate(BigDecimal manageRate) {
        this.manageRate = manageRate;
    }

    public BigDecimal getChangingManageRate() {
        return changingManageRate;
    }

    public void setChangingManageRate(BigDecimal changingManageRate) {
        this.changingManageRate = changingManageRate;
    }

    public BigDecimal getBaseManageMny() {
        return baseManageMny;
    }

    public void setBaseManageMny(BigDecimal baseManageMny) {
        this.baseManageMny = baseManageMny;
    }

    public BigDecimal getBeforeManageMny() {
        return beforeManageMny;
    }

    public void setBeforeManageMny(BigDecimal beforeManageMny) {
        this.beforeManageMny = beforeManageMny;
    }

    public BigDecimal getManageMny() {
        return manageMny;
    }

    public void setManageMny(BigDecimal manageMny) {
        this.manageMny = manageMny;
    }

    public BigDecimal getChangingManageMny() {
        return changingManageMny;
    }

    public void setChangingManageMny(BigDecimal changingManageMny) {
        this.changingManageMny = changingManageMny;
    }

    public BigDecimal getBaseIncomebudgetAdjustMny() {
        return baseIncomebudgetAdjustMny;
    }

    public void setBaseIncomebudgetAdjustMny(BigDecimal baseIncomebudgetAdjustMny) {
        this.baseIncomebudgetAdjustMny = baseIncomebudgetAdjustMny;
    }

    public BigDecimal getBeforeIncomebudgetAdjustMny() {
        return beforeIncomebudgetAdjustMny;
    }

    public void setBeforeIncomebudgetAdjustMny(BigDecimal beforeIncomebudgetAdjustMny) {
        this.beforeIncomebudgetAdjustMny = beforeIncomebudgetAdjustMny;
    }

    public BigDecimal getIncomebudgetAdjustMny() {
        return incomebudgetAdjustMny;
    }

    public void setIncomebudgetAdjustMny(BigDecimal incomebudgetAdjustMny) {
        this.incomebudgetAdjustMny = incomebudgetAdjustMny;
    }

    public BigDecimal getChangingIncomebudgetAdjustMny() {
        return changingIncomebudgetAdjustMny;
    }

    public void setChangingIncomebudgetAdjustMny(BigDecimal changingIncomebudgetAdjustMny) {
        this.changingIncomebudgetAdjustMny = changingIncomebudgetAdjustMny;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 生效时间
     */
    public Date getUsedTime() {
        return usedTime;
    }

    /**
     * 生效时间
     */
    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

}
