package com.ejianc.business.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 施工计划
 * 
 * @author generator
 * 
 */
public class BudgetPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long budgetId; // 预算id
    private String startMonth; // 开始月份
    private String endMonth; // 结束月份
    private String monthEndDate; // 每月截止日期
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private Integer changeVersion; // 变更版本
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private Integer billState; // 单据状态
    private String changeReason; // 变更原因
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private List<Long> selectedKeys; // 选中楼号

    public List<Long> getSelectedKeys() {
        return selectedKeys;
    }

    public void setSelectedKeys(List<Long> selectedKeys) {
        this.selectedKeys = selectedKeys;
    }

    private List<BudgetDetailTemVO> detailList = new ArrayList<>();


    private List<String> monthColumn = new ArrayList<>();


    public List<String> getMonthColumn() {
        return monthColumn;
    }

    public void setMonthColumn(List<String> monthColumn) {
        this.monthColumn = monthColumn;
    }

    public List<BudgetDetailTemVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<BudgetDetailTemVO> detailList) {
        this.detailList = detailList;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 预算id
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算id
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 开始月份
     */
    public String getStartMonth() {
        return startMonth;
    }

    /**
     * 开始月份
     */
    public void setStartMonth(String startMonth) {
        this.startMonth = startMonth;
    }
    /**
     * 结束月份
     */
    public String getEndMonth() {
        return endMonth;
    }

    /**
     * 结束月份
     */
    public void setEndMonth(String endMonth) {
        this.endMonth = endMonth;
    }
    /**
     * 每月截止日期
     */
    public String getMonthEndDate() {
        return monthEndDate;
    }

    /**
     * 每月截止日期
     */
    public void setMonthEndDate(String monthEndDate) {
        this.monthEndDate = monthEndDate;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 组织主键
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织主键
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    
}
