package com.ejianc.business.budget.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * @author songlx
 * @version 1.0
 * @description: PlanProfitVO
 * @date 2021/10/21
 */
public class PlanProfitVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织
    private String parentOrgName; // 组织名称
    private Long budgetId; // 预算id

    private BigDecimal incomebudgetMny; // 收入预算金额 - 计划产值

    private BigDecimal productionMny; // 产值工程量 - 完成产值

    private BigDecimal laborMny; // 人工费 - 计划人工费

    private BigDecimal realCost; // 实际成本
    private BigDecimal computeCost; // 反推实际成本
    private BigDecimal curCost; // 上报实际成本
    private BigDecimal subCost; // 分包实际成本

    private BigDecimal materialMny; // 材料费
    private BigDecimal materialCost; // 材料实际成本

    private BigDecimal manageMny; // 管理费
    private BigDecimal realManageMny; // 实际管理费
    private BigDecimal equipPurchaseCost; // 设备采购成本
    private BigDecimal equipRentCost; // 设备租赁成本
    private BigDecimal loadReimburseCost; // 备用金报销
    private BigDecimal payReimburseCost; // 报销申请

    private BigDecimal taxFee; // 税金
    private BigDecimal realTaxFee; // 实际税金
    private BigDecimal taxRatio; // 综合税负

    private BigDecimal planProfit; // 计划净利润
    private String planProfitTxt; // 计划净利润
    private BigDecimal costbudgetMny; // 成本预算金额

    private BigDecimal realProfit; // 实际净利润


    private BigDecimal basePlanProfit; // 首次计划净利润
    private String basePlanProfitTxt; // 首次计划净利润
    private BigDecimal baseIncomebudgetMny; // 初始收入预算金额
    private BigDecimal baseCostbudgetMny; // 初始成本预算金额


    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public BigDecimal getIncomebudgetMny() {
        return incomebudgetMny;
    }

    public void setIncomebudgetMny(BigDecimal incomebudgetMny) {
        this.incomebudgetMny = incomebudgetMny;
    }

    public BigDecimal getProductionMny() {
        return productionMny;
    }

    public void setProductionMny(BigDecimal productionMny) {
        this.productionMny = productionMny;
    }

    public BigDecimal getLaborMny() {
        return laborMny;
    }

    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }

    public BigDecimal getRealCost() {
        return realCost;
    }

    public void setRealCost(BigDecimal realCost) {
        this.realCost = realCost;
    }

    public BigDecimal getComputeCost() {
        return computeCost;
    }

    public void setComputeCost(BigDecimal computeCost) {
        this.computeCost = computeCost;
    }

    public BigDecimal getCurCost() {
        return curCost;
    }

    public void setCurCost(BigDecimal curCost) {
        this.curCost = curCost;
    }

    public BigDecimal getSubCost() {
        return subCost;
    }

    public void setSubCost(BigDecimal subCost) {
        this.subCost = subCost;
    }

    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }

    public BigDecimal getMaterialCost() {
        return materialCost;
    }

    public void setMaterialCost(BigDecimal materialCost) {
        this.materialCost = materialCost;
    }

    public BigDecimal getManageMny() {
        return manageMny;
    }

    public void setManageMny(BigDecimal manageMny) {
        this.manageMny = manageMny;
    }

    public BigDecimal getRealManageMny() {
        return realManageMny;
    }

    public void setRealManageMny(BigDecimal realManageMny) {
        this.realManageMny = realManageMny;
    }

    public BigDecimal getEquipPurchaseCost() {
        return equipPurchaseCost;
    }

    public void setEquipPurchaseCost(BigDecimal equipPurchaseCost) {
        this.equipPurchaseCost = equipPurchaseCost;
    }

    public BigDecimal getEquipRentCost() {
        return equipRentCost;
    }

    public void setEquipRentCost(BigDecimal equipRentCost) {
        this.equipRentCost = equipRentCost;
    }

    public BigDecimal getLoadReimburseCost() {
        return loadReimburseCost;
    }

    public void setLoadReimburseCost(BigDecimal loadReimburseCost) {
        this.loadReimburseCost = loadReimburseCost;
    }

    public BigDecimal getPayReimburseCost() {
        return payReimburseCost;
    }

    public void setPayReimburseCost(BigDecimal payReimburseCost) {
        this.payReimburseCost = payReimburseCost;
    }

    public BigDecimal getTaxFee() {
        return taxFee;
    }

    public void setTaxFee(BigDecimal taxFee) {
        this.taxFee = taxFee;
    }

    public BigDecimal getRealTaxFee() {
        return realTaxFee;
    }

    public void setRealTaxFee(BigDecimal realTaxFee) {
        this.realTaxFee = realTaxFee;
    }

    public BigDecimal getTaxRatio() {
        return taxRatio;
    }

    public void setTaxRatio(BigDecimal taxRatio) {
        this.taxRatio = taxRatio;
    }

    public BigDecimal getPlanProfit() {
        return planProfit;
    }

    public void setPlanProfit(BigDecimal planProfit) {
        this.planProfit = planProfit;
    }

    public BigDecimal getCostbudgetMny() {
        return costbudgetMny;
    }

    public void setCostbudgetMny(BigDecimal costbudgetMny) {
        this.costbudgetMny = costbudgetMny;
    }

    public BigDecimal getRealProfit() {
        return realProfit;
    }

    public void setRealProfit(BigDecimal realProfit) {
        this.realProfit = realProfit;
    }

    public BigDecimal getBasePlanProfit() {
        return basePlanProfit;
    }

    public void setBasePlanProfit(BigDecimal basePlanProfit) {
        this.basePlanProfit = basePlanProfit;
    }

    public String getBasePlanProfitTxt() {
        return basePlanProfitTxt;
    }

    public void setBasePlanProfitTxt(String basePlanProfitTxt) {
        this.basePlanProfitTxt = basePlanProfitTxt;
    }

    public BigDecimal getBaseIncomebudgetMny() {
        return baseIncomebudgetMny;
    }

    public void setBaseIncomebudgetMny(BigDecimal baseIncomebudgetMny) {
        this.baseIncomebudgetMny = baseIncomebudgetMny;
    }

    public BigDecimal getBaseCostbudgetMny() {
        return baseCostbudgetMny;
    }

    public void setBaseCostbudgetMny(BigDecimal baseCostbudgetMny) {
        this.baseCostbudgetMny = baseCostbudgetMny;
    }

    public String getPlanProfitTxt() {
        return planProfitTxt;
    }

    public void setPlanProfitTxt(String planProfitTxt) {
        this.planProfitTxt = planProfitTxt;
    }
}
