package com.ejianc.business.budget.utils;

import com.ejianc.framework.core.util.ComputeUtil;

import java.math.BigDecimal;
import java.util.*;

public class ExcelImportUtil {
    //构造树形
    public static List<Map<String, Object>> treeData(List<Map> list) {
        List<Map<String, Object>> resp = new ArrayList();
        List<String> rootItems = new ArrayList();
        Map<String, Map<String, Object>> listMap = new HashMap();
        Iterator var4 = list.iterator();

        Map item;
        while(var4.hasNext()) {
            item = (Map)var4.next();
            listMap.put(item.get("tid").toString(), item);
        }

        for(int i = 0; i < list.size(); ++i) {
            item = (Map)list.get(i);
            String parentId = item.get("tpid") != null ? item.get("tpid").toString() : "";
            Map<String, Object> parent = (Map)listMap.get(parentId);
            if (parent != null) {
                List<Map<String, Object>> child = (List)parent.get("children");
                if (child != null) {
                    child.add(item);
                } else {
                    List<Map<String, Object>> children = new ArrayList();
                    children.add(item);
                    parent.put("children", children);
                }
            } else {
                rootItems.add(item.get("tid").toString());
            }
        }

        var4 = rootItems.iterator();

        while(var4.hasNext()) {
            String rootId = (String)var4.next();
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    public static List<Map<String, Object>> dealWeightScale(List<Map<String, Object>> list){
        for(Map<String, Object> map: list){
            List<Map<String, Object>> child = (List)map.get("children");
            if(child != null){
                List<Map<String, Object>> mapList = dealWeightScale(child);
                if((Integer) map.get("levelNo") == 3){
                    BigDecimal total = BigDecimal.ZERO;
                    for(Map<String, Object> childMap : mapList){
                        if(null != childMap.get("materialWeightScale")){
                            total = ComputeUtil.safeAdd(total, (BigDecimal) childMap.get("materialWeightScale"));
                        }
                    }
                    if(total.compareTo(new BigDecimal(100)) != 0){
                        if(!(Boolean) map.get("importFlag")){
                            map.put("warnType", map.get("warnType") + ",权重和不为1");
                        }else{
                            map.put("importFlag", false);
                            map.put("warnType", "权重和不为1");
                        }
                        for(Map<String, Object> childMap : mapList){
                            if(!(Boolean) map.get("importFlag")){
                                childMap.put("warnType", map.get("warnType") + ",权重和不为1");
                            }else{
                                childMap.put("importFlag", false);
                                childMap.put("warnType", "权重和不为1");
                            }
                        }
                    }
                }
                map.put("children",mapList);
            }
        }
        return list;
    }
    // 分割能否导入的数据
    public static List<List<Map<String, Object>>> separate(List<Map<String, Object>> list,List<Map<String, Object>> falseList){
        for(int i= 0;i<list.size();i++){
            Map<String, Object> stringObjectMap = list.get(i);
            if((Boolean)stringObjectMap.get("importFlag") == false) {// 错误行
                falseList.add(stringObjectMap);
                list.remove(i);
                i--;
            }else{
                List<Map<String, Object>> child =(List)stringObjectMap.get("children");
                if(child!=null){
                    stringObjectMap.put("children",separate(child,falseList).get(0));
                }
            }
        }
        List<List<Map<String, Object>>> lists=new ArrayList<>();
        lists.add(list);
        lists.add(falseList);
        return lists;
    }

    // 树转list
    public static List<Map<String, Object>> treeToList(List<Map<String, Object>> list){
        List<Map<String, Object>> reList=new ArrayList<>();
        for(Map<String, Object> stringObjectMap:list){
            List<Map<String, Object>> child =(List)stringObjectMap.get("children");
            String warnType=(String)stringObjectMap.get("warnType");
            if(null == warnType || warnType.length()<1){
                stringObjectMap.put("warnType","上级或下级存在错误！");
            }
            stringObjectMap.put("id",stringObjectMap.get("tid"));
            if(null!=child){// 有下级
                List<Map<String, Object>> childrenList=treeToList(child);
                stringObjectMap.put("children",null);
                reList.add(stringObjectMap);
                reList.addAll(childrenList);
            }else{
                reList.add(stringObjectMap);
            }
        }
        return reList;
    }

    // 树转list
    public static List<Map<String, Object>> treeToListNoWarn(List<Map<String, Object>> list){
        List<Map<String, Object>> reList=new ArrayList<>();
        for(Map<String, Object> stringObjectMap:list){
            List<Map<String, Object>> child =(List)stringObjectMap.get("children");
            if(null!=child){// 有下级
                List<Map<String, Object>> childrenList = treeToListNoWarn(child);
                stringObjectMap.put("children",null);
                reList.add(stringObjectMap);
                reList.addAll(childrenList);
            }else{
                reList.add(stringObjectMap);
            }
        }
        return reList;
    }
}
