package com.ejianc.business.budget.vo;

import com.ejianc.business.budget.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @Author zhangwx
 * @Date 2020/5/27 分包合同明细
 * @Description ContractDetailVO
 */

public class BudgetSubRefVO extends BaseVO implements ITreeNodeB {

    private static final long serialVersionUID = 2779265683222435571L;


    /**
     * 序号
     */
    private String treeIndex;
    private String buildingNo; // 楼号
    private String buildContent; // 施工内容

    /**
     * 预算明细ID
     */
    private Long budgetDetailId;
    /**
     * 清单编码
     */
    private String code;

    /**
     * 清单名称
     */
    private String name;


    /**
     * 工程量
     */
    private BigDecimal num;


    /**
     * 父ID
     */
    private Long parentId;

    /**
     * 是否末级
     */
    private Boolean leafFlag;

    private String tid;
    private String tpid;

    private String shadowId;
    private List<ITreeNodeB> children;


    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getBuildingNo() {
        return buildingNo;
    }

    public void setBuildingNo(String buildingNo) {
        this.buildingNo = buildingNo;
    }

    public String getBuildContent() {
        return buildContent;
    }

    public void setBuildContent(String buildContent) {
        this.buildContent = buildContent;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Boolean getLeafFlag() {
        return leafFlag;
    }

    public void setLeafFlag(Boolean leafFlag) {
        this.leafFlag = leafFlag;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public String getShadowId() {
        return shadowId;
    }

    public void setShadowId(String shadowId) {
        this.shadowId = shadowId;
    }

    public Long getBudgetDetailId() {
        return budgetDetailId;
    }

    public void setBudgetDetailId(Long budgetDetailId) {
        this.budgetDetailId = budgetDetailId;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;

    }
}
