package com.ejianc.business.budget.api;


import com.ejianc.business.budget.hystrix.BudgetHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;


/**
 * 预算的rpc服务
 */
@FeignClient(name = "ejc-probudget-web", url = "${common.env.feign-client-url}", path = "ejc-probudget-web", fallback = BudgetHystrix.class)
public interface IBudgetApi {


    @GetMapping(value = "/api/budget/getLaborCostMny")
    CommonResponse<BigDecimal> getLaborCostMny(@RequestParam("projectId") Long projectId, @RequestParam("settleDate") String settleDate);
    /**
     * 查询对应项目的机械费用
     * @param projectId
     * @return
     */
    @GetMapping(value = "getMachineryMnyByProjectId")
    public CommonResponse<BigDecimal> getMachineryMnyByProjectId(@RequestParam("projectId") Long projectId);
}
