package com.ejianc.business.plan.vo;

import com.ejianc.business.budget.vo.BudgetVO;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.UseApplyFinishVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 计算VO
 * @date 2021/9/10
 */
public class RecalculateVO implements Serializable {

    private Long projectId; // 项目
    private Long budgetId; // 预算id

    private String startMonth; // 开始月份
    private String endMonth; // 结束月份
    private String monthEndDate; // 每月截止日期

    private Map<String, Object> queryParam; //查询到货量的

    private BudgetVO budgetVO;


    private List<InstoreMaterialVO> instoreMaterialVOS;

    /**
     * 项目用料申请完成标识查询vo
     */
    private List<UseApplyFinishVO> useApplyFinishVOS;


    //物料的 计划工程量 * 耗量  项目用料申请使用
    Map<Long, BigDecimal> planNumMap = new HashMap<>();


    //物料的 预算用量map
    Map<Long, BigDecimal> budgetNumMap = new HashMap<>();


    public List<UseApplyFinishVO> getUseApplyFinishVOS() {
        return useApplyFinishVOS;
    }


    public BudgetVO getBudgetVO() {
        return budgetVO;
    }

    public void setBudgetVO(BudgetVO budgetVO) {
        this.budgetVO = budgetVO;
    }

    public void setUseApplyFinishVOS(List<UseApplyFinishVO> useApplyFinishVOS) {
        this.useApplyFinishVOS = useApplyFinishVOS;
    }

    public Map<Long, BigDecimal> getPlanNumMap() {
        return planNumMap;
    }

    public Map<Long, BigDecimal> getBudgetNumMap() {
        return budgetNumMap;
    }

    public void setBudgetNumMap(Map<Long, BigDecimal> budgetNumMap) {
        this.budgetNumMap = budgetNumMap;
    }

    public void setPlanNumMap(Map<Long, BigDecimal> planNumMap) {
        this.planNumMap = planNumMap;
    }

    public RecalculateVO() {
    }

    public static RecalculateVO intsance(Long projectId, Long budgetId) {
        return new RecalculateVO(projectId, budgetId);
    }

    public RecalculateVO(Long projectId, Long budgetId) {
        this.projectId = projectId;
        this.budgetId = budgetId;
    }

    public List<InstoreMaterialVO> getInstoreMaterialVOS() {
        return instoreMaterialVOS;
    }

    public void setInstoreMaterialVOS(List<InstoreMaterialVO> instoreMaterialVOS) {
        this.instoreMaterialVOS = instoreMaterialVOS;
    }

    public Map<String, Object> getQueryParam() {
        return queryParam;
    }

    public void setQueryParam(Map<String, Object> queryParam) {
        this.queryParam = queryParam;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getBudgetId() {
        return budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public String getStartMonth() {
        return startMonth;
    }

    public void setStartMonth(String startMonth) {
        this.startMonth = startMonth;
    }

    public String getEndMonth() {
        return endMonth;
    }

    public void setEndMonth(String endMonth) {
        this.endMonth = endMonth;
    }

    public String getMonthEndDate() {
        return monthEndDate;
    }

    public void setMonthEndDate(String monthEndDate) {
        this.monthEndDate = monthEndDate;
    }


}
