package com.ejianc.business.budget.vo;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.budget.vo.BudgetRecordDetailVO;

/**
 * 预算记录
 *
 * @author generator
 *
 */
public class BudgetRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long budgetId; // 预算ID
    private String billCode; // 单据编码
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private BigDecimal baseIncomebudgetMny; // 初始收入预算金额
    private BigDecimal beforeIncomebudgetMny; // 变更前收入预算金额
    private BigDecimal incomebudgetMny; // 收入预算金额
    private BigDecimal changingIncomebudgetMny; // 变更中收入预算金额
    private BigDecimal baseCostbudgetMny; // 初始成本预算金额
    private BigDecimal beforeCostbudgetMny; // 变更前成本预算金额
    private BigDecimal costbudgetMny; // 成本预算金额
    private BigDecimal changingCostbudgetMny; // 变更中成本预算金额
    private BigDecimal baseLaborMny; // 初始人工费
    private BigDecimal beforeLaborMny; // 变更前人工费
    private BigDecimal laborMny; // 人工费
    private BigDecimal changingLaborMny; // 变更中人工费
    private BigDecimal baseMaterialMny; // 初始材料费
    private BigDecimal beforeMaterialMny; // 变更前材料费
    private BigDecimal materialMny; // 材料费
    private BigDecimal changingMaterialMny; // 变更中材料费
    private BigDecimal baseManageRate; // 初始管理费率
    private BigDecimal beforeManageRate; // 变更前管理费率
    private BigDecimal manageRate; // 管理费率
    private BigDecimal changingManageRate; // 变更中管理费率
    private BigDecimal baseManageMny; // 初始管理费
    private BigDecimal beforeManageMny; // 变更前管理费
    private BigDecimal manageMny; // 管理费
    private BigDecimal changingManageMny; // 变更中管理费
    private BigDecimal baseIncomebudgetAdjustMny; // 初始收入预算调整金额
    private BigDecimal beforeIncomebudgetAdjustMny; // 变更前收入预算调整金额
    private BigDecimal incomebudgetAdjustMny; // 收入预算调整金额
    private BigDecimal changingIncomebudgetAdjustMny; // 变更中收入预算调整金额
    private String memo; // 分包内容
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private Integer billState; // 单据状态（审批必须字段）
    private String area; //所属区域
    private BigDecimal machineryMny; // 机械费

    private BigDecimal beforeMachineryMny; // 变更前机械费
    private BigDecimal baseMachineryMny; // 初始机械费
    private List<BudgetRecordDetailVO> budgetRecordDetailVos = new ArrayList<>(); // 预算记录明细

    public BigDecimal getBeforeMachineryMny() {
        return beforeMachineryMny;
    }

    public void setBeforeMachineryMny(BigDecimal beforeMachineryMny) {
        this.beforeMachineryMny = beforeMachineryMny;
    }

    public BigDecimal getBaseMachineryMny() {
        return baseMachineryMny;
    }

    public void setBaseMachineryMny(BigDecimal baseMachineryMny) {
        this.baseMachineryMny = baseMachineryMny;
    }

    private BigDecimal taxRatio; // 综合税负
    private BigDecimal taxFee; // 税金

    public BigDecimal getMachineryMny() {
        return machineryMny;
    }

    public void setMachineryMny(BigDecimal machineryMny) {
        this.machineryMny = machineryMny;
    }

    public BigDecimal getTaxRatio() {
        return taxRatio;
    }

    public void setTaxRatio(BigDecimal taxRatio) {
        this.taxRatio = taxRatio;
    }

    public BigDecimal getTaxFee() {
        return taxFee;
    }

    public void setTaxFee(BigDecimal taxFee) {
        this.taxFee = taxFee;
    }
    /**
     * 预算ID
     */
    public Long getBudgetId() {
        return budgetId;
    }

    /**
     * 预算ID
     */
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 初始收入预算金额
     */
    public BigDecimal getBaseIncomebudgetMny() {
        return baseIncomebudgetMny;
    }

    /**
     * 初始收入预算金额
     */
    public void setBaseIncomebudgetMny(BigDecimal baseIncomebudgetMny) {
        this.baseIncomebudgetMny = baseIncomebudgetMny;
    }
    /**
     * 变更前收入预算金额
     */
    public BigDecimal getBeforeIncomebudgetMny() {
        return beforeIncomebudgetMny;
    }

    /**
     * 变更前收入预算金额
     */
    public void setBeforeIncomebudgetMny(BigDecimal beforeIncomebudgetMny) {
        this.beforeIncomebudgetMny = beforeIncomebudgetMny;
    }
    /**
     * 收入预算金额
     */
    public BigDecimal getIncomebudgetMny() {
        return incomebudgetMny;
    }

    /**
     * 收入预算金额
     */
    public void setIncomebudgetMny(BigDecimal incomebudgetMny) {
        this.incomebudgetMny = incomebudgetMny;
    }
    /**
     * 变更中收入预算金额
     */
    public BigDecimal getChangingIncomebudgetMny() {
        return changingIncomebudgetMny;
    }

    /**
     * 变更中收入预算金额
     */
    public void setChangingIncomebudgetMny(BigDecimal changingIncomebudgetMny) {
        this.changingIncomebudgetMny = changingIncomebudgetMny;
    }
    /**
     * 初始成本预算金额
     */
    public BigDecimal getBaseCostbudgetMny() {
        return baseCostbudgetMny;
    }

    /**
     * 初始成本预算金额
     */
    public void setBaseCostbudgetMny(BigDecimal baseCostbudgetMny) {
        this.baseCostbudgetMny = baseCostbudgetMny;
    }
    /**
     * 变更前成本预算金额
     */
    public BigDecimal getBeforeCostbudgetMny() {
        return beforeCostbudgetMny;
    }

    /**
     * 变更前成本预算金额
     */
    public void setBeforeCostbudgetMny(BigDecimal beforeCostbudgetMny) {
        this.beforeCostbudgetMny = beforeCostbudgetMny;
    }
    /**
     * 成本预算金额
     */
    public BigDecimal getCostbudgetMny() {
        return costbudgetMny;
    }

    /**
     * 成本预算金额
     */
    public void setCostbudgetMny(BigDecimal costbudgetMny) {
        this.costbudgetMny = costbudgetMny;
    }
    /**
     * 变更中成本预算金额
     */
    public BigDecimal getChangingCostbudgetMny() {
        return changingCostbudgetMny;
    }

    /**
     * 变更中成本预算金额
     */
    public void setChangingCostbudgetMny(BigDecimal changingCostbudgetMny) {
        this.changingCostbudgetMny = changingCostbudgetMny;
    }
    /**
     * 初始人工费
     */
    public BigDecimal getBaseLaborMny() {
        return baseLaborMny;
    }

    /**
     * 初始人工费
     */
    public void setBaseLaborMny(BigDecimal baseLaborMny) {
        this.baseLaborMny = baseLaborMny;
    }
    /**
     * 变更前人工费
     */
    public BigDecimal getBeforeLaborMny() {
        return beforeLaborMny;
    }

    /**
     * 变更前人工费
     */
    public void setBeforeLaborMny(BigDecimal beforeLaborMny) {
        this.beforeLaborMny = beforeLaborMny;
    }
    /**
     * 人工费
     */
    public BigDecimal getLaborMny() {
        return laborMny;
    }

    /**
     * 人工费
     */
    public void setLaborMny(BigDecimal laborMny) {
        this.laborMny = laborMny;
    }
    /**
     * 变更中人工费
     */
    public BigDecimal getChangingLaborMny() {
        return changingLaborMny;
    }

    /**
     * 变更中人工费
     */
    public void setChangingLaborMny(BigDecimal changingLaborMny) {
        this.changingLaborMny = changingLaborMny;
    }
    /**
     * 初始材料费
     */
    public BigDecimal getBaseMaterialMny() {
        return baseMaterialMny;
    }

    /**
     * 初始材料费
     */
    public void setBaseMaterialMny(BigDecimal baseMaterialMny) {
        this.baseMaterialMny = baseMaterialMny;
    }
    /**
     * 变更前材料费
     */
    public BigDecimal getBeforeMaterialMny() {
        return beforeMaterialMny;
    }

    /**
     * 变更前材料费
     */
    public void setBeforeMaterialMny(BigDecimal beforeMaterialMny) {
        this.beforeMaterialMny = beforeMaterialMny;
    }
    /**
     * 材料费
     */
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    /**
     * 材料费
     */
    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    /**
     * 变更中材料费
     */
    public BigDecimal getChangingMaterialMny() {
        return changingMaterialMny;
    }

    /**
     * 变更中材料费
     */
    public void setChangingMaterialMny(BigDecimal changingMaterialMny) {
        this.changingMaterialMny = changingMaterialMny;
    }
    /**
     * 初始管理费率
     */
    public BigDecimal getBaseManageRate() {
        return baseManageRate;
    }

    /**
     * 初始管理费率
     */
    public void setBaseManageRate(BigDecimal baseManageRate) {
        this.baseManageRate = baseManageRate;
    }
    /**
     * 变更前管理费率
     */
    public BigDecimal getBeforeManageRate() {
        return beforeManageRate;
    }

    /**
     * 变更前管理费率
     */
    public void setBeforeManageRate(BigDecimal beforeManageRate) {
        this.beforeManageRate = beforeManageRate;
    }
    /**
     * 管理费率
     */
    public BigDecimal getManageRate() {
        return manageRate;
    }

    /**
     * 管理费率
     */
    public void setManageRate(BigDecimal manageRate) {
        this.manageRate = manageRate;
    }
    /**
     * 变更中管理费率
     */
    public BigDecimal getChangingManageRate() {
        return changingManageRate;
    }

    /**
     * 变更中管理费率
     */
    public void setChangingManageRate(BigDecimal changingManageRate) {
        this.changingManageRate = changingManageRate;
    }
    /**
     * 初始管理费
     */
    public BigDecimal getBaseManageMny() {
        return baseManageMny;
    }

    /**
     * 初始管理费
     */
    public void setBaseManageMny(BigDecimal baseManageMny) {
        this.baseManageMny = baseManageMny;
    }
    /**
     * 变更前管理费
     */
    public BigDecimal getBeforeManageMny() {
        return beforeManageMny;
    }

    /**
     * 变更前管理费
     */
    public void setBeforeManageMny(BigDecimal beforeManageMny) {
        this.beforeManageMny = beforeManageMny;
    }
    /**
     * 管理费
     */
    public BigDecimal getManageMny() {
        return manageMny;
    }

    /**
     * 管理费
     */
    public void setManageMny(BigDecimal manageMny) {
        this.manageMny = manageMny;
    }
    /**
     * 变更中管理费
     */
    public BigDecimal getChangingManageMny() {
        return changingManageMny;
    }

    /**
     * 变更中管理费
     */
    public void setChangingManageMny(BigDecimal changingManageMny) {
        this.changingManageMny = changingManageMny;
    }
    /**
     * 初始收入预算调整金额
     */
    public BigDecimal getBaseIncomebudgetAdjustMny() {
        return baseIncomebudgetAdjustMny;
    }

    /**
     * 初始收入预算调整金额
     */
    public void setBaseIncomebudgetAdjustMny(BigDecimal baseIncomebudgetAdjustMny) {
        this.baseIncomebudgetAdjustMny = baseIncomebudgetAdjustMny;
    }
    /**
     * 变更前收入预算调整金额
     */
    public BigDecimal getBeforeIncomebudgetAdjustMny() {
        return beforeIncomebudgetAdjustMny;
    }

    /**
     * 变更前收入预算调整金额
     */
    public void setBeforeIncomebudgetAdjustMny(BigDecimal beforeIncomebudgetAdjustMny) {
        this.beforeIncomebudgetAdjustMny = beforeIncomebudgetAdjustMny;
    }
    /**
     * 收入预算调整金额
     */
    public BigDecimal getIncomebudgetAdjustMny() {
        return incomebudgetAdjustMny;
    }

    /**
     * 收入预算调整金额
     */
    public void setIncomebudgetAdjustMny(BigDecimal incomebudgetAdjustMny) {
        this.incomebudgetAdjustMny = incomebudgetAdjustMny;
    }
    /**
     * 变更中收入预算调整金额
     */
    public BigDecimal getChangingIncomebudgetAdjustMny() {
        return changingIncomebudgetAdjustMny;
    }

    /**
     * 变更中收入预算调整金额
     */
    public void setChangingIncomebudgetAdjustMny(BigDecimal changingIncomebudgetAdjustMny) {
        this.changingIncomebudgetAdjustMny = changingIncomebudgetAdjustMny;
    }
    /**
     * 分包内容
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 分包内容
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 变更单号
     */
    public String getChangeCode() {
        return changeCode;
    }

    /**
     * 变更单号
     */
    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更主键
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public Integer getChangeStatus() {
        return changeStatus;
    }

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

     /**
      * 预算记录明细
      */
     public List<BudgetRecordDetailVO> getBudgetRecordDetailVos() {
        return budgetRecordDetailVos;
     }

     /**
      * 预算记录明细
      */
     public void setBudgetRecordDetailVos(List<BudgetRecordDetailVO> budgetRecordDetailVos) {
        this.budgetRecordDetailVos = budgetRecordDetailVos;
     }
}
