/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.plan.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.PlanCostVO;
import com.ejianc.business.budget.vo.PlanProfitVO;
import com.ejianc.business.plan.service.PlanReportService;
import com.ejianc.business.plan.util.DateUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"planReport"})
public class PlanReportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Integer BATCH_SIZE = 1000;
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String INDEX_NAME_COST = "ejc_probudget_report_cost";
    private static final String INDEX_NAME_PROFIT = "ejc_probudget_report_profit";
    @Autowired(required=false)
    private RestHighLevelClient client;
    @Autowired
    private PlanReportService planReportService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(path={"/initCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> initCost() {
        try {
            XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(INDEX_NAME_COST).startObject("properties");
            mapping.startObject("tenantId").field("type", "text").endObject();
            mapping.startObject("projectId").field("type", "text").endObject();
            mapping.startObject("projectName").field("type", "keyword").endObject();
            mapping.startObject("orgId").field("type", "text").endObject();
            mapping.startObject("orgName").field("type", "keyword").endObject();
            mapping.startObject("parentOrgId").field("type", "text").endObject();
            mapping.startObject("parentOrgName").field("type", "keyword").endObject();
            mapping.startObject("budgetId").field("type", "text").endObject();
            mapping.startObject("yyearMonth").field("type", "text").endObject();
            mapping.startObject("budgetPrice").field("type", "long").endObject();
            mapping.startObject("budgetNum").field("type", "long").endObject();
            mapping.startObject("realPrice").field("type", "long").endObject();
            mapping.startObject("realNum").field("type", "long").endObject();
            mapping.startObject("computeNum").field("type", "long").endObject();
            mapping.startObject("curNum").field("type", "long").endObject();
            mapping.startObject("planBudgetCost").field("type", "long").endObject();
            mapping.startObject("manageRate").field("type", "long").endObject();
            mapping.startObject("manageRatePlus").field("type", "long").endObject();
            mapping.startObject("realCost").field("type", "long").endObject();
            mapping.startObject("computeCost").field("type", "long").endObject();
            mapping.startObject("curCost").field("type", "long").endObject();
            mapping.startObject("subCost").field("type", "long").endObject();
            mapping.startObject("materialCost").field("type", "long").endObject();
            mapping.startObject("equipPurchaseCost").field("type", "long").endObject();
            mapping.startObject("equipRentCost").field("type", "long").endObject();
            mapping.startObject("loadReimburseCost").field("type", "long").endObject();
            mapping.startObject("payReimburseCost").field("type", "long").endObject();
            mapping.startObject("finishBudget").field("type", "long").endObject();
            mapping.startObject("planDiff").field("type", "long").endObject();
            mapping.startObject("costDiff").field("type", "long").endObject();
            mapping.startObject("workAchi").field("type", "long").endObject();
            mapping.startObject("costAchi").field("type", "long").endObject();
            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{INDEX_NAME_COST}).type(INDEX_NAME_COST).source(mapping);
            this.client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            return CommonResponse.success();
        }
        catch (IOException e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    private CommonResponse<JSONObject> loadCostList2ES(Long tenantid, Long orgId) {
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", tenantid);
        map.put("orgIds", orgIds);
        List<PlanCostVO> list = this.planReportService.loadCostList2ES(map);
        try {
            this.deleteESData(INDEX_NAME_COST, tenantid, orgId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PlanCostVO vo : list) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("tenantId", String.valueOf(vo.getTenantId()));
            dataMap.put("projectId", String.valueOf(vo.getProjectId()));
            dataMap.put("projectName", vo.getProjectName());
            dataMap.put("orgId", String.valueOf(vo.getOrgId()));
            dataMap.put("orgName", vo.getOrgName());
            dataMap.put("parentOrgId", String.valueOf(vo.getParentOrgId()));
            dataMap.put("parentOrgName", vo.getParentOrgName());
            dataMap.put("budgetId", String.valueOf(vo.getBudgetId()));
            dataMap.put("yyearMonth", vo.getYyearMonth());
            dataMap.put("budgetPrice", vo.getBudgetPrice());
            dataMap.put("budgetNum", vo.getBudgetNum());
            dataMap.put("realPrice", vo.getRealPrice());
            dataMap.put("realNum", vo.getRealNum());
            dataMap.put("computeNum", vo.getComputeNum());
            dataMap.put("curNum", vo.getCurNum());
            dataMap.put("planBudgetCost", vo.getPlanBudgetCost());
            dataMap.put("manageRate", vo.getManageRate());
            dataMap.put("manageRatePlus", vo.getManageRatePlus());
            dataMap.put("realCost", vo.getRealCost());
            dataMap.put("computeCost", vo.getComputeCost());
            dataMap.put("curCost", vo.getCurCost());
            dataMap.put("subCost", vo.getSubCost());
            dataMap.put("materialCost", vo.getMaterialCost());
            dataMap.put("equipPurchaseCost", vo.getEquipPurchaseCost());
            dataMap.put("equipRentCost", vo.getEquipRentCost());
            dataMap.put("loadReimburseCost", vo.getLoadReimburseCost());
            dataMap.put("payReimburseCost", vo.getPayReimburseCost());
            dataMap.put("finishBudget", vo.getFinishBudget());
            dataMap.put("planDiff", vo.getPlanDiff());
            dataMap.put("costDiff", vo.getCostDiff());
            dataMap.put("workAchi", vo.getWorkAchi());
            dataMap.put("costAchi", vo.getCostAchi());
            IndexRequest indexRequest = new IndexRequest(INDEX_NAME_COST);
            indexRequest.id(String.valueOf(vo.getProjectId()));
            indexRequest.source(dataMap, XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        if (bulkRequest.requests().size() > 0) {
            try {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        return CommonResponse.success((String)("\u6210\u672c\u63a7\u5236\u91cd\u65b0\u52a0\u8f7d\u6210\u529f\u6761\u6570: " + bulkRequest.requests().size()));
    }

    @RequestMapping(value={"/reloadCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanCostVO> reloadCost(@RequestBody QueryParam param) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        Long orgId = InvocationInfoProxy.getOrgId();
        this.loadCostList2ES(tenantid, orgId);
        return CommonResponse.success((String)"\u91cd\u65b0\u52a0\u8f7d\u6210\u672c\u63a7\u5236\u6570\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryCostList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanCostVO>> queryCostList(@RequestBody QueryParam param) {
        Map params;
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Page page = new Page();
        page.setCurrent((long)pageNumber);
        page.setSize((long)pageSize);
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_COST});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        if (InvocationInfoProxy.getOrgId() != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            UserContext userContext = this.sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
                String[] stringArray = authOrgIds.split(",");
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (String[])stringArray));
            }
        }
        if (null != param.getSearchText() && !"".equals(param.getSearchText())) {
            boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.wildcardQuery((String)"projectName", (String)("*" + param.getSearchText() + "*"))).should((QueryBuilder)QueryBuilders.wildcardQuery((String)"parentOrgName", (String)("*" + param.getSearchText() + "*"))).should((QueryBuilder)QueryBuilders.wildcardQuery((String)"orgName", (String)("*" + param.getSearchText() + "*"))));
        }
        if ((params = param.getParams()) != null && params.size() > 0) {
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                if (value.contains(",")) {
                    String[] vals = value.split(",");
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (String[])vals));
                    continue;
                }
                boolQuery.must((QueryBuilder)QueryBuilders.wildcardQuery((String)key, (String)("*" + value + "*")));
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<Object> list = new ArrayList<Object>();
        Object var10_13 = null;
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, PlanCostVO.class));
            }
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u672c\u63a7\u5236\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"excelCostExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelCostExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map params;
        int pageNumber = 0;
        int pageSize = 10000;
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_COST});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (null != param.getSearchText() && !"".equals(param.getSearchText())) {
            boolQuery.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)param.getSearchText(), (Object)"parentOrgName"));
            boolQuery.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)param.getSearchText(), (Object)"orgName"));
        }
        if ((params = param.getParams()) != null && params.size() > 0) {
            for (Map.Entry p : params.entrySet()) {
                String key = (String)p.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                if (value.contains(",")) {
                    String[] vals = value.split(",");
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (String[])vals));
                    continue;
                }
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<Object> list = new ArrayList<Object>();
        SearchResponse responseTemp = null;
        try {
            responseTemp = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = responseTemp.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, PlanCostVO.class));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<String, ArrayList<Object>> beans = new HashMap<String, ArrayList<Object>>();
        beans.put("records", list);
        String fileName = "costListExport.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    @RequestMapping(path={"/initProfit"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> initProfit() {
        try {
            XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(INDEX_NAME_PROFIT).startObject("properties");
            mapping.startObject("tenantId").field("type", "text").endObject();
            mapping.startObject("projectId").field("type", "text").endObject();
            mapping.startObject("projectName").field("type", "keyword").endObject();
            mapping.startObject("orgId").field("type", "text").endObject();
            mapping.startObject("orgName").field("type", "keyword").endObject();
            mapping.startObject("parentOrgId").field("type", "text").endObject();
            mapping.startObject("parentOrgName").field("type", "keyword").endObject();
            mapping.startObject("budgetId").field("type", "text").endObject();
            mapping.startObject("incomebudgetMny").field("type", "long").endObject();
            mapping.startObject("productionMny").field("type", "long").endObject();
            mapping.startObject("laborMny").field("type", "long").endObject();
            mapping.startObject("realCost").field("type", "long").endObject();
            mapping.startObject("computeCost").field("type", "long").endObject();
            mapping.startObject("curCost").field("type", "long").endObject();
            mapping.startObject("subCost").field("type", "long").endObject();
            mapping.startObject("materialMny").field("type", "long").endObject();
            mapping.startObject("materialCost").field("type", "long").endObject();
            mapping.startObject("manageMny").field("type", "long").endObject();
            mapping.startObject("realManageMny").field("type", "long").endObject();
            mapping.startObject("equipPurchaseCost").field("type", "long").endObject();
            mapping.startObject("equipRentCost").field("type", "long").endObject();
            mapping.startObject("loadReimburseCost").field("type", "long").endObject();
            mapping.startObject("payReimburseCost").field("type", "long").endObject();
            mapping.startObject("taxFee").field("type", "long").endObject();
            mapping.startObject("realTaxFee").field("type", "long").endObject();
            mapping.startObject("taxRatio").field("type", "long").endObject();
            mapping.startObject("planProfit").field("type", "long").endObject();
            mapping.startObject("planProfitTxt").field("type", "text").endObject();
            mapping.startObject("costbudgetMny").field("type", "long").endObject();
            mapping.startObject("realProfit").field("type", "long").endObject();
            mapping.startObject("basePlanProfit").field("type", "long").endObject();
            mapping.startObject("basePlanProfitTxt").field("type", "text").endObject();
            mapping.startObject("baseIncomebudgetMny").field("type", "long").endObject();
            mapping.startObject("baseCostbudgetMny").field("type", "long").endObject();
            mapping.startObject("planEquipMny").field("type", "long").endObject();
            mapping.startObject("realEquipMny").field("type", "long").endObject();
            mapping.endObject().endObject().endObject();
            PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{INDEX_NAME_PROFIT}).type(INDEX_NAME_PROFIT).source(mapping);
            this.client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            return CommonResponse.success();
        }
        catch (IOException e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    private CommonResponse<JSONObject> loadProfitList2ES(Long tenantid, Long orgId) {
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", tenantid);
        map.put("orgIds", orgIds);
        List<PlanProfitVO> list = this.planReportService.loadProfitList2ES(map);
        try {
            this.deleteESData(INDEX_NAME_PROFIT, tenantid, orgId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BulkRequest bulkRequest = new BulkRequest();
        for (PlanProfitVO vo : list) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("tenantId", String.valueOf(vo.getTenantId()));
            dataMap.put("projectId", String.valueOf(vo.getProjectId()));
            dataMap.put("projectName", vo.getProjectName());
            dataMap.put("orgId", String.valueOf(vo.getOrgId()));
            dataMap.put("orgName", vo.getOrgName());
            dataMap.put("parentOrgId", String.valueOf(vo.getParentOrgId()));
            dataMap.put("parentOrgName", vo.getParentOrgName());
            dataMap.put("budgetId", String.valueOf(vo.getBudgetId()));
            dataMap.put("incomebudgetMny", vo.getIncomebudgetMny());
            dataMap.put("productionMny", vo.getProductionMny());
            dataMap.put("laborMny", vo.getLaborMny());
            dataMap.put("realCost", vo.getRealCost());
            dataMap.put("computeCost", vo.getComputeCost());
            dataMap.put("curCost", vo.getCurCost());
            dataMap.put("subCost", vo.getSubCost());
            dataMap.put("materialMny", vo.getMaterialMny());
            dataMap.put("materialCost", vo.getMaterialCost());
            dataMap.put("manageMny", vo.getManageMny());
            dataMap.put("realManageMny", vo.getRealManageMny());
            dataMap.put("equipPurchaseCost", vo.getEquipPurchaseCost());
            dataMap.put("equipRentCost", vo.getEquipRentCost());
            dataMap.put("loadReimburseCost", vo.getLoadReimburseCost());
            dataMap.put("payReimburseCost", vo.getPayReimburseCost());
            dataMap.put("taxFee", vo.getTaxFee());
            dataMap.put("realTaxFee", vo.getRealTaxFee());
            dataMap.put("taxRatio", vo.getTaxRatio());
            dataMap.put("planProfit", vo.getPlanProfit());
            dataMap.put("planProfitTxt", vo.getPlanProfitTxt());
            dataMap.put("costbudgetMny", vo.getCostbudgetMny());
            dataMap.put("realProfit", vo.getRealProfit());
            dataMap.put("basePlanProfit", vo.getBasePlanProfit());
            dataMap.put("basePlanProfitTxt", vo.getBasePlanProfitTxt());
            dataMap.put("baseIncomebudgetMny", vo.getBaseIncomebudgetMny());
            dataMap.put("baseCostbudgetMny", vo.getBaseCostbudgetMny());
            dataMap.put("planEquipMny", vo.getPlanEquipMny());
            dataMap.put("realEquipMny", vo.getRealEquipMny());
            IndexRequest indexRequest = new IndexRequest(INDEX_NAME_PROFIT);
            indexRequest.id(String.valueOf(vo.getProjectId()));
            indexRequest.source(dataMap, XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        if (bulkRequest.requests().size() > 0) {
            try {
                bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        return CommonResponse.success((String)("\u6bdb\u5229\u5bf9\u6bd4\u91cd\u65b0\u52a0\u8f7d\u6210\u529f\u6761\u6570: " + bulkRequest.requests().size()));
    }

    @RequestMapping(value={"/reloadProfit"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanProfitVO> reloadProfit(@RequestBody QueryParam param) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        Long orgId = InvocationInfoProxy.getOrgId();
        this.loadProfitList2ES(tenantid, orgId);
        return CommonResponse.success((String)"\u91cd\u65b0\u52a0\u8f7d\u6bdb\u5229\u5bf9\u6bd4\u6570\u636e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryProfitList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanProfitVO>> queryProfitList(@RequestBody QueryParam param) {
        Map params;
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Page page = new Page();
        page.setCurrent((long)pageNumber);
        page.setSize((long)pageSize);
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_PROFIT});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (null != param.getSearchText() && !"".equals(param.getSearchText())) {
            boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.wildcardQuery((String)"projectName", (String)("*" + param.getSearchText() + "*"))).should((QueryBuilder)QueryBuilders.wildcardQuery((String)"parentOrgName", (String)("*" + param.getSearchText() + "*"))));
        }
        if ((params = param.getParams()) != null && params.size() > 0) {
            for (Map.Entry p : params.entrySet()) {
                String key = (String)p.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                if (value.contains(",")) {
                    String[] vals = value.split(",");
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (String[])vals));
                    continue;
                }
                boolQuery.must((QueryBuilder)QueryBuilders.wildcardQuery((String)key, (String)("*" + value + "*")));
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<Object> list = new ArrayList<Object>();
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, PlanProfitVO.class));
            }
            page.setRecords(list);
            page.setTotal(hits.getTotalHits().value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6bdb\u5229\u5bf9\u6bd4\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"excelProfitExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelProfitExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map params;
        int pageNumber = 0;
        int pageSize = 10000;
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_PROFIT});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (null != param.getSearchText() && !"".equals(param.getSearchText())) {
            boolQuery.must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.wildcardQuery((String)"projectName", (String)("*" + param.getSearchText() + "*"))).should((QueryBuilder)QueryBuilders.wildcardQuery((String)"parentOrgName", (String)("*" + param.getSearchText() + "*"))));
        }
        if ((params = param.getParams()) != null && params.size() > 0) {
            for (Map.Entry p : params.entrySet()) {
                String key = (String)p.getKey();
                String value = this.getParamValue(params, key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                if (value.contains(",")) {
                    String[] vals = value.split(",");
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)key, (String[])vals));
                    continue;
                }
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)key, (Object)value));
            }
        }
        sourceBuilder.size(pageSize);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        ArrayList<Object> list = new ArrayList<Object>();
        SearchResponse responseTemp = null;
        try {
            responseTemp = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = responseTemp.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, PlanProfitVO.class));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<String, ArrayList<Object>> beans = new HashMap<String, ArrayList<Object>>();
        beans.put("records", list);
        String fileName = "profitListExport.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    private long deleteESData(String indexName, Long tenantId, Long orgId) throws IOException {
        int i = 0;
        Long resultSize = this.queryIndexSize(indexName);
        Long deleteTimes = resultSize % (long)BATCH_SIZE.intValue();
        if ((long)i < deleteTimes + 1L) {
            DeleteByQueryRequest deleteByQueryRequest = new DeleteByQueryRequest(new String[]{indexName});
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)tenantId.toString()));
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            deleteByQueryRequest.setQuery((QueryBuilder)boolQuery);
            deleteByQueryRequest.setBatchSize(BATCH_SIZE.intValue());
            BulkByScrollResponse response = this.client.deleteByQuery(deleteByQueryRequest, RequestOptions.DEFAULT);
            return response.getDeleted();
        }
        return 0L;
    }

    private Long queryIndexSize(String indexName) {
        Long resultSize = 0L;
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (Object)InvocationInfoProxy.getTenantid()));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orgId", (Collection)((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            resultSize = hits.getTotalHits().value;
        }
        catch (IOException e) {
            try {
                SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                SearchHits hits = response.getHits();
                resultSize = hits.getTotalHits().value;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return resultSize;
    }

    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }

    @RequestMapping(value={"/loadCostAndProfit"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> loadCostAndProfit(HttpServletRequest request) {
        String param = request.getParameter("param");
        this.logger.info("------------------\u6bcf\u5929\u5b9a\u65f6\u66f4\u65b0\u6210\u672c\u548c\u6bdb\u5229\u5bf9\u6bd4\u8868----------------------");
        this.logger.info("------------------\u83b7\u53d6\u5230\u7684TASK\u53c2\u6570JSON\uff1a" + param + "----");
        JSONArray json = JSONArray.parseArray((String)param);
        JSONArray parameters = json.getJSONObject(0).getJSONArray("parameters");
        String reportName = null;
        Long _tenantId = null;
        for (int i = 0; i < parameters.size(); ++i) {
            JSONObject obj = parameters.getJSONObject(i);
            String property = (String)obj.get((Object)"property");
            if ("reportName".equalsIgnoreCase(property)) {
                reportName = obj.getString("value");
                continue;
            }
            if (!"tenantId".equals(property)) continue;
            _tenantId = obj.getLong("value");
        }
        Long tenantId = _tenantId != null ? _tenantId : 1438754657728655362L;
        Long orgId = null;
        CommonResponse orgRes = this.iOrgApi.findOrgByTenantId(tenantId);
        if (orgRes.isSuccess()) {
            OrgVO orgVO = (OrgVO)orgRes.getData();
            orgId = orgVO.getId();
        }
        this.logger.info("------------------" + DateUtil.getCurrentDay((String)"yyyy-MM-dd HH:mm:ss") + "--\u5f00\u59cb\u6267\u884c\u3010 tenantId:" + tenantId + ", orgId:" + orgId + ", reportName:" + reportName + "\u3011\u81ea\u52a8\u52a0\u8f7d\u4efb\u52a1----");
        if ("cost".equals(reportName)) {
            this.loadCostList2ES(tenantId, orgId);
        } else {
            this.loadProfitList2ES(tenantId, orgId);
        }
        this.logger.info("------------------" + DateUtil.getCurrentDay((String)"yyyy-MM-dd HH:mm:ss") + "--\u7ed3\u675f\u6267\u884c\u3010 tenantId:" + tenantId + ", orgId:" + orgId + ", reportName:" + reportName + "\u3011\u81ea\u52a8\u52a0\u8f7d\u4efb\u52a1----");
        return CommonResponse.success((String)"\u6bcf\u5929\u5b9a\u65f6\u66f4\u65b0\u6210\u672c\u548c\u6bdb\u5229\u5bf9\u6bd4\u8868");
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getCurrentDay((String)"yyyy-MM-dd HH:mm:ss"));
    }
}

