package com.ejianc.business.probuilddiary.ledger.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerTemplateEntity;
import com.ejianc.business.probuilddiary.ledger.mapper.LedgerMapper;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerService;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerTemplateService;
import com.ejianc.business.probuilddiary.ledger.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 日志台账
 *
 * @author generator
 */
@Service("ledgerService")
public class LedgerServiceImpl extends BaseServiceImpl<LedgerMapper, LedgerEntity> implements ILedgerService {

	private static final String SCHEDULE_WORK_TYPE = "schedule_work_type";
	private static final String TYPE_WORK_TYPE = "type_work_type";
	private static final String QUALITY_WORK_TYPE = "quality_work_type";
	private static final String SAFETY_WORK_TYPE = "safety_work_type";
	private static final String MATERIAL_WORK_TYPE = "material_work_type";
	private static final String EQUIPMENT_WORK_TYPE = "equipment_work_type";
	private static final String EXAMINE_WORK_TYPE = "examine_work_type";
	private static final String INFORMATION_WORK_TYPE = "information_work_type";
	private static final String OTHER_WORK_TYPE = "other_work_type";

	private static final String SCHEDULE_TITLE = "进度情况（施工员）";
	private static final String TYPE_TITLE = "施工组织设计、方案、交底、变更情况（技术负责人）";
	private static final String QUALITY_TITLE = "工程质量检查、验收情况（质检员）";
	private static final String SAFETY_TITLE = "安全活动情况（安全员）";
	private static final String MATERIAL_TITLE = "材料进场情况（材料员）";
	private static final String EQUIPMENT_TITLE = "设备进场情况（设备管理员）";
	private static final String EXAMINE_TITLE = "原材料检验、时间、试块及见证取样送检等情况（取样员）";
	private static final String INFORMATION_TITLE = "工程资料归档及会议情况（资料员）";
	private static final String OTHER_TITLE = "其他情况";
	private final ILedgerTemplateService templateService;

	public LedgerServiceImpl(ILedgerTemplateService templateService) {
		this.templateService = templateService;
	}

	/**
	 * 查询其他子表数据
	 *
	 * @param id 主键
	 *
	 * @return LedgerSubVO
	 */
	@Override
	public List<JSONObject> fetchOtherSubDetail(Long id) {
		ArrayList<JSONObject> jsonObjects = new ArrayList<>();

		LedgerEntity entity = super.selectById(id);
		LedgerVO ledgerVO = BeanMapper.map(entity, LedgerVO.class);

		List<LedgerScheduleVO> ledgerScheduleList = ledgerVO.getLedgerScheduleList();
		List<LedgerTypeVO> ledgerTypeList = ledgerVO.getLedgerTypeList();
		List<LedgerQualityVO> ledgerQualityList = ledgerVO.getLedgerQualityList();
		List<LedgerSafetyVO> ledgerSafetyList = ledgerVO.getLedgerSafetyList();
		List<LedgerMaterialVO> ledgerMaterialList = ledgerVO.getLedgerMaterialList();
		List<LedgerEquipmentVO> ledgerEquipmentList = ledgerVO.getLedgerEquipmentList();
		List<LedgerExamineVO> ledgerExamineList = ledgerVO.getLedgerExamineList();
		List<LedgerInformationVO> ledgerInformationList = ledgerVO.getLedgerInformationList();
		List<LedgerOtherVO> ledgerOtherList = ledgerVO.getLedgerOtherList();

		// 根据表名简写_work_type查询模版内容
		LambdaQueryWrapper<LedgerTemplateEntity> lambdaQuery = Wrappers.lambdaQuery();
		lambdaQuery.eq(LedgerTemplateEntity::getTemplateType, SCHEDULE_WORK_TYPE);
		List<LedgerTemplateEntity> ledgerTemplates = templateService.list(lambdaQuery);

		// 进度情况（施工员）
		if (CollectionUtils.isNotEmpty(ledgerScheduleList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, SCHEDULE_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerScheduleVO vo : ledgerScheduleList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject1 = new JSONObject();
		jsonObject1.put("title", SCHEDULE_TITLE);
		jsonObject1.put("describe", ledgerScheduleList);
		jsonObjects.add(jsonObject1);

		// 施工组织设计、方案、交底、变更情况（技术负责人）
		if (CollectionUtils.isNotEmpty(ledgerTypeList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, TYPE_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerTypeVO vo : ledgerTypeList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject2 = new JSONObject();
		jsonObject2.put("title", TYPE_TITLE);
		jsonObject2.put("describe", ledgerTypeList);
		jsonObjects.add(jsonObject2);

		// 工程质量检查、验收情况（质检员）
		if (CollectionUtils.isNotEmpty(ledgerQualityList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, QUALITY_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerQualityVO vo : ledgerQualityList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject3 = new JSONObject();
		jsonObject3.put("title", QUALITY_TITLE);
		jsonObject3.put("describe", ledgerQualityList);
		jsonObjects.add(jsonObject3);

		// 安全活动情况（安全员）
		if (CollectionUtils.isNotEmpty(ledgerSafetyList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, SAFETY_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerSafetyVO vo : ledgerSafetyList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject4 = new JSONObject();
		jsonObject4.put("title", SAFETY_TITLE);
		jsonObject4.put("describe", ledgerSafetyList);
		jsonObjects.add(jsonObject4);

		// 材料进场情况（材料员）
		if (CollectionUtils.isNotEmpty(ledgerMaterialList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, MATERIAL_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerMaterialVO vo : ledgerMaterialList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject5 = new JSONObject();
		jsonObject5.put("title", MATERIAL_TITLE);
		jsonObject5.put("describe", ledgerMaterialList);
		jsonObjects.add(jsonObject5);

		// 设备进场情况（设备管理员）
		if (CollectionUtils.isNotEmpty(ledgerEquipmentList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, EQUIPMENT_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerEquipmentVO vo : ledgerEquipmentList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject6 = new JSONObject();
		jsonObject6.put("title", EQUIPMENT_TITLE);
		jsonObject6.put("describe", ledgerEquipmentList);
		jsonObjects.add(jsonObject6);

		// 原材料检验、时间、试块及见证取样送检等情况（取样员）
		if (CollectionUtils.isNotEmpty(ledgerExamineList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, EXAMINE_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerExamineVO vo : ledgerExamineList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject7 = new JSONObject();
		jsonObject7.put("title", EXAMINE_TITLE);
		jsonObject7.put("describe", ledgerExamineList);
		jsonObjects.add(jsonObject7);

		// 工程资料归档及会议情况（资料员）
		if (CollectionUtils.isNotEmpty(ledgerInformationList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, INFORMATION_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerInformationVO vo : ledgerInformationList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject8 = new JSONObject();
		jsonObject8.put("title", INFORMATION_TITLE);
		jsonObject8.put("describe", ledgerInformationList);
		jsonObjects.add(jsonObject8);

		// 其他情况
		if (CollectionUtils.isNotEmpty(ledgerOtherList)) {
			List<LedgerTemplateEntity> collect = getTemplateContent(ledgerTemplates, OTHER_WORK_TYPE);
			if (CollectionUtils.isNotEmpty(collect)) {
				for (LedgerOtherVO vo : ledgerOtherList) {
					vo.setTemplateContent(collect.get(0).getTemplateContent());
				}
			}
		}
		JSONObject jsonObject9 = new JSONObject();
		jsonObject9.put("title", OTHER_TITLE);
		jsonObject9.put("describe", ledgerOtherList);
		jsonObjects.add(jsonObject9);


		return jsonObjects;
	}

	private static List<LedgerTemplateEntity> getTemplateContent(List<LedgerTemplateEntity> ledgerTemplates, String type) {
		return ledgerTemplates.stream().map(e -> {
			if (type.equals(e.getTemplateType())) {
				return e;
			}
			return null;
		}).collect(Collectors.toList());
	}
}
