/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.ledger.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerDetailService;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerService;
import com.ejianc.business.probuilddiary.ledger.vo.LedgerVO;
import com.ejianc.business.probuilddiary.project.service.IProjectLogService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ledger"})
public class LedgerController
implements Serializable {
    private static final long serialVersionUID = 1889016669879547986L;
    private static final String RULE_CODE = "PRO-BUILD-DIARY-LEDGER";
    private static final String BILL_CODE = "EJCBT202209000020";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IBillCodeApi billCodeApi;
    private final IOrgApi iOrgApi;
    private final ILedgerService service;
    private final ILedgerDetailService ledgerDetailService;
    private final IProjectLogService projectLogService;

    public LedgerController(SessionManager sessionManager, IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, ILedgerService service, ILedgerDetailService ledgerDetailService, IProjectLogService projectLogService) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.billCodeApi = billCodeApi;
        this.iOrgApi = iOrgApi;
        this.service = service;
        this.ledgerDetailService = ledgerDetailService;
        this.projectLogService = projectLogService;
    }

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<LedgerVO> saveOrUpdate(@RequestBody LedgerVO saveOrUpdateVO) {
        LedgerEntity entity = (LedgerEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LedgerEntity.class));
        if (null == entity.getId() || 0L == entity.getId()) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillName("\u65e5\u5fd7\u53f0\u8d26");
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)this.service.selectById(entity.getId()), LedgerVO.class));
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<LedgerVO> queryDetail(@RequestParam(value="id", required=true) Long id) {
        LedgerEntity entity = (LedgerEntity)((Object)this.service.selectById(id));
        LedgerVO vo = (LedgerVO)BeanMapper.map((Object)((Object)entity), LedgerVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<LedgerVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LedgerVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        List ledgerVOS = BeanMapper.mapList((Iterable)page.getRecords(), LedgerVO.class);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)ledgerVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        ArrayList ledgerVOS = new ArrayList();
        page.getRecords().forEach(e -> {
            LedgerVO ledgerVO = (LedgerVO)BeanMapper.map((Object)e, LedgerVO.class);
            ledgerVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)ledgerVO.getBillState()).getDescription());
            ledgerVOS.add(ledgerVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", ledgerVOS);
        ExcelExport.getInstance().export("ledger-export.xlsx", beans, response);
    }

    @PostMapping(value={"/countBillNum"})
    public CommonResponse<Map<String, Integer>> countBillNum(@RequestBody JSONObject jsonObject) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.projectLogService.countBillNum(jsonObject));
    }

    @GetMapping(value={"/fetchOtherSubDetail"})
    public CommonResponse<List<JSONObject>> fetchOtherSubDetail(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.service.fetchOtherSubDetail(id));
    }

    @GetMapping(value={"/ledgerDetailQueryPage"})
    public CommonResponse<JSONObject> ledgerDetailQueryPage(@RequestParam(value="id", required=true) Integer id, @RequestParam(value="pageIndex", defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        QueryParam param = new QueryParam();
        param.setPageIndex(pageIndex.intValue());
        param.setPageSize(pageSize.intValue());
        param.getParams().put("ledger_id", new Parameter("eq", (Object)id));
        IPage page = this.ledgerDetailService.queryPage(param);
        List ledgerVOS = BeanMapper.mapList((Iterable)page.getRecords(), LedgerVO.class);
        JSONObject resp = new JSONObject();
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)ledgerVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u9875\u6210\u529f\uff01", (Object)resp);
    }
}

