package com.ejianc.business.probuilddiary.construct.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaDetailEntity;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaEntity;
import com.ejianc.business.probuilddiary.construct.enums.AreaStatusEnum;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaDetailService;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaService;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaDetailVO;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 施工区域设置
 *
 * @author generator
 */
@Controller
@RequestMapping("constructArea")
public class ConstructAreaController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IConstructAreaDetailService detailService;


    @Autowired
    private IConstructAreaService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConstructAreaVO> saveOrUpdate(@RequestBody ConstructAreaVO saveOrUpdateVO) {
        return service.insertOrUpdate(saveOrUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConstructAreaVO> queryDetail(Long id) {
        ConstructAreaVO entity = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", entity);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConstructAreaVO> vos) {
        service.removeByIds(vos.stream().map(ConstructAreaVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 编号、名称、编制人、编制日期 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("staffingDate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<ConstructAreaEntity> page = service.queryPage(param, false);
        IPage<ConstructAreaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConstructAreaVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ConstructAreaEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ConstructArea-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refConstructAreaData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaVO>> refConstructAreaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ConstructAreaEntity> page = service.queryPage(param, false);
        IPage<ConstructAreaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConstructAreaVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }



    /**
     * @Description 参照
     * @Return void ConstructAreaEntity
     * 传入合同id:必传   excludeIds:可选 逗号分割 本次查询不查询传入的班组id
     */
    @RequestMapping(value = "/queryAreaDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaDetailVO>> queryAreaDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            if (null != conditionMap.get("projectId")){
                Long projectId  = Long.parseLong(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        IPage<ConstructAreaDetailVO> pageData  = new Page<>(1, 10, 0);;
        List<ConstructAreaEntity> constructAreaEntities = service.queryList(param);
        if (CollectionUtils.isNotEmpty(constructAreaEntities)){
            ConstructAreaEntity entity = constructAreaEntities.get(0);
            QueryParam queryParam = new QueryParam();
            queryParam.setPageSize(pageSize);
            queryParam.setPageIndex(pageNumber);
            queryParam.setSearchText(searchText);
            queryParam.setSearchObject(searchObject);
            queryParam.getParams().put("area_id",new Parameter(QueryParam.EQ,entity.getId()));
            queryParam.getParams().put("detail_status",new Parameter(QueryParam.EQ, AreaStatusEnum.启用.getCode()));
            IPage<ConstructAreaDetailEntity> page = detailService.queryPage(queryParam);
            pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConstructAreaDetailVO.class));
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
