package com.ejianc.business.probuilddiary.project.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.acceptance.api.IPurchaseAcceptanceApi;
import com.ejianc.business.probuilddiary.person.bean.*;
import com.ejianc.business.probuilddiary.person.service.*;
import com.ejianc.business.probuilddiary.project.bean.*;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogMapper;
import com.ejianc.business.probuilddiary.project.service.IProjectLogService;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogVO;
import com.ejianc.business.promaterial.check.api.ICheckApi;
import com.ejianc.business.rent.api.IRentAcceptanceApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目日志
 *
 * @author generator
 */
@Service("projectLogService")
public class ProjectLogServiceImpl extends BaseServiceImpl<ProjectLogMapper, ProjectLogEntity> implements IProjectLogService {

	private static final String BILL_NAME = "项目日志";
	private static final String AUTO_SOURCE_TYPE = "自动生成";
	private static final String RULE_CODE = "PRO-BUILD-DIARY-PROJECT-LOG";
	private static final String CHECK_INFO = "个人日志已被撤回，请刷新页面重试";
	private final ProjectLogMapper mapper;
	private final IBillCodeApi billCodeApi;
	private final ICheckApi checkApi;
	private final IRentAcceptanceApi rentAcceptanceApi;
	private final IPurchaseAcceptanceApi purchaseAcceptanceApi;
	private final IPersonService personService;
	private final IPersonDetailService personDetailService;
	private final IPersonScheduleService personScheduleService;
	private final IPersonTypeService personTypeService;
	private final IPersonQualityService personQualityService;
	private final IPersonSafetyService personSafetyService;
	private final IPersonMaterialService personMaterialService;
	private final IPersonEquipmentService personEquipmentService;
	private final IPersonExamineService personExamineService;
	private final IPersonInformationService personInformationService;
	private final IPersonOtherService personOtherService;

	public ProjectLogServiceImpl(ProjectLogMapper mapper, IBillCodeApi billCodeApi, ICheckApi checkApi, IRentAcceptanceApi rentAcceptanceApi, IPurchaseAcceptanceApi purchaseAcceptanceApi, IPersonService personService, IPersonDetailService personDetailService, IPersonScheduleService personScheduleService, IPersonTypeService personTypeService, IPersonQualityService personQualityService, IPersonSafetyService personSafetyService, IPersonMaterialService personMaterialService, IPersonEquipmentService personEquipmentService, IPersonExamineService personExamineService, IPersonInformationService personInformationService, IPersonOtherService personOtherService) {
		this.mapper = mapper;
		this.billCodeApi = billCodeApi;
		this.checkApi = checkApi;
		this.rentAcceptanceApi = rentAcceptanceApi;
		this.purchaseAcceptanceApi = purchaseAcceptanceApi;
		this.personService = personService;
		this.personDetailService = personDetailService;
		this.personScheduleService = personScheduleService;
		this.personTypeService = personTypeService;
		this.personQualityService = personQualityService;
		this.personSafetyService = personSafetyService;
		this.personMaterialService = personMaterialService;
		this.personEquipmentService = personEquipmentService;
		this.personExamineService = personExamineService;
		this.personInformationService = personInformationService;
		this.personOtherService = personOtherService;
	}

	/**
	 * 是否有项目日志
	 *
	 * @param projectId 项目id
	 * @param fillDate  填报日期
	 *
	 * @return boolean
	 */
	@Override
	public boolean hasProjectLog(Long projectId, Date fillDate) {
		QueryWrapper<ProjectLogEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper
				.eq("project_id", projectId)
				.eq("fill_date", fillDate)
				.last("LIMIT 1");
		int count = mapper.selectCount(queryWrapper);
		return count == 1;
	}

	/**
	 * 个人日志转换成项目日志
	 *
	 * @param person        个人日志
	 * @param hasProjectLog 是否有项目日志
	 *
	 * @return 项目日志
	 */
	@Override
	public ProjectLogEntity personLogConvertToProjectLog(PersonEntity person, boolean hasProjectLog) {
		ProjectLogEntity entity = new ProjectLogEntity();
		// 当天有项目日志，则自动汇总到已有项目日志；当天没有项目日志，则根据个人日志生成自由态的项目日志
		if (hasProjectLog) {
			// 查询已存在的项目日志主实体
			LambdaQueryWrapper<ProjectLogEntity> lambdaQuery = Wrappers.lambdaQuery();
			lambdaQuery.eq(ProjectLogEntity::getProjectId, person.getProjectId());
			lambdaQuery.eq(ProjectLogEntity::getFillDate, person.getInformantDate());
			ProjectLogEntity projectLogEntity = super.getOne(lambdaQuery);

			// 项目日志不是审批中、审批通过、已提交，才汇总
			Integer billState = projectLogEntity.getBillState();
			if (!billState.equals(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode())
					|| !billState.equals(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())
					|| !billState.equals(BillStateEnum.PASSED_STATE.getBillStateCode())
					|| !billState.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
				// 查询项目日志主实体和子实体
				ProjectLogEntity projectLog = super.selectById(projectLogEntity.getId());
				// 根据个人日志拼接子实体数据
				entity = spliceSubEntity(person, projectLog);
			}
		} else {
			// 个人日志生成项目日志
			entity = generateProjectLog(person);
		}
		return entity;
	}

	/**
	 * 子实体转换
	 *
	 * @param person 个人日志
	 * @param entity 项目日志
	 *
	 * @return 转换后的项目日志实体
	 */
	private ProjectLogEntity spliceSubEntity(PersonEntity person, ProjectLogEntity entity) {
		List<PersonDetailEntity> detailList = person.getDetailList();
		List<PersonScheduleEntity> scheduleList = person.getScheduleList();
		List<PersonTypeEntity> typeList = person.getTypeList();
		List<PersonQualityEntity> qualityList = person.getQualityList();
		List<PersonSafetyEntity> safetyList = person.getSafetyList();
		List<PersonMaterialEntity> materialList = person.getMaterialList();
		List<PersonEquipmentEntity> equipmentList = person.getEquipmentList();
		List<PersonExamineEntity> examineList = person.getExamineList();
		List<PersonInformationEntity> informationList = person.getInformationList();
		List<PersonOtherEntity> otherList = person.getOtherList();

		// 项目日志-施工内容（施工员）
		if (CollectionUtils.isNotEmpty(detailList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogDetailList())) {
				for (PersonDetailEntity e : detailList) {
					ProjectLogDetailEntity p = new ProjectLogDetailEntity();
					p.setPersonId(e.getPersonId());
					p.setConstructId(e.getConstructId());
					p.setConstructName(e.getConstructName());
					p.setConstructCode(e.getConstructCode());
					p.setTeamName(e.getTeamName());
					p.setWorkNum(e.getWorkNum());
					p.setWorkMemo(e.getWorkMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setDutyId(e.getDutyId());
					p.setDutyCode(e.getDutyCode());
					p.setDutyName(e.getDutyName());
					entity.getProjectLogDetailList().add(p);
				}
			} else {
				ArrayList<ProjectLogDetailEntity> list = new ArrayList<>();
				for (PersonDetailEntity e : detailList) {
					ProjectLogDetailEntity p = new ProjectLogDetailEntity();
					p.setPersonId(e.getPersonId());
					p.setConstructId(e.getConstructId());
					p.setConstructName(e.getConstructName());
					p.setConstructCode(e.getConstructCode());
					p.setTeamName(e.getTeamName());
					p.setWorkNum(e.getWorkNum());
					p.setWorkMemo(e.getWorkMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					p.setDutyId(e.getDutyId());
					p.setDutyCode(e.getDutyCode());
					p.setDutyName(e.getDutyName());
					list.add(p);
				}
				entity.setProjectLogDetailList(list);
			}
		}

		// 项目日志-进度情况（施工员）
		if (CollectionUtils.isNotEmpty(scheduleList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogScheduleList())) {
				for (PersonScheduleEntity e : scheduleList) {
					ProjectLogScheduleEntity p = new ProjectLogScheduleEntity();
					p.setPersonId(e.getPersonId());
					p.setScheduleMemo(e.getScheduleMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					entity.getProjectLogScheduleList().add(p);
				}
			} else {
				ArrayList<ProjectLogScheduleEntity> list = new ArrayList<>();
				for (PersonScheduleEntity e : scheduleList) {
					ProjectLogScheduleEntity p = new ProjectLogScheduleEntity();
					p.setPersonId(e.getPersonId());
					p.setScheduleMemo(e.getScheduleMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					list.add(p);
				}
				entity.setProjectLogScheduleList(list);
			}
		}

		// 项目日志-施工组织设计、方案、交底、变更情况（技术负责人）
		if (CollectionUtils.isNotEmpty(typeList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogTypeList())) {
				for (PersonTypeEntity e : typeList) {
					ProjectLogTypeEntity p = new ProjectLogTypeEntity();
					p.setPersonId(e.getPersonId());
					p.setWorkTypeId(e.getWorkTypeId());
					p.setWorkTypeName(e.getWorkTypeName());
					p.setWorkTypeCode(e.getWorkTypeCode());
					p.setWorkTypeMemo(e.getWorkTypeMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					entity.getProjectLogTypeList().add(p);
				}
			} else {
				ArrayList<ProjectLogTypeEntity> list = new ArrayList<>();
				for (PersonTypeEntity e : typeList) {
					ProjectLogTypeEntity p = new ProjectLogTypeEntity();
					p.setPersonId(e.getPersonId());
					p.setWorkTypeId(e.getWorkTypeId());
					p.setWorkTypeName(e.getWorkTypeName());
					p.setWorkTypeCode(e.getWorkTypeCode());
					p.setWorkTypeMemo(e.getWorkTypeMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					list.add(p);
				}
				entity.setProjectLogTypeList(list);
			}
		}

		//  项目日志-工程质量检查、验收情况（质检员）
		if (CollectionUtils.isNotEmpty(qualityList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogQualityList())) {
				for (PersonQualityEntity e : qualityList) {
					ProjectLogQualityEntity p = new ProjectLogQualityEntity();
					p.setPersonId(e.getPersonId());
					p.setQualityId(e.getQualityId());
					p.setQualityName(e.getQualityName());
					p.setQualityCode(e.getQualityCode());
					p.setQualityMemo(e.getQualityMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					entity.getProjectLogQualityList().add(p);
				}
			} else {
				ArrayList<ProjectLogQualityEntity> list = new ArrayList<>();
				for (PersonQualityEntity e : qualityList) {
					ProjectLogQualityEntity p = new ProjectLogQualityEntity();
					p.setPersonId(e.getPersonId());
					p.setQualityId(e.getQualityId());
					p.setQualityName(e.getQualityName());
					p.setQualityCode(e.getQualityCode());
					p.setQualityMemo(e.getQualityMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					list.add(p);
				}
				entity.setProjectLogQualityList(list);
			}
		}

		// 项目日志-安全活动情况（安全员）
		if (CollectionUtils.isNotEmpty(safetyList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogSafetyList())) {
				for (PersonSafetyEntity e : safetyList) {
					ProjectLogSafetyEntity p = new ProjectLogSafetyEntity();
					p.setPersonId(e.getPersonId());
					p.setSafetyId(e.getSafetyId());
					p.setSafetyName(e.getSafetyName());
					p.setSafetyCode(e.getSafetyCode());
					p.setSafetyMemo(e.getSafetyMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					entity.getProjectLogSafetyList().add(p);
				}
			} else {
				ArrayList<ProjectLogSafetyEntity> list = new ArrayList<>();
				for (PersonSafetyEntity e : safetyList) {
					ProjectLogSafetyEntity p = new ProjectLogSafetyEntity();
					p.setPersonId(e.getPersonId());
					p.setSafetyId(e.getSafetyId());
					p.setSafetyName(e.getSafetyName());
					p.setSafetyCode(e.getSafetyCode());
					p.setSafetyMemo(e.getSafetyMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					list.add(p);
				}
				entity.setProjectLogSafetyList(list);
			}
		}

		// 项目日志-材料进场情况（材料员）
		if (CollectionUtils.isNotEmpty(materialList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogMaterialList())) {
				for (PersonMaterialEntity e : materialList) {
					ProjectLogMaterialEntity p = new ProjectLogMaterialEntity();
					p.setPersonId(e.getPersonId());
					p.setMaterialMemo(e.getMaterialMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					entity.getProjectLogMaterialList().add(p);
				}
			} else {
				ArrayList<ProjectLogMaterialEntity> list = new ArrayList<>();
				for (PersonMaterialEntity e : materialList) {
					ProjectLogMaterialEntity p = new ProjectLogMaterialEntity();
					p.setPersonId(e.getPersonId());
					p.setMaterialMemo(e.getMaterialMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					list.add(p);
				}
				entity.setProjectLogMaterialList(list);
			}
		}

		// 项目日志-设备进场情况（设备管理员）
		if (CollectionUtils.isNotEmpty(equipmentList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogEquipmentList())) {
				for (PersonEquipmentEntity e : equipmentList) {
					ProjectLogEquipmentEntity p = new ProjectLogEquipmentEntity();
					p.setPersonId(e.getPersonId());
					p.setEquipmentMemo(e.getEquipmentMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					entity.getProjectLogEquipmentList().add(p);
				}
			} else {
				ArrayList<ProjectLogEquipmentEntity> list = new ArrayList<>();
				for (PersonEquipmentEntity e : equipmentList) {
					ProjectLogEquipmentEntity p = new ProjectLogEquipmentEntity();
					p.setPersonId(e.getPersonId());
					p.setEquipmentMemo(e.getEquipmentMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					list.add(p);
				}
				entity.setProjectLogEquipmentList(list);
			}
		}

		// 项目日志-原材料检验、时间、试块及见证取样送检等情况（取样员）
		if (CollectionUtils.isNotEmpty(examineList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogExamineList())) {
				for (PersonExamineEntity e : examineList) {
					ProjectLogExamineEntity p = new ProjectLogExamineEntity();
					p.setPersonId(e.getPersonId());
					p.setMoldId(e.getMoldId());
					p.setMoldName(e.getMoldName());
					p.setMoldCode(e.getMoldCode());
					p.setMakeName(e.getMakeName());
					p.setInspectName(e.getInspectName());
					p.setExamineName(e.getExamineName());
					p.setExamineNum(e.getExamineNum());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					entity.getProjectLogExamineList().add(p);
				}
			} else {
				ArrayList<ProjectLogExamineEntity> list = new ArrayList<>();
				for (PersonExamineEntity e : examineList) {
					ProjectLogExamineEntity p = new ProjectLogExamineEntity();
					p.setPersonId(e.getPersonId());
					p.setMoldId(e.getMoldId());
					p.setMoldName(e.getMoldName());
					p.setMoldCode(e.getMoldCode());
					p.setMakeName(e.getMakeName());
					p.setInspectName(e.getInspectName());
					p.setExamineName(e.getExamineName());
					p.setExamineNum(e.getExamineNum());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					list.add(p);
				}
				entity.setProjectLogExamineList(list);
			}
		}

		// 项目日志-工程资料归档及会议情况（资料员）
		if (CollectionUtils.isNotEmpty(informationList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogInformationList())) {
				for (PersonInformationEntity e : informationList) {
					ProjectLogInformationEntity p = new ProjectLogInformationEntity();
					p.setPersonId(e.getPersonId());
					p.setInformMoldId(e.getInformMoldId());
					p.setInformMoldName(e.getInformMoldName());
					p.setInformMoldCode(e.getInformMoldCode());
					p.setInformationMemo(e.getInformationMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					entity.getProjectLogInformationList().add(p);
				}
			} else {
				ArrayList<ProjectLogInformationEntity> list = new ArrayList<>();
				for (PersonInformationEntity e : informationList) {
					ProjectLogInformationEntity p = new ProjectLogInformationEntity();
					p.setPersonId(e.getPersonId());
					p.setInformMoldId(e.getInformMoldId());
					p.setInformMoldName(e.getInformMoldName());
					p.setInformMoldCode(e.getInformMoldCode());
					p.setInformationMemo(e.getInformationMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					list.add(p);
				}
				entity.setProjectLogInformationList(list);
			}
		}

		// 项目日志-其他情况
		if (CollectionUtils.isNotEmpty(otherList)) {
			if (CollectionUtils.isNotEmpty(entity.getProjectLogOtherList())) {
				for (PersonOtherEntity e : otherList) {
					ProjectLogOtherEntity p = new ProjectLogOtherEntity();
					p.setPersonId(e.getPersonId());
					p.setOtherMemo(e.getOtherMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					entity.getProjectLogOtherList().add(p);
				}
			} else {
				ArrayList<ProjectLogOtherEntity> list = new ArrayList<>();
				for (PersonOtherEntity e : otherList) {
					ProjectLogOtherEntity p = new ProjectLogOtherEntity();
					p.setPersonId(e.getPersonId());
					p.setOtherMemo(e.getOtherMemo());
					p.setCommitUserId(person.getCommitUserId());
					p.setCommitUserCode(person.getCommitUserCode());
					p.setCommitUserName(person.getCommitUserName());
					p.setCommitDate(person.getCommitDate());
					p.setProjectLogId(entity.getId());
					p.setLogNumber(e.getLogNumber());
					p.setProjectManagerFlag(Boolean.FALSE);
					list.add(p);
				}
				entity.setProjectLogOtherList(list);
			}
		}

		return entity;
	}


	private ProjectLogEntity generateProjectLog(PersonEntity person) {
		ProjectLogEntity entity = new ProjectLogEntity();
		entity.setBillCode(generateBillCode());
		entity.setBillName(BILL_NAME);
		entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
		entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
		entity.setOrgId(person.getOrgId());
		entity.setOrgCode(person.getOrgCode());
		entity.setOrgName(person.getOrgName());
		entity.setParentOrgId(person.getParentOrgId());
		entity.setParentOrgCode(person.getParentOrgCode());
		entity.setParentOrgName(person.getParentOrgName());
		entity.setProjectId(person.getProjectId());
		entity.setProjectCode(person.getProjectCode());
		entity.setProjectName(person.getProjectName());
		entity.setSourceType(AUTO_SOURCE_TYPE);
		entity.setFillDate(person.getInformantDate());
		entity.setWeek(getDayOfTheWeek(person.getInformantDate()));
		entity.setCommitUserId(person.getCommitUserId());
		entity.setCommitUserCode(person.getCommitUserCode());
		entity.setCommitUserName(person.getCommitUserName());
		entity.setCommitDate(person.getCommitDate());

		entity.setProjectLogDetailList(personConvertToProjectLogDetail(person, person.getDetailList()));
		entity.setProjectLogScheduleList(personConvertToProjectLogSchedule(person, person.getScheduleList()));
		entity.setProjectLogTypeList(personConvertToProjectLogType(person, person.getTypeList()));
		entity.setProjectLogQualityList(personConvertToProjectLogQuality(person, person.getQualityList()));
		entity.setProjectLogSafetyList(personConvertToProjectLogSafety(person, person.getSafetyList()));
		entity.setProjectLogMaterialList(personConvertToProjectLogMaterial(person, person.getMaterialList()));
		entity.setProjectLogEquipmentList(personConvertToProjectLogEquipment(person, person.getEquipmentList()));
		entity.setProjectLogExamineList(personConvertToProjectLogExamine(person, person.getExamineList()));
		entity.setProjectLogInformationList(personConvertToProjectLogInformation(person, person.getInformationList()));
		entity.setProjectLogOtherList(personConvertToProjectLogOther(person, person.getOtherList()));

		return entity;
	}

	/**
	 * 生成单据编码
	 *
	 * @return 单据编码
	 */
	private String generateBillCode() {
		BillCodeParam billCodeParam = BillCodeParam.build(RULE_CODE, InvocationInfoProxy.getTenantid(), new ProjectLogVO());
		CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
		if (!billCode.isSuccess()) {
			throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
		}
		return billCode.getData();
	}

	/**
	 * 获取星期几
	 *
	 * @param date 填报日期
	 *
	 * @return 星期几
	 */
	private String getDayOfTheWeek(Date date) {
		String[][] strArray = {
				{"MONDAY", "星期一"},
				{"TUESDAY", "星期二"},
				{"WEDNESDAY", "星期三"},
				{"THURSDAY", "星期四"},
				{"FRIDAY", "星期五"},
				{"SATURDAY", "星期六"},
				{"SUNDAY", "星期日"}
		};

		LocalDate currentDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
		String k = String.valueOf(currentDate.getDayOfWeek());
		String week = null;
		for (String[] strings : strArray) {
			if (k.equals(strings[0])) {
				week = strings[1];
				break;
			}
		}
		return week;
	}

	/**
	 * 个人日志转项目日志子实体-施工内容（施工员）
	 *
	 * @param person     个人日志主实体
	 * @param detailList 个人日志子实体
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogDetailEntity> personConvertToProjectLogDetail(PersonEntity person, List<PersonDetailEntity> detailList) {
		ArrayList<ProjectLogDetailEntity> list = new ArrayList<>();
		for (PersonDetailEntity e : detailList) {
			ProjectLogDetailEntity p = new ProjectLogDetailEntity();
			p.setPersonId(e.getPersonId());
			p.setConstructId(e.getConstructId());
			p.setConstructName(e.getConstructName());
			p.setConstructCode(e.getConstructCode());
			p.setTeamName(e.getTeamName());
			p.setWorkNum(e.getWorkNum());
			p.setWorkMemo(e.getWorkMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			p.setDutyId(e.getDutyId());
			p.setDutyCode(e.getDutyCode());
			p.setDutyName(e.getDutyName());
			list.add(p);
		}
		return list;
	}


	/**
	 * 个人日志转项目日志子实体-进度情况（施工员）
	 *
	 * @param person       个人日志主实体
	 * @param scheduleList 个人日志子实体
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogScheduleEntity> personConvertToProjectLogSchedule(PersonEntity person, List<PersonScheduleEntity> scheduleList) {
		ArrayList<ProjectLogScheduleEntity> list = new ArrayList<>();
		for (PersonScheduleEntity e : scheduleList) {
			ProjectLogScheduleEntity p = new ProjectLogScheduleEntity();
			p.setPersonId(e.getPersonId());
			p.setScheduleMemo(e.getScheduleMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			list.add(p);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-施工组织设计、方案、交底、变更情况（技术负责人）
	 *
	 * @param person   个人日志主实体
	 * @param typeList 个人日志子实体
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogTypeEntity> personConvertToProjectLogType(PersonEntity person, List<PersonTypeEntity> typeList) {
		ArrayList<ProjectLogTypeEntity> list = new ArrayList<>();
		for (PersonTypeEntity e : typeList) {
			ProjectLogTypeEntity p = new ProjectLogTypeEntity();
			p.setPersonId(e.getPersonId());
			p.setWorkTypeId(e.getWorkTypeId());
			p.setWorkTypeName(e.getWorkTypeName());
			p.setWorkTypeCode(e.getWorkTypeCode());
			p.setWorkTypeMemo(e.getWorkTypeMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			list.add(p);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-工程质量检查、验收情况（质检员）
	 *
	 * @param person      个人日志主实体
	 * @param qualityList 个人日志子实体
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogQualityEntity> personConvertToProjectLogQuality(PersonEntity person, List<PersonQualityEntity> qualityList) {
		ArrayList<ProjectLogQualityEntity> list = new ArrayList<>();
		for (PersonQualityEntity e : qualityList) {
			ProjectLogQualityEntity p = new ProjectLogQualityEntity();
			p.setPersonId(e.getPersonId());
			p.setQualityId(e.getQualityId());
			p.setQualityName(e.getQualityName());
			p.setQualityCode(e.getQualityCode());
			p.setQualityMemo(e.getQualityMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			list.add(p);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-安全活动情况（安全员）
	 *
	 * @param person     个人日志主实体
	 * @param safetyList 个人日志子实体
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogSafetyEntity> personConvertToProjectLogSafety(PersonEntity person, List<PersonSafetyEntity> safetyList) {
		ArrayList<ProjectLogSafetyEntity> list = new ArrayList<>();
		for (PersonSafetyEntity e : safetyList) {
			ProjectLogSafetyEntity p = new ProjectLogSafetyEntity();
			p.setPersonId(e.getPersonId());
			p.setSafetyId(e.getSafetyId());
			p.setSafetyName(e.getSafetyName());
			p.setSafetyCode(e.getSafetyCode());
			p.setSafetyMemo(e.getSafetyMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			list.add(p);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-
	 *
	 * @param person       个人日志主实体
	 * @param materialList 个人日志子实体
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogMaterialEntity> personConvertToProjectLogMaterial(PersonEntity person, List<PersonMaterialEntity> materialList) {
		ArrayList<ProjectLogMaterialEntity> list = new ArrayList<>();
		for (PersonMaterialEntity e : materialList) {
			ProjectLogMaterialEntity p = new ProjectLogMaterialEntity();
			p.setPersonId(e.getPersonId());
			p.setMaterialMemo(e.getMaterialMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			list.add(p);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-设备进场情况（设备管理员）
	 *
	 * @param person        个人日志主实体
	 * @param equipmentList 个人日志子实体
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogEquipmentEntity> personConvertToProjectLogEquipment(PersonEntity person, List<PersonEquipmentEntity> equipmentList) {
		ArrayList<ProjectLogEquipmentEntity> list = new ArrayList<>();
		for (PersonEquipmentEntity e : equipmentList) {
			ProjectLogEquipmentEntity p = new ProjectLogEquipmentEntity();
			p.setPersonId(e.getPersonId());
			p.setEquipmentMemo(e.getEquipmentMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			list.add(p);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-原材料检验、时间、试块及见证取样送检等情况（取样员）
	 *
	 * @param person      个人日志主实体
	 * @param examineList 个人日志子实体
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogExamineEntity> personConvertToProjectLogExamine(PersonEntity person, List<PersonExamineEntity> examineList) {
		ArrayList<ProjectLogExamineEntity> list = new ArrayList<>();
		for (PersonExamineEntity e : examineList) {
			ProjectLogExamineEntity p = new ProjectLogExamineEntity();
			p.setPersonId(e.getPersonId());
			p.setMoldId(e.getMoldId());
			p.setMoldName(e.getMoldName());
			p.setMoldCode(e.getMoldCode());
			p.setMakeName(e.getMakeName());
			p.setInspectName(e.getInspectName());
			p.setExamineName(e.getExamineName());
			p.setExamineNum(e.getExamineNum());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			list.add(p);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-工程资料归档及会议情况（资料员）
	 *
	 * @param person          个人日志主实体
	 * @param informationList 个人日志子实体
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogInformationEntity> personConvertToProjectLogInformation(PersonEntity person, List<PersonInformationEntity> informationList) {
		ArrayList<ProjectLogInformationEntity> list = new ArrayList<>();
		for (PersonInformationEntity e : informationList) {
			ProjectLogInformationEntity p = new ProjectLogInformationEntity();
			p.setPersonId(e.getPersonId());
			p.setInformMoldId(e.getInformMoldId());
			p.setInformMoldName(e.getInformMoldName());
			p.setInformMoldCode(e.getInformMoldCode());
			p.setInformationMemo(e.getInformationMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			list.add(p);
		}
		return list;
	}

	/**
	 * 个人日志转项目日志子实体-其他情况
	 *
	 * @param person    个人日志主实体
	 * @param otherList 个人日志子实体
	 *
	 * @return 项目日志子实体
	 */
	private List<ProjectLogOtherEntity> personConvertToProjectLogOther(PersonEntity person, List<PersonOtherEntity> otherList) {
		ArrayList<ProjectLogOtherEntity> list = new ArrayList<>();
		for (PersonOtherEntity e : otherList) {
			ProjectLogOtherEntity p = new ProjectLogOtherEntity();
			p.setPersonId(e.getPersonId());
			p.setOtherMemo(e.getOtherMemo());
			p.setCommitUserId(person.getCommitUserId());
			p.setCommitUserCode(person.getCommitUserCode());
			p.setCommitUserName(person.getCommitUserName());
			p.setCommitDate(person.getCommitDate());
			p.setLogNumber(e.getLogNumber());
			p.setProjectManagerFlag(Boolean.FALSE);
			list.add(p);
		}
		return list;
	}


	/**
	 * 查询验收单据数量
	 *
	 * @param jsonObject 参数
	 *
	 * @return Map<String, Integer>
	 */
	@Override
	public Map<String, Integer> countBillNum(JSONObject jsonObject) {
		if (!jsonObject.containsKey("projectId")) {
			throw new BusinessException("项目id不能为空！");
		}
		if (!jsonObject.containsKey("fillDate")) {
			throw new BusinessException("填报日期不能为空！");
		}
		CommonResponse<Map<String, Integer>> res1 = checkApi.countBillNum(jsonObject);
		if (!res1.isSuccess()) {
			throw new BusinessException("查询消耗材、混凝土单据数量失败，失败原因：" + res1.getMsg());
		}
		Map<String, Integer> data = res1.getData();
		CommonResponse<Integer> res2 = rentAcceptanceApi.countBillNum(jsonObject);
		if (!res2.isSuccess()) {
			throw new BusinessException("查询设备租赁单据数量失败，失败原因：" + res2.getMsg());
		}
		data.put("设备租赁", res2.getData());
		CommonResponse<Integer> res3 = purchaseAcceptanceApi.countBillNum(jsonObject);
		if (!res3.isSuccess()) {
			throw new BusinessException("查询设备采购单据数量失败，失败原因：" + res3.getMsg());
		}
		data.put("设备采购", res3.getData());
		return data;
	}


	/**
	 * 校验个人日志单据状态是否是自由态
	 *
	 * @param entity 项目日志实体
	 */
	@Override
	public void checkPersonBillState(ProjectLogEntity entity) {
		List<ProjectLogDetailEntity> projectLogDetailList = entity.getProjectLogDetailList();
		List<ProjectLogScheduleEntity> projectLogScheduleList = entity.getProjectLogScheduleList();
		List<ProjectLogTypeEntity> projectLogTypeList = entity.getProjectLogTypeList();
		List<ProjectLogQualityEntity> projectLogQualityList = entity.getProjectLogQualityList();
		List<ProjectLogSafetyEntity> projectLogSafetyList = entity.getProjectLogSafetyList();
		List<ProjectLogMaterialEntity> projectLogMaterialList = entity.getProjectLogMaterialList();
		List<ProjectLogEquipmentEntity> projectLogEquipmentList = entity.getProjectLogEquipmentList();
		List<ProjectLogExamineEntity> projectLogExamineList = entity.getProjectLogExamineList();
		List<ProjectLogInformationEntity> projectLogInformationList = entity.getProjectLogInformationList();
		List<ProjectLogOtherEntity> projectLogOtherList = entity.getProjectLogOtherList();

		HashSet<Long> ids = new HashSet<>();
		if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
			ids.addAll(projectLogDetailList.stream().map(ProjectLogDetailEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
			ids.addAll(projectLogDetailList.stream().map(ProjectLogDetailEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogScheduleList)) {
			ids.addAll(projectLogScheduleList.stream().map(ProjectLogScheduleEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogTypeList)) {
			ids.addAll(projectLogTypeList.stream().map(ProjectLogTypeEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogQualityList)) {
			ids.addAll(projectLogQualityList.stream().map(ProjectLogQualityEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogSafetyList)) {
			ids.addAll(projectLogSafetyList.stream().map(ProjectLogSafetyEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogMaterialList)) {
			ids.addAll(projectLogMaterialList.stream().map(ProjectLogMaterialEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogEquipmentList)) {
			ids.addAll(projectLogEquipmentList.stream().map(ProjectLogEquipmentEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogExamineList)) {
			ids.addAll(projectLogExamineList.stream().map(ProjectLogExamineEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogInformationList)) {
			ids.addAll(projectLogInformationList.stream().map(ProjectLogInformationEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(projectLogOtherList)) {
			ids.addAll(projectLogOtherList.stream().map(ProjectLogOtherEntity::getPersonId).collect(Collectors.toSet()));
		}

		if (CollectionUtils.isNotEmpty(ids)) {
			Integer count = personService.countUncommitedState(ids);
			if (count > 0) {
				throw new BusinessException(CHECK_INFO);
			}
		}
	}
}
