package com.ejianc.business.probuilddiary.ledger.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 日志台账
 *
 * @author generator
 */
public interface ILedgerService extends IBaseService<LedgerEntity> {

	/**
	 * 查询其他子表数据
	 *
	 * @param id 主键
	 *
	 * @return LedgerSubVO
	 */
	List<JSONObject> fetchOtherSubDetail(Long id);

	/**
	 * 项目日志实体转换日志台账
	 *
	 * @param entity 项目日志实体
	 *
	 * @return 日志台账实体
	 */
	LedgerEntity projectLogConvertToLedger(ProjectLogEntity entity);

	/**
	 * 处理子表打印数据
	 *
	 * @param detailJson 子表json数据
	 */
	void handleOtherSubDetail(JSONObject detailJson);
}
