/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.project.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.acceptance.api.IPurchaseAcceptanceApi;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.probuilddiary.person.bean.PersonDetailEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonEquipmentEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonExamineEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonInformationEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonMaterialEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonOtherEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonQualityEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonSafetyEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonScheduleEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonTypeEntity;
import com.ejianc.business.probuilddiary.person.service.IPersonService;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogDetailEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEquipmentEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogExamineEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogInformationEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogMaterialEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogOtherEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogQualityEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogSafetyEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogScheduleEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogTypeEntity;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogMapper;
import com.ejianc.business.probuilddiary.project.service.IProjectLogService;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogVO;
import com.ejianc.business.promaterial.check.api.ICheckApi;
import com.ejianc.business.rent.api.IRentAcceptanceApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="projectLogService")
public class ProjectLogServiceImpl
extends BaseServiceImpl<ProjectLogMapper, ProjectLogEntity>
implements IProjectLogService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_NAME = "\u9879\u76ee\u65e5\u5fd7";
    private static final String AUTO_SOURCE_TYPE = "\u81ea\u52a8\u751f\u6210";
    private static final String RULE_CODE = "PRO-BUILD-DIARY-PROJECT-LOG";
    private static final String CHECK_INFO = "\u4e2a\u4eba\u65e5\u5fd7\u5df2\u88ab\u64a4\u56de\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5";
    private final ProjectLogMapper mapper;
    private final IBillCodeApi billCodeApi;
    private final ICheckApi checkApi;
    private final IRentAcceptanceApi rentAcceptanceApi;
    private final IPurchaseAcceptanceApi purchaseAcceptanceApi;
    private final IPersonService personService;
    private final IWarnCenterApi warnCenterApi;
    @Value(value="${warning.code}")
    private String WARN_CODE;

    public ProjectLogServiceImpl(ProjectLogMapper mapper, IBillCodeApi billCodeApi, ICheckApi checkApi, IRentAcceptanceApi rentAcceptanceApi, IPurchaseAcceptanceApi purchaseAcceptanceApi, IPersonService personService, IWarnCenterApi warnCenterApi) {
        this.mapper = mapper;
        this.billCodeApi = billCodeApi;
        this.checkApi = checkApi;
        this.rentAcceptanceApi = rentAcceptanceApi;
        this.purchaseAcceptanceApi = purchaseAcceptanceApi;
        this.personService = personService;
        this.warnCenterApi = warnCenterApi;
    }

    @Override
    public boolean hasProjectLog(Long projectId, Date fillDate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"project_id", (Object)projectId)).eq((Object)"fill_date", (Object)fillDate)).last("LIMIT 1");
        int count = this.mapper.selectCount((Wrapper)queryWrapper);
        return count == 1;
    }

    @Override
    public ProjectLogEntity personLogConvertToProjectLog(PersonEntity person, boolean hasProjectLog) {
        ProjectLogEntity entity = new ProjectLogEntity();
        if (hasProjectLog) {
            LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(ProjectLogEntity::getProjectId, (Object)person.getProjectId());
            lambdaQuery.eq(ProjectLogEntity::getFillDate, (Object)person.getInformantDate());
            ProjectLogEntity projectLogEntity = (ProjectLogEntity)((Object)super.getOne((Wrapper)lambdaQuery));
            Integer billState = projectLogEntity.getBillState();
            if (!(billState.equals(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode()) && billState.equals(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()) && billState.equals(BillStateEnum.PASSED_STATE.getBillStateCode()) && billState.equals(BillStateEnum.COMMITED_STATE.getBillStateCode()))) {
                ProjectLogEntity projectLog = (ProjectLogEntity)((Object)super.selectById((Serializable)projectLogEntity.getId()));
                entity = this.spliceSubEntity(person, projectLog);
            }
        } else {
            entity = this.generateProjectLog(person);
        }
        return entity;
    }

    private ProjectLogEntity spliceSubEntity(PersonEntity person, ProjectLogEntity entity) {
        BaseEntity p;
        ArrayList<ProjectLogExamineEntity> list;
        List<PersonDetailEntity> detailList = person.getDetailList();
        List<PersonScheduleEntity> scheduleList = person.getScheduleList();
        List<PersonTypeEntity> typeList = person.getTypeList();
        List<PersonQualityEntity> qualityList = person.getQualityList();
        List<PersonSafetyEntity> safetyList = person.getSafetyList();
        List<PersonMaterialEntity> materialList = person.getMaterialList();
        List<PersonEquipmentEntity> equipmentList = person.getEquipmentList();
        List<PersonExamineEntity> examineList = person.getExamineList();
        List<PersonInformationEntity> informationList = person.getInformationList();
        List<PersonOtherEntity> otherList = person.getOtherList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogDetailList())) {
                for (PersonDetailEntity personDetailEntity : detailList) {
                    ProjectLogDetailEntity projectLogDetailEntity = new ProjectLogDetailEntity();
                    projectLogDetailEntity.setPersonId(personDetailEntity.getPersonId());
                    projectLogDetailEntity.setConstructId(personDetailEntity.getConstructId());
                    projectLogDetailEntity.setConstructName(personDetailEntity.getConstructName());
                    projectLogDetailEntity.setConstructCode(personDetailEntity.getConstructCode());
                    projectLogDetailEntity.setTeamName(personDetailEntity.getTeamName());
                    projectLogDetailEntity.setWorkNum(personDetailEntity.getWorkNum());
                    projectLogDetailEntity.setWorkMemo(personDetailEntity.getWorkMemo());
                    projectLogDetailEntity.setCommitUserId(person.getCommitUserId());
                    projectLogDetailEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogDetailEntity.setCommitUserName(person.getCommitUserName());
                    projectLogDetailEntity.setCommitDate(person.getCommitDate());
                    projectLogDetailEntity.setProjectLogId(entity.getId());
                    projectLogDetailEntity.setLogNumber(personDetailEntity.getLogNumber());
                    projectLogDetailEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogDetailEntity.setDutyId(personDetailEntity.getDutyId());
                    projectLogDetailEntity.setDutyCode(personDetailEntity.getDutyCode());
                    projectLogDetailEntity.setDutyName(personDetailEntity.getDutyName());
                    projectLogDetailEntity.setFileType(personDetailEntity.getFileType());
                    entity.getProjectLogDetailList().add(projectLogDetailEntity);
                }
            } else {
                list = new ArrayList();
                for (PersonDetailEntity personDetailEntity : detailList) {
                    p = new ProjectLogDetailEntity();
                    p.setPersonId(personDetailEntity.getPersonId());
                    p.setConstructId(personDetailEntity.getConstructId());
                    p.setConstructName(personDetailEntity.getConstructName());
                    p.setConstructCode(personDetailEntity.getConstructCode());
                    p.setTeamName(personDetailEntity.getTeamName());
                    p.setWorkNum(personDetailEntity.getWorkNum());
                    p.setWorkMemo(personDetailEntity.getWorkMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personDetailEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setDutyId(personDetailEntity.getDutyId());
                    p.setDutyCode(personDetailEntity.getDutyCode());
                    p.setDutyName(personDetailEntity.getDutyName());
                    p.setFileType(personDetailEntity.getFileType());
                    list.add((ProjectLogExamineEntity)p);
                }
                entity.setProjectLogDetailList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(scheduleList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogScheduleList())) {
                for (PersonScheduleEntity personScheduleEntity : scheduleList) {
                    ProjectLogScheduleEntity projectLogScheduleEntity = new ProjectLogScheduleEntity();
                    projectLogScheduleEntity.setPersonId(personScheduleEntity.getPersonId());
                    projectLogScheduleEntity.setScheduleMemo(personScheduleEntity.getScheduleMemo());
                    projectLogScheduleEntity.setCommitUserId(person.getCommitUserId());
                    projectLogScheduleEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogScheduleEntity.setCommitUserName(person.getCommitUserName());
                    projectLogScheduleEntity.setCommitDate(person.getCommitDate());
                    projectLogScheduleEntity.setProjectLogId(entity.getId());
                    projectLogScheduleEntity.setLogNumber(personScheduleEntity.getLogNumber());
                    projectLogScheduleEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogScheduleEntity.setFileType(personScheduleEntity.getFileType());
                    entity.getProjectLogScheduleList().add(projectLogScheduleEntity);
                }
            } else {
                list = new ArrayList();
                for (PersonScheduleEntity personScheduleEntity : scheduleList) {
                    p = new ProjectLogScheduleEntity();
                    p.setPersonId(personScheduleEntity.getPersonId());
                    p.setScheduleMemo(personScheduleEntity.getScheduleMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personScheduleEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personScheduleEntity.getFileType());
                    list.add((ProjectLogExamineEntity)p);
                }
                entity.setProjectLogScheduleList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(typeList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogTypeList())) {
                for (PersonTypeEntity personTypeEntity : typeList) {
                    ProjectLogTypeEntity projectLogTypeEntity = new ProjectLogTypeEntity();
                    projectLogTypeEntity.setPersonId(personTypeEntity.getPersonId());
                    projectLogTypeEntity.setWorkTypeId(personTypeEntity.getWorkTypeId());
                    projectLogTypeEntity.setWorkTypeName(personTypeEntity.getWorkTypeName());
                    projectLogTypeEntity.setWorkTypeCode(personTypeEntity.getWorkTypeCode());
                    projectLogTypeEntity.setWorkTypeMemo(personTypeEntity.getWorkTypeMemo());
                    projectLogTypeEntity.setCommitUserId(person.getCommitUserId());
                    projectLogTypeEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogTypeEntity.setCommitUserName(person.getCommitUserName());
                    projectLogTypeEntity.setCommitDate(person.getCommitDate());
                    projectLogTypeEntity.setProjectLogId(entity.getId());
                    projectLogTypeEntity.setLogNumber(personTypeEntity.getLogNumber());
                    projectLogTypeEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogTypeEntity.setFileType(personTypeEntity.getFileType());
                    entity.getProjectLogTypeList().add(projectLogTypeEntity);
                }
            } else {
                list = new ArrayList<ProjectLogDetailEntity>();
                for (PersonTypeEntity personTypeEntity : typeList) {
                    p = new ProjectLogTypeEntity();
                    p.setPersonId(personTypeEntity.getPersonId());
                    p.setWorkTypeId(personTypeEntity.getWorkTypeId());
                    p.setWorkTypeName(personTypeEntity.getWorkTypeName());
                    p.setWorkTypeCode(personTypeEntity.getWorkTypeCode());
                    p.setWorkTypeMemo(personTypeEntity.getWorkTypeMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personTypeEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personTypeEntity.getFileType());
                    list.add((ProjectLogExamineEntity)p);
                }
                entity.setProjectLogTypeList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(qualityList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogQualityList())) {
                for (PersonQualityEntity personQualityEntity : qualityList) {
                    ProjectLogQualityEntity projectLogQualityEntity = new ProjectLogQualityEntity();
                    projectLogQualityEntity.setPersonId(personQualityEntity.getPersonId());
                    projectLogQualityEntity.setQualityId(personQualityEntity.getQualityId());
                    projectLogQualityEntity.setQualityName(personQualityEntity.getQualityName());
                    projectLogQualityEntity.setQualityCode(personQualityEntity.getQualityCode());
                    projectLogQualityEntity.setQualityMemo(personQualityEntity.getQualityMemo());
                    projectLogQualityEntity.setCommitUserId(person.getCommitUserId());
                    projectLogQualityEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogQualityEntity.setCommitUserName(person.getCommitUserName());
                    projectLogQualityEntity.setCommitDate(person.getCommitDate());
                    projectLogQualityEntity.setProjectLogId(entity.getId());
                    projectLogQualityEntity.setLogNumber(personQualityEntity.getLogNumber());
                    projectLogQualityEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogQualityEntity.setFileType(personQualityEntity.getFileType());
                    entity.getProjectLogQualityList().add(projectLogQualityEntity);
                }
            } else {
                list = new ArrayList<ProjectLogScheduleEntity>();
                for (PersonQualityEntity personQualityEntity : qualityList) {
                    p = new ProjectLogQualityEntity();
                    p.setPersonId(personQualityEntity.getPersonId());
                    p.setQualityId(personQualityEntity.getQualityId());
                    p.setQualityName(personQualityEntity.getQualityName());
                    p.setQualityCode(personQualityEntity.getQualityCode());
                    p.setQualityMemo(personQualityEntity.getQualityMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personQualityEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personQualityEntity.getFileType());
                    list.add((ProjectLogExamineEntity)p);
                }
                entity.setProjectLogQualityList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(safetyList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogSafetyList())) {
                for (PersonSafetyEntity personSafetyEntity : safetyList) {
                    ProjectLogSafetyEntity projectLogSafetyEntity = new ProjectLogSafetyEntity();
                    projectLogSafetyEntity.setPersonId(personSafetyEntity.getPersonId());
                    projectLogSafetyEntity.setSafetyId(personSafetyEntity.getSafetyId());
                    projectLogSafetyEntity.setSafetyName(personSafetyEntity.getSafetyName());
                    projectLogSafetyEntity.setSafetyCode(personSafetyEntity.getSafetyCode());
                    projectLogSafetyEntity.setSafetyMemo(personSafetyEntity.getSafetyMemo());
                    projectLogSafetyEntity.setCommitUserId(person.getCommitUserId());
                    projectLogSafetyEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogSafetyEntity.setCommitUserName(person.getCommitUserName());
                    projectLogSafetyEntity.setCommitDate(person.getCommitDate());
                    projectLogSafetyEntity.setProjectLogId(entity.getId());
                    projectLogSafetyEntity.setLogNumber(personSafetyEntity.getLogNumber());
                    projectLogSafetyEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogSafetyEntity.setFileType(personSafetyEntity.getFileType());
                    entity.getProjectLogSafetyList().add(projectLogSafetyEntity);
                }
            } else {
                list = new ArrayList<ProjectLogTypeEntity>();
                for (PersonSafetyEntity personSafetyEntity : safetyList) {
                    p = new ProjectLogSafetyEntity();
                    p.setPersonId(personSafetyEntity.getPersonId());
                    p.setSafetyId(personSafetyEntity.getSafetyId());
                    p.setSafetyName(personSafetyEntity.getSafetyName());
                    p.setSafetyCode(personSafetyEntity.getSafetyCode());
                    p.setSafetyMemo(personSafetyEntity.getSafetyMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personSafetyEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personSafetyEntity.getFileType());
                    list.add((ProjectLogExamineEntity)p);
                }
                entity.setProjectLogSafetyList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(materialList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogMaterialList())) {
                for (PersonMaterialEntity personMaterialEntity : materialList) {
                    ProjectLogMaterialEntity projectLogMaterialEntity = new ProjectLogMaterialEntity();
                    projectLogMaterialEntity.setPersonId(personMaterialEntity.getPersonId());
                    projectLogMaterialEntity.setMaterialMemo(personMaterialEntity.getMaterialMemo());
                    projectLogMaterialEntity.setCommitUserId(person.getCommitUserId());
                    projectLogMaterialEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogMaterialEntity.setCommitUserName(person.getCommitUserName());
                    projectLogMaterialEntity.setCommitDate(person.getCommitDate());
                    projectLogMaterialEntity.setProjectLogId(entity.getId());
                    projectLogMaterialEntity.setLogNumber(personMaterialEntity.getLogNumber());
                    projectLogMaterialEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogMaterialEntity.setFileType(personMaterialEntity.getFileType());
                    entity.getProjectLogMaterialList().add(projectLogMaterialEntity);
                }
            } else {
                list = new ArrayList<ProjectLogQualityEntity>();
                for (PersonMaterialEntity personMaterialEntity : materialList) {
                    p = new ProjectLogMaterialEntity();
                    p.setPersonId(personMaterialEntity.getPersonId());
                    p.setMaterialMemo(personMaterialEntity.getMaterialMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personMaterialEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personMaterialEntity.getFileType());
                    list.add((ProjectLogExamineEntity)p);
                }
                entity.setProjectLogMaterialList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(equipmentList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogEquipmentList())) {
                for (PersonEquipmentEntity personEquipmentEntity : equipmentList) {
                    ProjectLogEquipmentEntity projectLogEquipmentEntity = new ProjectLogEquipmentEntity();
                    projectLogEquipmentEntity.setPersonId(personEquipmentEntity.getPersonId());
                    projectLogEquipmentEntity.setEquipmentMemo(personEquipmentEntity.getEquipmentMemo());
                    projectLogEquipmentEntity.setCommitUserId(person.getCommitUserId());
                    projectLogEquipmentEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogEquipmentEntity.setCommitUserName(person.getCommitUserName());
                    projectLogEquipmentEntity.setCommitDate(person.getCommitDate());
                    projectLogEquipmentEntity.setProjectLogId(entity.getId());
                    projectLogEquipmentEntity.setLogNumber(personEquipmentEntity.getLogNumber());
                    projectLogEquipmentEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogEquipmentEntity.setFileType(personEquipmentEntity.getFileType());
                    entity.getProjectLogEquipmentList().add(projectLogEquipmentEntity);
                }
            } else {
                list = new ArrayList<ProjectLogSafetyEntity>();
                for (PersonEquipmentEntity personEquipmentEntity : equipmentList) {
                    p = new ProjectLogEquipmentEntity();
                    p.setPersonId(personEquipmentEntity.getPersonId());
                    p.setEquipmentMemo(personEquipmentEntity.getEquipmentMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personEquipmentEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personEquipmentEntity.getFileType());
                    list.add((ProjectLogExamineEntity)p);
                }
                entity.setProjectLogEquipmentList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(examineList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogExamineList())) {
                for (PersonExamineEntity personExamineEntity : examineList) {
                    ProjectLogExamineEntity projectLogExamineEntity = new ProjectLogExamineEntity();
                    projectLogExamineEntity.setPersonId(personExamineEntity.getPersonId());
                    projectLogExamineEntity.setMoldId(personExamineEntity.getMoldId());
                    projectLogExamineEntity.setMoldName(personExamineEntity.getMoldName());
                    projectLogExamineEntity.setMoldCode(personExamineEntity.getMoldCode());
                    projectLogExamineEntity.setMakeName(personExamineEntity.getMakeName());
                    projectLogExamineEntity.setInspectName(personExamineEntity.getInspectName());
                    projectLogExamineEntity.setExamineName(personExamineEntity.getExamineName());
                    projectLogExamineEntity.setExamineNum(personExamineEntity.getExamineNum());
                    projectLogExamineEntity.setCommitUserId(person.getCommitUserId());
                    projectLogExamineEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogExamineEntity.setCommitUserName(person.getCommitUserName());
                    projectLogExamineEntity.setCommitDate(person.getCommitDate());
                    projectLogExamineEntity.setProjectLogId(entity.getId());
                    projectLogExamineEntity.setLogNumber(personExamineEntity.getLogNumber());
                    projectLogExamineEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogExamineEntity.setFileType(personExamineEntity.getFileType());
                    entity.getProjectLogExamineList().add(projectLogExamineEntity);
                }
            } else {
                list = new ArrayList<ProjectLogMaterialEntity>();
                for (PersonExamineEntity personExamineEntity : examineList) {
                    p = new ProjectLogExamineEntity();
                    p.setPersonId(personExamineEntity.getPersonId());
                    p.setMoldId(personExamineEntity.getMoldId());
                    p.setMoldName(personExamineEntity.getMoldName());
                    p.setMoldCode(personExamineEntity.getMoldCode());
                    p.setMakeName(personExamineEntity.getMakeName());
                    p.setInspectName(personExamineEntity.getInspectName());
                    p.setExamineName(personExamineEntity.getExamineName());
                    p.setExamineNum(personExamineEntity.getExamineNum());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personExamineEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personExamineEntity.getFileType());
                    list.add((ProjectLogExamineEntity)p);
                }
                entity.setProjectLogExamineList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(informationList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogInformationList())) {
                for (PersonInformationEntity personInformationEntity : informationList) {
                    ProjectLogInformationEntity projectLogInformationEntity = new ProjectLogInformationEntity();
                    projectLogInformationEntity.setPersonId(personInformationEntity.getPersonId());
                    projectLogInformationEntity.setInformMoldId(personInformationEntity.getInformMoldId());
                    projectLogInformationEntity.setInformMoldName(personInformationEntity.getInformMoldName());
                    projectLogInformationEntity.setInformMoldCode(personInformationEntity.getInformMoldCode());
                    projectLogInformationEntity.setInformationMemo(personInformationEntity.getInformationMemo());
                    projectLogInformationEntity.setCommitUserId(person.getCommitUserId());
                    projectLogInformationEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogInformationEntity.setCommitUserName(person.getCommitUserName());
                    projectLogInformationEntity.setCommitDate(person.getCommitDate());
                    projectLogInformationEntity.setProjectLogId(entity.getId());
                    projectLogInformationEntity.setLogNumber(personInformationEntity.getLogNumber());
                    projectLogInformationEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogInformationEntity.setFileType(personInformationEntity.getFileType());
                    entity.getProjectLogInformationList().add(projectLogInformationEntity);
                }
            } else {
                list = new ArrayList<ProjectLogEquipmentEntity>();
                for (PersonInformationEntity personInformationEntity : informationList) {
                    p = new ProjectLogInformationEntity();
                    p.setPersonId(personInformationEntity.getPersonId());
                    p.setInformMoldId(personInformationEntity.getInformMoldId());
                    p.setInformMoldName(personInformationEntity.getInformMoldName());
                    p.setInformMoldCode(personInformationEntity.getInformMoldCode());
                    p.setInformationMemo(personInformationEntity.getInformationMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personInformationEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personInformationEntity.getFileType());
                    list.add((ProjectLogExamineEntity)p);
                }
                entity.setProjectLogInformationList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(otherList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogOtherList())) {
                for (PersonOtherEntity personOtherEntity : otherList) {
                    ProjectLogOtherEntity projectLogOtherEntity = new ProjectLogOtherEntity();
                    projectLogOtherEntity.setPersonId(personOtherEntity.getPersonId());
                    projectLogOtherEntity.setOtherMemo(personOtherEntity.getOtherMemo());
                    projectLogOtherEntity.setCommitUserId(person.getCommitUserId());
                    projectLogOtherEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogOtherEntity.setCommitUserName(person.getCommitUserName());
                    projectLogOtherEntity.setCommitDate(person.getCommitDate());
                    projectLogOtherEntity.setProjectLogId(entity.getId());
                    projectLogOtherEntity.setLogNumber(personOtherEntity.getLogNumber());
                    projectLogOtherEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogOtherEntity.setFileType(personOtherEntity.getFileType());
                    entity.getProjectLogOtherList().add(projectLogOtherEntity);
                }
            } else {
                list = new ArrayList<ProjectLogExamineEntity>();
                for (PersonOtherEntity personOtherEntity : otherList) {
                    p = new ProjectLogOtherEntity();
                    p.setPersonId(personOtherEntity.getPersonId());
                    p.setOtherMemo(personOtherEntity.getOtherMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personOtherEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personOtherEntity.getFileType());
                    list.add((ProjectLogExamineEntity)p);
                }
                entity.setProjectLogOtherList(list);
            }
        }
        return entity;
    }

    private ProjectLogEntity generateProjectLog(PersonEntity person) {
        ProjectLogEntity entity = new ProjectLogEntity();
        entity.setBillCode(this.generateBillCode());
        entity.setBillName(BILL_NAME);
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        entity.setOrgId(person.getOrgId());
        entity.setOrgCode(person.getOrgCode());
        entity.setOrgName(person.getOrgName());
        entity.setParentOrgId(person.getParentOrgId());
        entity.setParentOrgCode(person.getParentOrgCode());
        entity.setParentOrgName(person.getParentOrgName());
        entity.setProjectId(person.getProjectId());
        entity.setProjectCode(person.getProjectCode());
        entity.setProjectName(person.getProjectName());
        entity.setSourceType(AUTO_SOURCE_TYPE);
        entity.setFillDate(person.getInformantDate());
        entity.setWeek(this.getDayOfTheWeek(person.getInformantDate()));
        entity.setCommitUserId(person.getCommitUserId());
        entity.setCommitUserCode(person.getCommitUserCode());
        entity.setCommitUserName(person.getCommitUserName());
        entity.setCommitDate(person.getCommitDate());
        entity.setProjectLogDetailList(this.personConvertToProjectLogDetail(person, person.getDetailList()));
        entity.setProjectLogScheduleList(this.personConvertToProjectLogSchedule(person, person.getScheduleList()));
        entity.setProjectLogTypeList(this.personConvertToProjectLogType(person, person.getTypeList()));
        entity.setProjectLogQualityList(this.personConvertToProjectLogQuality(person, person.getQualityList()));
        entity.setProjectLogSafetyList(this.personConvertToProjectLogSafety(person, person.getSafetyList()));
        entity.setProjectLogMaterialList(this.personConvertToProjectLogMaterial(person, person.getMaterialList()));
        entity.setProjectLogEquipmentList(this.personConvertToProjectLogEquipment(person, person.getEquipmentList()));
        entity.setProjectLogExamineList(this.personConvertToProjectLogExamine(person, person.getExamineList()));
        entity.setProjectLogInformationList(this.personConvertToProjectLogInformation(person, person.getInformationList()));
        entity.setProjectLogOtherList(this.personConvertToProjectLogOther(person, person.getOtherList()));
        return entity;
    }

    private String generateBillCode() {
        BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)new ProjectLogVO());
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return (String)billCode.getData();
    }

    private String getDayOfTheWeek(Date date) {
        String[][] strArray = new String[][]{{"MONDAY", "\u661f\u671f\u4e00"}, {"TUESDAY", "\u661f\u671f\u4e8c"}, {"WEDNESDAY", "\u661f\u671f\u4e09"}, {"THURSDAY", "\u661f\u671f\u56db"}, {"FRIDAY", "\u661f\u671f\u4e94"}, {"SATURDAY", "\u661f\u671f\u516d"}, {"SUNDAY", "\u661f\u671f\u65e5"}};
        LocalDate currentDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        String k = String.valueOf(currentDate.getDayOfWeek());
        String week = null;
        for (String[] strings : strArray) {
            if (!k.equals(strings[0])) continue;
            week = strings[1];
            break;
        }
        return week;
    }

    private List<ProjectLogDetailEntity> personConvertToProjectLogDetail(PersonEntity person, List<PersonDetailEntity> detailList) {
        ArrayList<ProjectLogDetailEntity> list = new ArrayList<ProjectLogDetailEntity>();
        for (PersonDetailEntity e : detailList) {
            ProjectLogDetailEntity p = new ProjectLogDetailEntity();
            p.setPersonId(e.getPersonId());
            p.setConstructId(e.getConstructId());
            p.setConstructName(e.getConstructName());
            p.setConstructCode(e.getConstructCode());
            p.setTeamName(e.getTeamName());
            p.setWorkNum(e.getWorkNum());
            p.setWorkMemo(e.getWorkMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setDutyId(e.getDutyId());
            p.setDutyCode(e.getDutyCode());
            p.setDutyName(e.getDutyName());
            p.setFileType(e.getFileType());
            list.add(p);
        }
        return list;
    }

    private List<ProjectLogScheduleEntity> personConvertToProjectLogSchedule(PersonEntity person, List<PersonScheduleEntity> scheduleList) {
        ArrayList<ProjectLogScheduleEntity> list = new ArrayList<ProjectLogScheduleEntity>();
        for (PersonScheduleEntity e : scheduleList) {
            ProjectLogScheduleEntity p = new ProjectLogScheduleEntity();
            p.setPersonId(e.getPersonId());
            p.setScheduleMemo(e.getScheduleMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            list.add(p);
        }
        return list;
    }

    private List<ProjectLogTypeEntity> personConvertToProjectLogType(PersonEntity person, List<PersonTypeEntity> typeList) {
        ArrayList<ProjectLogTypeEntity> list = new ArrayList<ProjectLogTypeEntity>();
        for (PersonTypeEntity e : typeList) {
            ProjectLogTypeEntity p = new ProjectLogTypeEntity();
            p.setPersonId(e.getPersonId());
            p.setWorkTypeId(e.getWorkTypeId());
            p.setWorkTypeName(e.getWorkTypeName());
            p.setWorkTypeCode(e.getWorkTypeCode());
            p.setWorkTypeMemo(e.getWorkTypeMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            list.add(p);
        }
        return list;
    }

    private List<ProjectLogQualityEntity> personConvertToProjectLogQuality(PersonEntity person, List<PersonQualityEntity> qualityList) {
        ArrayList<ProjectLogQualityEntity> list = new ArrayList<ProjectLogQualityEntity>();
        for (PersonQualityEntity e : qualityList) {
            ProjectLogQualityEntity p = new ProjectLogQualityEntity();
            p.setPersonId(e.getPersonId());
            p.setQualityId(e.getQualityId());
            p.setQualityName(e.getQualityName());
            p.setQualityCode(e.getQualityCode());
            p.setQualityMemo(e.getQualityMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            list.add(p);
        }
        return list;
    }

    private List<ProjectLogSafetyEntity> personConvertToProjectLogSafety(PersonEntity person, List<PersonSafetyEntity> safetyList) {
        ArrayList<ProjectLogSafetyEntity> list = new ArrayList<ProjectLogSafetyEntity>();
        for (PersonSafetyEntity e : safetyList) {
            ProjectLogSafetyEntity p = new ProjectLogSafetyEntity();
            p.setPersonId(e.getPersonId());
            p.setSafetyId(e.getSafetyId());
            p.setSafetyName(e.getSafetyName());
            p.setSafetyCode(e.getSafetyCode());
            p.setSafetyMemo(e.getSafetyMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            list.add(p);
        }
        return list;
    }

    private List<ProjectLogMaterialEntity> personConvertToProjectLogMaterial(PersonEntity person, List<PersonMaterialEntity> materialList) {
        ArrayList<ProjectLogMaterialEntity> list = new ArrayList<ProjectLogMaterialEntity>();
        for (PersonMaterialEntity e : materialList) {
            ProjectLogMaterialEntity p = new ProjectLogMaterialEntity();
            p.setPersonId(e.getPersonId());
            p.setMaterialMemo(e.getMaterialMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            list.add(p);
        }
        return list;
    }

    private List<ProjectLogEquipmentEntity> personConvertToProjectLogEquipment(PersonEntity person, List<PersonEquipmentEntity> equipmentList) {
        ArrayList<ProjectLogEquipmentEntity> list = new ArrayList<ProjectLogEquipmentEntity>();
        for (PersonEquipmentEntity e : equipmentList) {
            ProjectLogEquipmentEntity p = new ProjectLogEquipmentEntity();
            p.setPersonId(e.getPersonId());
            p.setEquipmentMemo(e.getEquipmentMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            list.add(p);
        }
        return list;
    }

    private List<ProjectLogExamineEntity> personConvertToProjectLogExamine(PersonEntity person, List<PersonExamineEntity> examineList) {
        ArrayList<ProjectLogExamineEntity> list = new ArrayList<ProjectLogExamineEntity>();
        for (PersonExamineEntity e : examineList) {
            ProjectLogExamineEntity p = new ProjectLogExamineEntity();
            p.setPersonId(e.getPersonId());
            p.setMoldId(e.getMoldId());
            p.setMoldName(e.getMoldName());
            p.setMoldCode(e.getMoldCode());
            p.setMakeName(e.getMakeName());
            p.setInspectName(e.getInspectName());
            p.setExamineName(e.getExamineName());
            p.setExamineNum(e.getExamineNum());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            list.add(p);
        }
        return list;
    }

    private List<ProjectLogInformationEntity> personConvertToProjectLogInformation(PersonEntity person, List<PersonInformationEntity> informationList) {
        ArrayList<ProjectLogInformationEntity> list = new ArrayList<ProjectLogInformationEntity>();
        for (PersonInformationEntity e : informationList) {
            ProjectLogInformationEntity p = new ProjectLogInformationEntity();
            p.setPersonId(e.getPersonId());
            p.setInformMoldId(e.getInformMoldId());
            p.setInformMoldName(e.getInformMoldName());
            p.setInformMoldCode(e.getInformMoldCode());
            p.setInformationMemo(e.getInformationMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            list.add(p);
        }
        return list;
    }

    private List<ProjectLogOtherEntity> personConvertToProjectLogOther(PersonEntity person, List<PersonOtherEntity> otherList) {
        ArrayList<ProjectLogOtherEntity> list = new ArrayList<ProjectLogOtherEntity>();
        for (PersonOtherEntity e : otherList) {
            ProjectLogOtherEntity p = new ProjectLogOtherEntity();
            p.setPersonId(e.getPersonId());
            p.setOtherMemo(e.getOtherMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            list.add(p);
        }
        return list;
    }

    @Override
    public Map<String, Integer> countBillNum(JSONObject jsonObject) {
        if (!jsonObject.containsKey((Object)"projectId")) {
            throw new BusinessException("\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!jsonObject.containsKey((Object)"fillDate")) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CommonResponse res1 = this.checkApi.countBillNum(jsonObject);
        if (!res1.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u6d88\u8017\u6750\u3001\u6df7\u51dd\u571f\u5355\u636e\u6570\u91cf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res1.getMsg());
        }
        Map data = (Map)res1.getData();
        CommonResponse res2 = this.rentAcceptanceApi.countBillNum(jsonObject);
        if (!res2.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u8bbe\u5907\u79df\u8d41\u5355\u636e\u6570\u91cf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res2.getMsg());
        }
        data.put("\u8bbe\u5907\u79df\u8d41", res2.getData());
        CommonResponse res3 = this.purchaseAcceptanceApi.countBillNum(jsonObject);
        if (!res3.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u8bbe\u5907\u91c7\u8d2d\u5355\u636e\u6570\u91cf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res3.getMsg());
        }
        data.put("\u8bbe\u5907\u91c7\u8d2d", res3.getData());
        return data;
    }

    @Override
    public void checkPersonBillState(ProjectLogEntity entity) {
        Integer count;
        List<ProjectLogDetailEntity> projectLogDetailList = entity.getProjectLogDetailList();
        List<ProjectLogScheduleEntity> projectLogScheduleList = entity.getProjectLogScheduleList();
        List<ProjectLogTypeEntity> projectLogTypeList = entity.getProjectLogTypeList();
        List<ProjectLogQualityEntity> projectLogQualityList = entity.getProjectLogQualityList();
        List<ProjectLogSafetyEntity> projectLogSafetyList = entity.getProjectLogSafetyList();
        List<ProjectLogMaterialEntity> projectLogMaterialList = entity.getProjectLogMaterialList();
        List<ProjectLogEquipmentEntity> projectLogEquipmentList = entity.getProjectLogEquipmentList();
        List<ProjectLogExamineEntity> projectLogExamineList = entity.getProjectLogExamineList();
        List<ProjectLogInformationEntity> projectLogInformationList = entity.getProjectLogInformationList();
        List<ProjectLogOtherEntity> projectLogOtherList = entity.getProjectLogOtherList();
        HashSet<Long> ids = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
            ids.addAll(projectLogDetailList.stream().map(ProjectLogDetailEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogScheduleList)) {
            ids.addAll(projectLogScheduleList.stream().map(ProjectLogScheduleEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogTypeList)) {
            ids.addAll(projectLogTypeList.stream().map(ProjectLogTypeEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogQualityList)) {
            ids.addAll(projectLogQualityList.stream().map(ProjectLogQualityEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogSafetyList)) {
            ids.addAll(projectLogSafetyList.stream().map(ProjectLogSafetyEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogMaterialList)) {
            ids.addAll(projectLogMaterialList.stream().map(ProjectLogMaterialEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogEquipmentList)) {
            ids.addAll(projectLogEquipmentList.stream().map(ProjectLogEquipmentEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogExamineList)) {
            ids.addAll(projectLogExamineList.stream().map(ProjectLogExamineEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogInformationList)) {
            ids.addAll(projectLogInformationList.stream().map(ProjectLogInformationEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogOtherList)) {
            ids.addAll(projectLogOtherList.stream().map(ProjectLogOtherEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(ids) && (count = this.personService.countUncommitedState(ids)) > 0) {
            throw new BusinessException(CHECK_INFO);
        }
    }

    @Override
    public void warn(HttpServletRequest request) {
    }
}

