/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.project.service.impl;

import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerService;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import com.ejianc.business.probuilddiary.project.service.IProjectLogService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="projectLog")
public class ProjectLogBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IProjectLogService service;
    private final ILedgerService ledgerService;

    public ProjectLogBpmServiceImpl(SessionManager sessionManager, IBillTypeApi billTypeApi, IProjectLogService service, ILedgerService ledgerService) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.service = service;
        this.ledgerService = ledgerService;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        ProjectLogEntity entity = (ProjectLogEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserId(userContext.getUserId());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        this.syncLedger(entity);
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    private void syncLedger(ProjectLogEntity entity) {
        LedgerEntity ledgerEntity = this.ledgerService.projectLogConvertToLedger(entity);
        this.ledgerService.saveOrUpdate((Object)ledgerEntity, false);
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ProjectLogEntity entity = (ProjectLogEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        LocalDateTime effectiveDate = entity.getEffectiveDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime afterSevenDays = effectiveDate.plusDays(7L);
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(afterSevenDays)) {
            throw new BusinessException("\u8d85\u51fa\u5ba1\u6279\u901a\u8fc7\u540e\u76847\u5929\u540e\uff0c\u4e0d\u652f\u6301\u64a4\u56de\u6216\u5f03\u5ba1\uff01");
        }
        this.ledgerService.deleteAllDataByProjectLogId(entity.getId());
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de/\u5f03\u5ba1\u6210\u529f");
    }
}

