package com.ejianc.business.probuilddiary.project.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.probuilddiary.person.bean.PersonEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Map;

/**
 * 项目日志
 *
 * @author generator
 */
public interface IProjectLogService extends IBaseService<ProjectLogEntity> {

	/**
	 * 是否有项目日志
	 *
	 * @param projectId 项目id
	 * @param fillDate  填报日期
	 *
	 * @return boolean
	 */
	boolean hasProjectLog(Long projectId, Date fillDate);

	/**
	 * 个人日志转换成项目日志
	 *
	 * @param person        个人日志
	 * @param hasProjectLog 是否有项目日志
	 *
	 * @return 项目日志
	 */
	ProjectLogEntity personLogConvertToProjectLog(PersonEntity person, boolean hasProjectLog);

	/**
	 * 查询验收单据数量
	 *
	 * @param jsonObject 参数
	 *
	 * @return Map<String, Integer>
	 */
	Map<String, Integer> countBillNum(JSONObject jsonObject);

	/**
	 * 校验个人日志单据状态是否是自由态
	 *
	 * @param entity 项目日志实体
	 */
	void checkPersonBillState(ProjectLogEntity entity);

	/**
	 * 预警
	 *
	 * @param request 请求信息
	 */
	void warn(HttpServletRequest request);

	/**
	 * 删除个人日志数据
	 *
	 * @param id            个人日志id
	 * @param projectId     项目id
	 * @param informantDate 填报日期
	 */
	void deleteAllDataByPersonId(Long id, Long projectId, Date informantDate);
}
