/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.person.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.probuilddiary.person.bean.PersonEntity;
import com.ejianc.business.probuilddiary.person.service.IPersonService;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import com.ejianc.business.probuilddiary.project.service.IProjectLogService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="person")
public class PersonBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IPersonService service;
    private final IProjectLogService projectLogService;

    public PersonBpmServiceImpl(SessionManager sessionManager, IBillTypeApi billTypeApi, IPersonService service, IProjectLogService projectLogService) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.service = service;
        this.projectLogService = projectLogService;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        PersonEntity entity = (PersonEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserId(userContext.getUserId());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        this.syncProjectLog(entity);
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    private void syncProjectLog(PersonEntity entity) {
        boolean hasProjectLog = this.projectLogService.hasProjectLog(entity.getProjectId(), entity.getInformantDate());
        ProjectLogEntity projectLogEntity = this.projectLogService.personLogConvertToProjectLog(entity, hasProjectLog);
        this.logger.info("\u6821\u9a8c\u5f53\u5929\u662f\u5426\u6709\u9879\u76ee\u65e5\u5fd7\uff1a{}\uff0c\u5199\u5165\u9879\u76ee\u65e5\u5fd7\u6570\u636e\uff1a{}", (Object)hasProjectLog, (Object)JSON.toJSONString((Object)((Object)projectLogEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        this.projectLogService.saveOrUpdate((Object)projectLogEntity, false);
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        PersonEntity entity = (PersonEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5\uff1a{}\uff0c{}", (Object)res.isSuccess(), (Object)res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u9879\u76ee\u8fd8\u6b3e\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1\uff01");
        }
        this.projectLogService.deleteAllDataByPersonId(entity.getId(), entity.getProjectId(), entity.getInformantDate());
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de/\u5f03\u5ba1\u6210\u529f");
    }
}

