package com.ejianc.business.probuilddiary.person.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.probuilddiary.person.bean.PersonEntity;
import com.ejianc.business.probuilddiary.person.mapper.PersonMapper;
import com.ejianc.business.probuilddiary.person.service.IPersonService;
import com.ejianc.business.probuilddiary.person.vo.PersonVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 个人施工日志
 * 
 * @author generator
 * 
 */
@Service("personService")
public class PersonServiceImpl extends BaseServiceImpl<PersonMapper, PersonEntity> implements IPersonService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PERSON_LOG";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    @Override
    public CommonResponse<IPage<PersonVO>> newQuery(QueryParam param) {
        /** 模糊搜索配置字段示例  单据编码，项目名称，填报人，日志模板*/
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("informantName");
        fuzzyFields.add("logTemplate");
        List<PersonEntity> dataList =new ArrayList<>();
        IPage<PersonEntity> page;
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        //移动端查询
        if (StringUtils.isNotBlank(authOrgIds)) {
            //移动端有默认项目的存在，故传递默认项目对应项目部Id时，查询其本下数据，若未传递，则返回空数据
            if(null == param.getParams().get("orgId")) {
                page = new Page<>(param.getPageIndex(), param.getPageSize(), 0);
            } else {
                page = super.queryPage(param, false);
                dataList = page.getRecords();
            }
        } else {
            //pc端查询
            //查询本下范围内日的合同
            Long orgId = InvocationInfoProxy.getOrgId();
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
            page = super.queryPage(param, false);
            dataList = page.getRecords();
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        if(null == param.getOrderMap().get("createTime")) {
            orderMap.put("create_time", QueryParam.DESC);
        }
        param.setOrderMap(orderMap);
        IPage<PersonVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PersonVO> applicationVOS = BeanMapper.mapList(dataList, PersonVO.class);
        pageData.setRecords(applicationVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @Override
    public CommonResponse<PersonVO> newSaveOrUpdate(PersonVO saveOrUpdateVO) {
        PersonEntity entity = BeanMapper.map(saveOrUpdateVO, PersonEntity.class);
        if(entity.getId() == null || entity.getId() == 0){

            //查询当前合同是否存在自由态的单据
            QueryWrapper<PersonEntity> listQuery = new QueryWrapper<>();
            listQuery.eq("project_id", entity.getProjectId());
            listQuery.eq("informant_id", entity.getInformantId());
            listQuery.eq("informant_date", entity.getInformantDate());
            listQuery.eq("dr", 0);
            int resultCount = super.count(listQuery);
            if (resultCount > 0) {
                return CommonResponse.error("一个人一个项目当天只能有一个个人日志单据");
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 初始化汇总到项目日志-否
        entity.setGatherFlag(Boolean.FALSE);
        super.saveOrUpdate(entity, false);
        PersonVO personVO = BeanMapper.map(entity, PersonVO.class);
        return CommonResponse.success("保存或修改单据成功！",personVO);
    }


    /**
     * 查询自由态单据数量
     *
     * @param ids 主键
     *
     * @return Integer
     */
    @Override
    public Integer countUncommitedState(Set<Long> ids) {
        LambdaQueryWrapper<PersonEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.in(PersonEntity::getId, ids)
                .eq(PersonEntity::getBillState, BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        return super.count(lambdaQuery);
    }
}
