package com.ejianc.business.probuilddiary.construct.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaDetailEntity;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaEntity;
import com.ejianc.business.probuilddiary.construct.mapper.ConstructAreaMapper;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaService;
import com.ejianc.business.probuilddiary.construct.utils.TreeNodeBUtil;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaDetailVO;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 施工区域设置
 * 
 * @author generator
 * 
 */
@Service("constructAreaService")
public class ConstructAreaServiceImpl extends BaseServiceImpl<ConstructAreaMapper, ConstructAreaEntity> implements IConstructAreaService{
    private static final String BILL_CODE = "AREA_WORK";

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<ConstructAreaVO> insertOrUpdate(ConstructAreaVO vo) {
        ConstructAreaEntity entity = BeanMapper.map(vo, ConstructAreaEntity.class);
        if (entity.getId() == null) {
            //
            //查询当前合同是否存在自由态的单据
            QueryWrapper<ConstructAreaEntity> listQuery = new QueryWrapper<>();
            listQuery.eq("project_id", entity.getProjectId());
            listQuery.eq("dr", 0);
            int resultCount = super.count(listQuery);
            if (resultCount > 0) {
                return CommonResponse.error("一个项目只可以有一个施工区域单据！");
            }
            // 初始化主键
            entity.setId(IdWorker.getId());
            CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), vo));
            if (!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillCode(billCode.getData());
            if (entity.getHoldStatus()==null){
                entity.setHoldStatus("1");
            }
            //修改标识设置为未修改
            entity.setModifyFlag(0);
        }else {
            //保存生效
            ConstructAreaEntity entity1 = super.selectById(entity.getId());
            if (entity1!=null){
                entity.setBillState(entity1.getBillState());
                if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState()) ||
                    BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState())) {
                    //单据生效后修改，设置其修改标识
                    entity.setModifyFlag(1); //已修改
                }
            }
        }
        //保存前清空主键和父主键，重新生成
        resetPid(entity.getDetailList());
        super.saveOrUpdate(entity, false);
        ConstructAreaVO constructAreaVO = queryDetail(entity.getId(), vo.getOperate());
        return CommonResponse.success("保存或修改单据成功！",constructAreaVO);
    }

    @Override
    public ConstructAreaVO queryDetail(Long id,String operate) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderParams.put("treeIndex", QueryParam.ASC);
        orderMap.put("detailList", orderParams);
        ConstructAreaEntity constructAreaEntity = super.selectById(id, orderMap);
        ConstructAreaVO contractVO = BeanMapper.map(constructAreaEntity, ConstructAreaVO.class);
        if (CollectionUtils.isNotEmpty(contractVO.getDetailList())) {
            for (ConstructAreaDetailVO detail : contractVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            contractVO.setDetailList(TreeNodeBUtil.buildTree(contractVO.getDetailList()));
        }
        if (StringUtils.isNotEmpty(operate)){
            contractVO.setBillState(0);
        }
        return contractVO;
    }

    private void resetPid(List<ConstructAreaDetailEntity> detailList) {
        if(CollectionUtils.isNotEmpty(detailList)){
            Map<String,Long> idMap=new HashMap<>();
            for(ConstructAreaDetailEntity cdEntity : detailList){
                if (!("del").equals(cdEntity.getRowState())){
                    if (cdEntity.getId() == null){
                        cdEntity.setId(IdWorker.getId());
                        cdEntity.setDetailId(cdEntity.getId());
                    }
                    idMap.put(cdEntity.getTid().toString(), cdEntity.getId());
                    cdEntity.setParentId(null);
                }
                //新增设置id
//                if (("add").equals(cdEntity.getRowState())){
//                    cdEntity.setDetailId(IdWorker.getId());
//                }
            }
            for(ConstructAreaDetailEntity cdEntity : detailList){
                if (!("del").equals(cdEntity.getRowState())){
                    if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                        cdEntity.setParentId(idMap.get(cdEntity.getTpid().toString()));
                    }
                }
            }
        }
    }
}
