/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.construct.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaDetailEntity;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaEntity;
import com.ejianc.business.probuilddiary.construct.enums.AreaStatusEnum;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaDetailService;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaService;
import com.ejianc.business.probuilddiary.construct.utils.ExcelImportUtil;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaDetailVO;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"constructArea"})
public class ConstructAreaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IConstructAreaDetailService detailService;
    @Autowired
    private IConstructAreaService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConstructAreaVO> saveOrUpdate(@RequestBody ConstructAreaVO saveOrUpdateVO) {
        return this.service.insertOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConstructAreaVO> queryDetail(Long id, String operate) {
        ConstructAreaVO entity = this.service.queryDetail(id, operate);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)entity);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConstructAreaVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("staffingDate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConstructAreaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<ConstructAreaVO>> iPageCommonResponse = this.queryList(param);
        List records = new ArrayList();
        if (null != iPageCommonResponse.getData()) {
            records = ((IPage)iPageCommonResponse.getData()).getRecords();
            records.forEach(c -> c.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", records);
        ExcelExport.getInstance().export("ConstructArea-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refConstructAreaData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaVO>> refConstructAreaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConstructAreaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAreaDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaDetailEntity>> queryAreaDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
        }
        Page pageData = new Page(1L, 10L, 0L);
        List constructAreaEntities = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)constructAreaEntities)) {
            ConstructAreaEntity entity = (ConstructAreaEntity)((Object)constructAreaEntities.get(0));
            QueryParam queryParam = new QueryParam();
            queryParam.getFuzzyFields().add("dutyName");
            queryParam.getFuzzyFields().add("constructionRegion");
            queryParam.setPageSize(pageSize.intValue());
            queryParam.setPageIndex(pageNumber.intValue());
            queryParam.setSearchText(searchText);
            queryParam.setSearchObject(searchObject);
            queryParam.getParams().put("area_id", new Parameter("eq", (Object)entity.getId()));
            queryParam.getParams().put("detail_status", new Parameter("eq", (Object)AreaStatusEnum.\u542f\u7528.getCode()));
            IPage page = this.detailService.queryPage(queryParam);
            pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(page.getRecords());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"constructArea-import.xlsx", (String)"\u65bd\u5de5\u533a\u57df\u8bbe\u7f6e\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        ArrayList<ConstructAreaDetailVO> errorsList = new ArrayList<ConstructAreaDetailVO>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            ArrayList falseList;
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<ConstructAreaDetailVO> detailVoList = new ArrayList<ConstructAreaDetailVO>();
            HashMap<String, Long> tidMap = new HashMap<String, Long>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ConstructAreaDetailVO vo = new ConstructAreaDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                Long id = IdWorker.getId();
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(String.valueOf(id));
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        parentWarn = true;
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    } else {
                        vo.setParentId(Long.valueOf(999L));
                    }
                } else {
                    vo.setTid(String.valueOf(id));
                    vo.setTpid("");
                    vo.setParentId(Long.valueOf(999L));
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    vo.setTreeIndex(null);
                    flag = true;
                } else {
                    vo.setTreeIndex((String)datas.get(0));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    if (parentWarn) {
                        vo.setConstructionRegion(null);
                    } else {
                        vo.setConstructionRegion((String)datas.get(1));
                    }
                } else if (!parentWarn) {
                    vo.setConstructionRegion(null);
                    vo.setErrorMessage("\u7b2c" + i + "\u884c\u6570\u636e\uff1a\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8003\u6838\u5185\u5bb9\u5fc5\u586b\uff01");
                }
                parentWarn = false;
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setDetailId(Long.valueOf(vo.getTid()));
                vo.setRowState("add");
                vo.setEditFlag(Boolean.valueOf(true));
                if (StringUtils.isNotBlank((CharSequence)vo.getErrorMessage())) {
                    errorsList.add(vo);
                    continue;
                }
                detailVoList.add(vo);
            }
            for (ConstructAreaDetailVO tVo : detailVoList) {
                tVo.setTpid(String.valueOf(tidMap.get(tVo.getTpid())));
            }
            List deailTreeData = ExcelImportUtil.treeData((List)BeanMapper.mapList(detailVoList, Map.class));
            List mapList = ExcelImportUtil.importFlag((List)deailTreeData);
            List allList = ExcelImportUtil.separate((List)mapList, falseList = new ArrayList());
            List errorList = ExcelImportUtil.treeToList((List)((List)allList.get(1)));
            if (errorList.size() > 0) {
                resp.put("errorList", (Object)errorList);
                resp.put("errorNum", (Object)errorList.size());
            } else {
                resp.put("errorList", errorsList);
                resp.put("errorNum", (Object)0);
            }
            resp.put("successList", allList.get(0));
            resp.put("successNum", (Object)(result.size() - 1 - errorList.size()));
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }
}

