package com.ejianc.business.probuilddiary.ledger.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.probuilddiary.ledger.bean.*;
import com.ejianc.business.probuilddiary.ledger.mapper.*;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerService;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerTemplateService;
import com.ejianc.business.probuilddiary.ledger.vo.*;
import com.ejianc.business.probuilddiary.project.bean.*;
import com.ejianc.business.probuilddiary.project.dtomapper.*;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 日志台账
 *
 * @author generator
 */
@Service("ledgerService")
public class LedgerServiceImpl extends BaseServiceImpl<LedgerMapper, LedgerEntity> implements ILedgerService {

	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String SCHEDULE_WORK_TYPE = "schedule_work_type";
	private static final String TYPE_WORK_TYPE = "type_work_type";
	private static final String QUALITY_WORK_TYPE = "quality_work_type";
	private static final String SAFETY_WORK_TYPE = "safety_work_type";
	private static final String MATERIAL_WORK_TYPE = "material_work_type";
	private static final String EQUIPMENT_WORK_TYPE = "equipment_work_type";
	private static final String EXAMINE_WORK_TYPE = "examine_work_type";
	private static final String INFORMATION_WORK_TYPE = "information_work_type";
	private static final String OTHER_WORK_TYPE = "other_work_type";

	private static final String SCHEDULE_TITLE = "进度情况（施工员）";
	private static final String TYPE_TITLE = "施工组织设计、方案、交底、变更情况（技术负责人）";
	private static final String QUALITY_TITLE = "工程质量检查、验收情况（质检员）";
	private static final String SAFETY_TITLE = "安全活动情况（安全员）";
	private static final String MATERIAL_TITLE = "材料进场情况（材料员）";
	private static final String EQUIPMENT_TITLE = "设备进场情况（设备管理员）";
	private static final String EXAMINE_TITLE = "原材料检验、时间、试块及见证取样送检等情况（取样员）";
	private static final String INFORMATION_TITLE = "工程资料归档及会议情况（资料员）";
	private static final String OTHER_TITLE = "其他情况";
	private static final String RULE_CODE = "PRO-BUILD-DIARY-LEDGER";
	private final IBillCodeApi billCodeApi;
	private final ILedgerTemplateService templateService;
	private final LedgerMapper ledgerMapper;
	private final LedgerDetailMapper ledgerDetailMapper;
	private final LedgerScheduleMapper ledgerScheduleMapper;
	private final LedgerTypeMapper ledgerTypeMapper;
	private final LedgerQualityMapper ledgerQualityMapper;
	private final LedgerSafetyMapper ledgerSafetyMapper;
	private final LedgerMaterialMapper ledgerMaterialMapper;
	private final LedgerEquipmentMapper ledgerEquipmentMapper;
	private final LedgerExamineMapper ledgerExamineMapper;
	private final LedgerInformationMapper ledgerInformationMapper;
	private final LedgerOtherMapper ledgerOtherMapper;


	public LedgerServiceImpl(IBillCodeApi billCodeApi, ILedgerTemplateService templateService, LedgerMapper ledgerMapper, LedgerDetailMapper ledgerDetailMapper, LedgerScheduleMapper ledgerScheduleMapper, LedgerTypeMapper ledgerTypeMapper, LedgerQualityMapper ledgerQualityMapper, LedgerSafetyMapper ledgerSafetyMapper, LedgerMaterialMapper ledgerMaterialMapper, LedgerEquipmentMapper ledgerEquipmentMapper, LedgerExamineMapper ledgerExamineMapper, LedgerInformationMapper ledgerInformationMapper, LedgerOtherMapper ledgerOtherMapper) {
		this.billCodeApi = billCodeApi;
		this.templateService = templateService;
		this.ledgerMapper = ledgerMapper;
		this.ledgerDetailMapper = ledgerDetailMapper;
		this.ledgerScheduleMapper = ledgerScheduleMapper;
		this.ledgerTypeMapper = ledgerTypeMapper;
		this.ledgerQualityMapper = ledgerQualityMapper;
		this.ledgerSafetyMapper = ledgerSafetyMapper;
		this.ledgerMaterialMapper = ledgerMaterialMapper;
		this.ledgerEquipmentMapper = ledgerEquipmentMapper;
		this.ledgerExamineMapper = ledgerExamineMapper;
		this.ledgerInformationMapper = ledgerInformationMapper;
		this.ledgerOtherMapper = ledgerOtherMapper;
	}

	/**
	 * 查询其他子表数据
	 *
	 * @param id 主键
	 *
	 * @return LedgerSubVO
	 */
	@Override
	public List<JSONObject> fetchOtherSubDetail(Long id) {
		ArrayList<JSONObject> jsonObjects = new ArrayList<>();

		LedgerEntity entity = super.selectById(id);
		LedgerVO ledgerVO = BeanMapper.map(entity, LedgerVO.class);

		List<LedgerScheduleVO> ledgerScheduleList = ledgerVO.getLedgerScheduleList();
		List<LedgerTypeVO> ledgerTypeList = ledgerVO.getLedgerTypeList();
		List<LedgerQualityVO> ledgerQualityList = ledgerVO.getLedgerQualityList();
		List<LedgerSafetyVO> ledgerSafetyList = ledgerVO.getLedgerSafetyList();
		List<LedgerMaterialVO> ledgerMaterialList = ledgerVO.getLedgerMaterialList();
		List<LedgerEquipmentVO> ledgerEquipmentList = ledgerVO.getLedgerEquipmentList();
		List<LedgerExamineVO> ledgerExamineList = ledgerVO.getLedgerExamineList();
		List<LedgerInformationVO> ledgerInformationList = ledgerVO.getLedgerInformationList();
		List<LedgerOtherVO> ledgerOtherList = ledgerVO.getLedgerOtherList();

		// 根据表名简写_work_type查询模版内容
		List<LedgerTemplateEntity> ledgerTemplates = templateService.list();

		// 进度情况（施工员）
		if (CollectionUtils.isNotEmpty(ledgerScheduleList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, SCHEDULE_WORK_TYPE);
			if (null != collect) {
				for (LedgerScheduleVO vo : ledgerScheduleList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject1 = new JSONObject();
		jsonObject1.put("title", SCHEDULE_TITLE);
		jsonObject1.put("describe", ledgerScheduleList);
		jsonObjects.add(jsonObject1);

		// 施工组织设计、方案、交底、变更情况（技术负责人）
		if (CollectionUtils.isNotEmpty(ledgerTypeList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, TYPE_WORK_TYPE);
			if (null != collect) {
				for (LedgerTypeVO vo : ledgerTypeList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject2 = new JSONObject();
		jsonObject2.put("title", TYPE_TITLE);
		jsonObject2.put("describe", ledgerTypeList);
		jsonObjects.add(jsonObject2);

		// 工程质量检查、验收情况（质检员）
		if (CollectionUtils.isNotEmpty(ledgerQualityList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, QUALITY_WORK_TYPE);
			if (null != collect) {
				for (LedgerQualityVO vo : ledgerQualityList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject3 = new JSONObject();
		jsonObject3.put("title", QUALITY_TITLE);
		jsonObject3.put("describe", ledgerQualityList);
		jsonObjects.add(jsonObject3);

		// 安全活动情况（安全员）
		if (CollectionUtils.isNotEmpty(ledgerSafetyList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, SAFETY_WORK_TYPE);
			if (null != collect) {
				for (LedgerSafetyVO vo : ledgerSafetyList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject4 = new JSONObject();
		jsonObject4.put("title", SAFETY_TITLE);
		jsonObject4.put("describe", ledgerSafetyList);
		jsonObjects.add(jsonObject4);

		// 材料进场情况（材料员）
		if (CollectionUtils.isNotEmpty(ledgerMaterialList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, MATERIAL_WORK_TYPE);
			if (null != collect) {
				for (LedgerMaterialVO vo : ledgerMaterialList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject5 = new JSONObject();
		jsonObject5.put("title", MATERIAL_TITLE);
		jsonObject5.put("describe", ledgerMaterialList);
		jsonObjects.add(jsonObject5);

		// 设备进场情况（设备管理员）
		if (CollectionUtils.isNotEmpty(ledgerEquipmentList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, EQUIPMENT_WORK_TYPE);
			if (null != collect) {
				for (LedgerEquipmentVO vo : ledgerEquipmentList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject6 = new JSONObject();
		jsonObject6.put("title", EQUIPMENT_TITLE);
		jsonObject6.put("describe", ledgerEquipmentList);
		jsonObjects.add(jsonObject6);

		// 原材料检验、时间、试块及见证取样送检等情况（取样员）
		if (CollectionUtils.isNotEmpty(ledgerExamineList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, EXAMINE_WORK_TYPE);
			if (null != collect) {
				for (LedgerExamineVO vo : ledgerExamineList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject7 = new JSONObject();
		jsonObject7.put("title", EXAMINE_TITLE);
		jsonObject7.put("describe", ledgerExamineList);
		jsonObjects.add(jsonObject7);

		// 工程资料归档及会议情况（资料员）
		if (CollectionUtils.isNotEmpty(ledgerInformationList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, INFORMATION_WORK_TYPE);
			if (null != collect) {
				for (LedgerInformationVO vo : ledgerInformationList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject8 = new JSONObject();
		jsonObject8.put("title", INFORMATION_TITLE);
		jsonObject8.put("describe", ledgerInformationList);
		jsonObjects.add(jsonObject8);

		// 其他情况
		if (CollectionUtils.isNotEmpty(ledgerOtherList)) {
			LedgerTemplateEntity collect = getTemplateContent(ledgerTemplates, OTHER_WORK_TYPE);
			if (null != collect) {
				for (LedgerOtherVO vo : ledgerOtherList) {
					vo.setTemplateContent(collect.getTemplateContent());
				}
			}
		}
		JSONObject jsonObject9 = new JSONObject();
		jsonObject9.put("title", OTHER_TITLE);
		jsonObject9.put("describe", ledgerOtherList);
		jsonObjects.add(jsonObject9);


		return jsonObjects;
	}

	private static LedgerTemplateEntity getTemplateContent(List<LedgerTemplateEntity> ledgerTemplates, String type) {
		for (LedgerTemplateEntity entity : ledgerTemplates) {
			if (type.equals(entity.getTemplateType())) {
				return entity;
			}
		}
		return null;
	}

	/**
	 * 项目日志实体转换日志台账
	 *
	 * @param entity 项目日志实体
	 *
	 * @return 日志台账实体
	 */
	@Override
	public LedgerEntity projectLogConvertToLedger(ProjectLogEntity entity) {
		logger.info("项目日志实体转换日志台账：{}", JSON.toJSONString(entity, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
		// todo: perf优化
		LedgerEntity ledgerEntity = ProjectLogMapper.INSTANCE.transToLedgerEntity(entity);
		ledgerEntity.setBillCode(generateBillCode());
		List<ProjectLogDetailEntity> projectLogDetailList = entity.getProjectLogDetailList();
		List<ProjectLogScheduleEntity> projectLogScheduleList = entity.getProjectLogScheduleList();
		List<ProjectLogTypeEntity> projectLogTypeList = entity.getProjectLogTypeList();
		List<ProjectLogQualityEntity> projectLogQualityList = entity.getProjectLogQualityList();
		List<ProjectLogSafetyEntity> projectLogSafetyList = entity.getProjectLogSafetyList();
		List<ProjectLogMaterialEntity> projectLogMaterialList = entity.getProjectLogMaterialList();
		List<ProjectLogEquipmentEntity> projectLogEquipmentList = entity.getProjectLogEquipmentList();
		List<ProjectLogExamineEntity> projectLogExamineList = entity.getProjectLogExamineList();
		List<ProjectLogInformationEntity> projectLogInformationList = entity.getProjectLogInformationList();
		List<ProjectLogOtherEntity> projectLogOtherList = entity.getProjectLogOtherList();

		if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
			projectLogDetailList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
				List<LedgerDetailEntity> entityList = ProjectLogDetailMapper.INSTANCE.transToLedgerDetailEntity(projectLogDetailList);
				ledgerEntity.setLedgerDetailList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogScheduleList)) {
			projectLogScheduleList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogScheduleList)) {
				List<LedgerScheduleEntity> entityList = ProjectLogScheduleMapper.INSTANCE.transToLedgerScheduleEntity(projectLogScheduleList);
				ledgerEntity.setLedgerScheduleList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogTypeList)) {
			projectLogTypeList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogTypeList)) {
				List<LedgerTypeEntity> entityList = ProjectLogTypeMapper.INSTANCE.transToLedgerTypeEntity(projectLogTypeList);
				ledgerEntity.setLedgerTypeList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogQualityList)) {
			projectLogQualityList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogQualityList)) {
				List<LedgerQualityEntity> entityList = ProjectLogQualityMapper.INSTANCE.transToLedgerQualityEntity(projectLogQualityList);
				ledgerEntity.setLedgerQualityList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogSafetyList)) {
			projectLogSafetyList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogSafetyList)) {
				List<LedgerSafetyEntity> entityList = ProjectLogSafetyMapper.INSTANCE.transToLedgerSafetyEntity(projectLogSafetyList);
				ledgerEntity.setLedgerSafetyList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogMaterialList)) {
			projectLogMaterialList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogMaterialList)) {
				List<LedgerMaterialEntity> entityList = ProjectLogMaterialMapper.INSTANCE.transToLedgerMaterialEntity(projectLogMaterialList);
				ledgerEntity.setLedgerMaterialList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogEquipmentList)) {
			projectLogEquipmentList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogEquipmentList)) {
				List<LedgerEquipmentEntity> entityList = ProjectLogEquipmentMapper.INSTANCE.transToLedgerEquipmentEntity(projectLogEquipmentList);
				ledgerEntity.setLedgerEquipmentList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogExamineList)) {
			projectLogExamineList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogExamineList)) {
				List<LedgerExamineEntity> entityList = ProjectLogExamineMapper.INSTANCE.transToLedgerExamineEntity(projectLogExamineList);
				ledgerEntity.setLedgerExamineList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogInformationList)) {
			projectLogInformationList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogInformationList)) {
				List<LedgerInformationEntity> entityList = ProjectLogInformationMapper.INSTANCE.transToLedgerInformationEntity(projectLogInformationList);
				ledgerEntity.setLedgerInformationList(entityList);
			}
		}

		if (CollectionUtils.isNotEmpty(projectLogOtherList)) {
			projectLogOtherList.removeIf(e -> !e.getUpdateFlag());
			if (CollectionUtils.isNotEmpty(projectLogOtherList)) {
				List<LedgerOtherEntity> entityList = ProjectLogOtherMapper.INSTANCE.transToLedgerOtherEntity(projectLogOtherList);
				ledgerEntity.setLedgerOtherList(entityList);
			}
		}

		return ledgerEntity;
	}


	/**
	 * 生成单据编码
	 *
	 * @return 单据编码
	 */
	private String generateBillCode() {
		BillCodeParam billCodeParam = BillCodeParam.build(RULE_CODE, InvocationInfoProxy.getTenantid(), new ProjectLogVO());
		CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
		if (!billCode.isSuccess()) {
			throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
		}
		return billCode.getData();
	}


	/**
	 * 处理子表打印数据
	 *
	 * @param detailJson 子表json数据
	 */
	@Override
	public void handleOtherSubDetail(JSONObject detailJson) {
		JSONObject ledger = detailJson.getJSONObject("Ledger");

		List<LedgerTemplateEntity> ledgerTemplates = templateService.list();
		// todo:抽个通用方法
		JSONArray ledgerSchedule = ledger.getJSONArray("LedgerSchedule");
		if (CollectionUtils.isNotEmpty(ledgerSchedule)) {
			List<LedgerScheduleVO> vos = JSONObject.parseArray(JSONObject.toJSONString(ledgerSchedule), LedgerScheduleVO.class);
			LedgerTemplateEntity l = getTemplateContent(ledgerTemplates, SCHEDULE_WORK_TYPE);
			if (null != l) {
				String printTemplateContent = l.getPrintTemplateContent();
				if (StringUtils.isNotBlank(printTemplateContent)) {
					String[] strs = printTemplateContent.split("#");
					String last = strs[strs.length - 1];
					StringBuffer sb = new StringBuffer();
					for (LedgerScheduleVO vo : vos) {
						JSONObject js = (JSONObject) JSON.toJSON(vo);
						for (String str : strs) {
							if (js.get(str) instanceof Date) {
								Date date = (Date) js.get(str);
								LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
								DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
								if (last.equals(str)) {
									sb.append(localDateTime.format(formatter)).append(l.getNewline());
								} else {
									sb.append(localDateTime.format(formatter));
								}
							} else {
								if (last.equals(str)) {
									sb.append(js.get(str)).append(l.getNewline());
								} else {
									sb.append(js.get(str));
								}
							}
						}
					}
					ledger.put("ledgerScheduleDescription", sb.toString());
				}
			}
		}

		JSONArray ledgerType = ledger.getJSONArray("LedgerType");
		if (CollectionUtils.isNotEmpty(ledgerType)) {
			List<LedgerTypeVO> vos = JSONObject.parseArray(JSONObject.toJSONString(ledgerType), LedgerTypeVO.class);
			LedgerTemplateEntity l = getTemplateContent(ledgerTemplates, TYPE_WORK_TYPE);
			if (null != l) {
				String printTemplateContent = l.getPrintTemplateContent();
				if (StringUtils.isNotBlank(printTemplateContent)) {
					String[] strs = printTemplateContent.split("#");
					String last = strs[strs.length - 1];
					StringBuffer sb = new StringBuffer();
					for (LedgerTypeVO vo : vos) {
						JSONObject js = (JSONObject) JSON.toJSON(vo);
						for (String str : strs) {
							if (js.get(str) instanceof Date) {
								Date date = (Date) js.get(str);
								LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
								DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
								if (last.equals(str)) {
									sb.append(localDateTime.format(formatter)).append(l.getNewline());
								} else {
									sb.append(localDateTime.format(formatter));
								}
							} else {
								if (last.equals(str)) {
									sb.append(js.get(str)).append(l.getNewline());
								} else {
									sb.append(js.get(str));
								}
							}
						}
					}
					ledger.put("ledgerTypeDescription", sb.toString());
				}
			}
		}

		JSONArray ledgerQuality = ledger.getJSONArray("LedgerQuality");
		if (CollectionUtils.isNotEmpty(ledgerQuality)) {
			List<LedgerQualityVO> vos = JSONObject.parseArray(JSONObject.toJSONString(ledgerQuality), LedgerQualityVO.class);
			LedgerTemplateEntity l = getTemplateContent(ledgerTemplates, QUALITY_WORK_TYPE);
			if (null != l) {
				String printTemplateContent = l.getPrintTemplateContent();
				if (StringUtils.isNotBlank(printTemplateContent)) {
					String[] strs = printTemplateContent.split("#");
					String last = strs[strs.length - 1];
					StringBuffer sb = new StringBuffer();
					for (LedgerQualityVO vo : vos) {
						JSONObject js = (JSONObject) JSON.toJSON(vo);
						for (String str : strs) {
							if (js.get(str) instanceof Date) {
								Date date = (Date) js.get(str);
								LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
								DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
								if (last.equals(str)) {
									sb.append(localDateTime.format(formatter)).append(l.getNewline());
								} else {
									sb.append(localDateTime.format(formatter));
								}
							} else {
								if (last.equals(str)) {
									sb.append(js.get(str)).append(l.getNewline());
								} else {
									sb.append(js.get(str));
								}
							}
						}
					}
					ledger.put("ledgerQualityDescription", sb.toString());
				}
			}
		}

		JSONArray ledgerSafety = ledger.getJSONArray("LedgerSafety");
		if (CollectionUtils.isNotEmpty(ledgerSafety)) {
			List<LedgerSafetyVO> vos = JSONObject.parseArray(JSONObject.toJSONString(ledgerSafety), LedgerSafetyVO.class);
			LedgerTemplateEntity l = getTemplateContent(ledgerTemplates, SAFETY_WORK_TYPE);
			if (null != l) {
				String printTemplateContent = l.getPrintTemplateContent();
				if (StringUtils.isNotBlank(printTemplateContent)) {
					String[] strs = printTemplateContent.split("#");
					String last = strs[strs.length - 1];
					StringBuffer sb = new StringBuffer();
					for (LedgerSafetyVO vo : vos) {
						JSONObject js = (JSONObject) JSON.toJSON(vo);
						for (String str : strs) {
							if (js.get(str) instanceof Date) {
								Date date = (Date) js.get(str);
								LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
								DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
								if (last.equals(str)) {
									sb.append(localDateTime.format(formatter)).append(l.getNewline());
								} else {
									sb.append(localDateTime.format(formatter));
								}
							} else {
								if (last.equals(str)) {
									sb.append(js.get(str)).append(l.getNewline());
								} else {
									sb.append(js.get(str));
								}
							}
						}
					}
					ledger.put("ledgerSafetyDescription", sb.toString());
				}
			}
		}

		JSONArray ledgerMaterial = ledger.getJSONArray("LedgerMaterial");
		if (CollectionUtils.isNotEmpty(ledgerMaterial)) {
			List<LedgerMaterialVO> vos = JSONObject.parseArray(JSONObject.toJSONString(ledgerMaterial), LedgerMaterialVO.class);
			LedgerTemplateEntity l = getTemplateContent(ledgerTemplates, MATERIAL_WORK_TYPE);
			if (null != l) {
				String printTemplateContent = l.getPrintTemplateContent();
				if (StringUtils.isNotBlank(printTemplateContent)) {
					String[] strs = printTemplateContent.split("#");
					String last = strs[strs.length - 1];
					StringBuffer sb = new StringBuffer();
					for (LedgerMaterialVO vo : vos) {
						JSONObject js = (JSONObject) JSON.toJSON(vo);
						for (String str : strs) {
							if (js.get(str) instanceof Date) {
								Date date = (Date) js.get(str);
								LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
								DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
								if (last.equals(str)) {
									sb.append(localDateTime.format(formatter)).append(l.getNewline());
								} else {
									sb.append(localDateTime.format(formatter));
								}
							} else {
								if (last.equals(str)) {
									sb.append(js.get(str)).append(l.getNewline());
								} else {
									sb.append(js.get(str));
								}
							}
						}
					}
					ledger.put("ledgerMaterialDescription", sb.toString());
				}
			}
		}

		JSONArray ledgerEquipment = ledger.getJSONArray("LedgerEquipment");
		if (CollectionUtils.isNotEmpty(ledgerEquipment)) {
			List<LedgerEquipmentVO> vos = JSONObject.parseArray(JSONObject.toJSONString(ledgerEquipment), LedgerEquipmentVO.class);
			LedgerTemplateEntity l = getTemplateContent(ledgerTemplates, EQUIPMENT_WORK_TYPE);
			if (null != l) {
				String printTemplateContent = l.getPrintTemplateContent();
				if (StringUtils.isNotBlank(printTemplateContent)) {
					String[] strs = printTemplateContent.split("#");
					String last = strs[strs.length - 1];
					StringBuffer sb = new StringBuffer();
					for (LedgerEquipmentVO vo : vos) {
						JSONObject js = (JSONObject) JSON.toJSON(vo);
						for (String str : strs) {
							if (js.get(str) instanceof Date) {
								Date date = (Date) js.get(str);
								LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
								DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
								if (last.equals(str)) {
									sb.append(localDateTime.format(formatter)).append(l.getNewline());
								} else {
									sb.append(localDateTime.format(formatter));
								}
							} else {
								if (last.equals(str)) {
									sb.append(js.get(str)).append(l.getNewline());
								} else {
									sb.append(js.get(str));
								}
							}
						}
					}
					ledger.put("ledgerEquipmentDescription", sb.toString());
				}
			}
		}

		JSONArray ledgerExamine = ledger.getJSONArray("LedgerExamine");
		if (CollectionUtils.isNotEmpty(ledgerExamine)) {
			List<LedgerExamineVO> vos = JSONObject.parseArray(JSONObject.toJSONString(ledgerExamine), LedgerExamineVO.class);
			LedgerTemplateEntity l = getTemplateContent(ledgerTemplates, EXAMINE_WORK_TYPE);
			if (null != l) {
				String printTemplateContent = l.getPrintTemplateContent();
				if (StringUtils.isNotBlank(printTemplateContent)) {
					String[] strs = printTemplateContent.split("#");
					String last = strs[strs.length - 1];
					StringBuffer sb = new StringBuffer();
					for (LedgerExamineVO vo : vos) {
						JSONObject js = (JSONObject) JSON.toJSON(vo);
						for (String str : strs) {
							if (js.get(str) instanceof Date) {
								Date date = (Date) js.get(str);
								LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
								DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
								if (last.equals(str)) {
									sb.append(localDateTime.format(formatter)).append(l.getNewline());
								} else {
									sb.append(localDateTime.format(formatter));
								}
							} else {
								if (last.equals(str)) {
									sb.append(js.get(str)).append(l.getNewline());
								} else {
									sb.append(js.get(str));
								}
							}
						}
					}
					ledger.put("ledgerExamineDescription", sb.toString());
				}
			}
		}

		JSONArray ledgerInformation = ledger.getJSONArray("LedgerInformation");
		if (CollectionUtils.isNotEmpty(ledgerInformation)) {
			List<LedgerInformationVO> vos = JSONObject.parseArray(JSONObject.toJSONString(ledgerInformation), LedgerInformationVO.class);
			LedgerTemplateEntity l = getTemplateContent(ledgerTemplates, INFORMATION_WORK_TYPE);
			if (null != l) {
				String printTemplateContent = l.getPrintTemplateContent();
				if (StringUtils.isNotBlank(printTemplateContent)) {
					String[] strs = printTemplateContent.split("#");
					String last = strs[strs.length - 1];
					StringBuffer sb = new StringBuffer();
					for (LedgerInformationVO vo : vos) {
						JSONObject js = (JSONObject) JSON.toJSON(vo);
						for (String str : strs) {
							if (js.get(str) instanceof Date) {
								Date date = (Date) js.get(str);
								LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
								DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
								if (last.equals(str)) {
									sb.append(localDateTime.format(formatter)).append(l.getNewline());
								} else {
									sb.append(localDateTime.format(formatter));
								}
							} else {
								if (last.equals(str)) {
									sb.append(js.get(str)).append(l.getNewline());
								} else {
									sb.append(js.get(str));
								}
							}
						}
					}
					ledger.put("ledgerInformationDescription", sb.toString());
				}
			}
		}

		JSONArray ledgerOther = ledger.getJSONArray("LedgerOther");
		if (CollectionUtils.isNotEmpty(ledgerOther)) {
			List<LedgerOtherVO> vos = JSONObject.parseArray(JSONObject.toJSONString(ledgerOther), LedgerOtherVO.class);
			LedgerTemplateEntity l = getTemplateContent(ledgerTemplates, OTHER_WORK_TYPE);
			if (null != l) {
				String printTemplateContent = l.getPrintTemplateContent();
				if (StringUtils.isNotBlank(printTemplateContent)) {
					String[] strs = printTemplateContent.split("#");
					String last = strs[strs.length - 1];
					StringBuffer sb = new StringBuffer();
					for (LedgerOtherVO vo : vos) {
						JSONObject js = (JSONObject) JSON.toJSON(vo);
						for (String str : strs) {
							if (js.get(str) instanceof Date) {
								Date date = (Date) js.get(str);
								LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
								DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
								if (last.equals(str)) {
									sb.append(localDateTime.format(formatter)).append(l.getNewline());
								} else {
									sb.append(localDateTime.format(formatter));
								}
							} else {
								if (last.equals(str)) {
									sb.append(js.get(str)).append(l.getNewline());
								} else {
									sb.append(js.get(str));
								}
							}
						}
					}
					ledger.put("ledgerOtherDescription", sb.toString());
				}
			}
		}
		detailJson.put("Ledger", ledger);
		logger.info("打印数据处理成功，Ledger--{}", JSON.toJSONString(ledger, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
	}


	/**
	 * 根据项目日志id删除日志台账数据
	 *
	 * @param id 项目日志id
	 */
	@Override
	public void deleteAllDataByProjectLogId(Long id) {
		ledgerMapper.deleteByProjectLogId(id);
		ledgerDetailMapper.deleteByProjectLogId(id);
		ledgerScheduleMapper.deleteByProjectLogId(id);
		ledgerTypeMapper.deleteByProjectLogId(id);
		ledgerQualityMapper.deleteByProjectLogId(id);
		ledgerSafetyMapper.deleteByProjectLogId(id);
		ledgerMaterialMapper.deleteByProjectLogId(id);
		ledgerEquipmentMapper.deleteByProjectLogId(id);
		ledgerExamineMapper.deleteByProjectLogId(id);
		ledgerInformationMapper.deleteByProjectLogId(id);
		ledgerOtherMapper.deleteByProjectLogId(id);
	}
}
