/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.person.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.probuilddiary.person.bean.PersonEntity;
import com.ejianc.business.probuilddiary.person.enums.DiaryEnum;
import com.ejianc.business.probuilddiary.person.service.IPersonService;
import com.ejianc.business.probuilddiary.person.service.ITemplateService;
import com.ejianc.business.probuilddiary.person.vo.PersonVO;
import com.ejianc.business.probuilddiary.person.vo.TemplateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"person"})
public class PersonController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PERSON_LOG";
    @Autowired
    private IPersonService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemplateService templateService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PersonVO> saveOrUpdate(@RequestBody PersonVO saveOrUpdateVO) {
        return this.service.newSaveOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PersonVO> queryDetail(Long id) {
        PersonEntity entity = (PersonEntity)((Object)this.service.selectById(id));
        PersonVO vo = (PersonVO)BeanMapper.map((Object)((Object)entity), PersonVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PersonVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PersonVO>> queryList(@RequestBody QueryParam param) {
        return this.service.newQuery(param);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Person-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPersonData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PersonVO>> refPersonData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PersonVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryTemplate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> queryTemplate(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("sorted", "asc");
        queryParam.setOrderMap(orderMap);
        IPage page = this.templateService.queryPage(queryParam);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TemplateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryUserTemplate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<TemplateVO>> queryUserTemplate(Long userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"informant_id", (Object)userId);
        queryWrapper.orderByAsc((Object)"create_time");
        PersonEntity one = (PersonEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        ArrayList<String> codes = new ArrayList<String>();
        if (one != null) {
            PersonEntity personEntity = (PersonEntity)((Object)this.service.selectById(one.getId()));
            if (CollectionUtils.isNotEmpty(personEntity.getDetailList())) {
                codes.add(DiaryEnum.\u65bd\u5de5\u5185\u5bb9.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getEquipmentList())) {
                codes.add(DiaryEnum.\u8bbe\u5907\u8fdb\u573a\u60c5\u51b5.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getExamineList())) {
                codes.add(DiaryEnum.\u539f\u6750\u6599\u68c0\u9a8c\u65f6\u95f4\u8bd5\u5757\u53ca\u89c1\u8bc1\u53d6\u6837\u9001\u68c0\u7b49\u60c5\u51b5.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getInformationList())) {
                codes.add(DiaryEnum.\u5de5\u7a0b\u8d44\u6599\u5f52\u6863\u53ca\u4f1a\u8bae\u60c5\u51b5.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getMaterialList())) {
                codes.add(DiaryEnum.\u6750\u6599\u8fdb\u573a\u60c5\u51b5.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getOtherList())) {
                codes.add(DiaryEnum.\u8fdb\u5ea6\u60c5\u51b5.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getQualityList())) {
                codes.add(DiaryEnum.\u5de5\u7a0b\u8d28\u91cf\u68c0\u67e5\u9a8c\u6536\u60c5\u51b5.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getSafetyList())) {
                codes.add(DiaryEnum.\u5b89\u5168\u6d3b\u52a8\u60c5\u51b5.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getTypeList())) {
                codes.add(DiaryEnum.\u65bd\u5de5\u7ec4\u7ec7\u8bbe\u8ba1\u65b9\u6848\u4ea4\u5e95\u53d8\u66f4\u60c5\u51b5.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getScheduleList())) {
                codes.add(DiaryEnum.\u8fdb\u5ea6\u60c5\u51b5.getCode());
            }
        }
        List voList = new ArrayList();
        if (!codes.isEmpty()) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("bill_code", new Parameter("in", codes));
            LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
            orderMap.put("sorted", "asc");
            queryParam.setOrderMap(orderMap);
            List templateEntities = this.templateService.queryList(queryParam);
            voList = BeanMapper.mapList((Iterable)templateEntities, TemplateVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", voList);
    }
}

