package com.ejianc.business.probuilddiary.construct.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.vo.CommentModleContentVO;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaDetailEntity;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaEntity;
import com.ejianc.business.probuilddiary.construct.enums.AreaStatusEnum;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaDetailService;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaService;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaDetailVO;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaImportVO;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 施工区域设置
 *
 * @author generator
 */
@Controller
@RequestMapping("constructArea")
public class ConstructAreaController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IConstructAreaDetailService detailService;


    @Autowired
    private IConstructAreaService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConstructAreaVO> saveOrUpdate(@RequestBody ConstructAreaVO saveOrUpdateVO) {
        return service.insertOrUpdate(saveOrUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConstructAreaVO> queryDetail(Long id,String operate) {
        ConstructAreaVO entity = service.queryDetail(id,operate);
        return CommonResponse.success("查询详情数据成功！", entity);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConstructAreaVO> vos) {
        service.removeByIds(vos.stream().map(ConstructAreaVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 编号、名称、编制人、编制日期 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("staffingDate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<ConstructAreaEntity> page = service.queryPage(param, false);
        IPage<ConstructAreaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConstructAreaVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<ConstructAreaVO>> iPageCommonResponse = queryList(param);
        List<ConstructAreaVO> records = new ArrayList<>();
        if (null != iPageCommonResponse.getData()){
            records = iPageCommonResponse.getData().getRecords();
            records.forEach(c->{
                c.setBillStateStr(BillStateEnum.getEnumByStateCode(c.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("ConstructArea-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refConstructAreaData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaVO>> refConstructAreaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ConstructAreaEntity> page = service.queryPage(param, false);
        IPage<ConstructAreaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConstructAreaVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }



    /**
     * @Description 参照
     * @Return void ConstructAreaEntity
     * 传入合同id:必传   excludeIds:可选 逗号分割 本次查询不查询传入的班组id
     */
    @RequestMapping(value = "/queryAreaDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaDetailEntity>> queryAreaDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
            if (null != conditionMap.get("projectId")){
                Long projectId  = Long.parseLong(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        IPage<ConstructAreaDetailEntity> pageData  = new Page<>(1, 10, 0);;
        List<ConstructAreaEntity> constructAreaEntities = service.queryList(param);

        if (CollectionUtils.isNotEmpty(constructAreaEntities)){
            ConstructAreaEntity entity = constructAreaEntities.get(0);
            QueryParam queryParam = new QueryParam();
            //模块匹配字段：施工区域名称、负责人名称
            queryParam.getFuzzyFields().add("dutyName");
            queryParam.getFuzzyFields().add("constructionRegion");
            queryParam.setPageSize(pageSize);
            queryParam.setPageIndex(pageNumber);
            queryParam.setSearchText(searchText);
            queryParam.setSearchObject(searchObject);
            queryParam.getParams().put("area_id",new Parameter(QueryParam.EQ,entity.getId()));
            queryParam.getParams().put("detail_status",new Parameter(QueryParam.EQ, AreaStatusEnum.启用.getCode()));
            IPage<ConstructAreaDetailEntity> page = detailService.queryPage(queryParam);
            pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(page.getRecords());
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @PostMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "constructArea-import.xlsx", "施工区域设置导入模板");
    }

    /**
     * 导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<ConstructAreaImportVO> errorsList = new ArrayList<>();
            List<ConstructAreaImportVO> successList = new ArrayList<>();
            List<List<String>> result = ExcelReader.readExcel(mf);


            logger.info("result:");
            if (result != null && result.size() > 0) {
                Map<String, Integer> indexMap = new HashMap<>();
                List<ConstructAreaDetailVO> detailVoList = new ArrayList<>();
                Map<String, ConstructAreaImportVO> importDataMap = new HashMap<>();
                Map<String, Long> tidMap = new HashMap<>();

                ConstructAreaImportVO tmp = null;
                ConstructAreaImportVO parent = null;
                for (int i = 0; i < result.size(); i++) {

                    boolean parentWarn = false;
                    List<String> datas = result.get(i);
                    ConstructAreaDetailVO vo = new ConstructAreaDetailVO();
                    tmp = new ConstructAreaImportVO();
                    //序号
                    tmp.setTreeIndex(datas.get(0));
                    //施工区域
                    tmp.setConstructionRegion(datas.get(1));
                    //维护父子关系
                    tmp.setDetailId(IdWorker.getId());
                    tmp.setTid(tmp.getDetailId().toString());
                    if (StringUtils.isNotEmpty(datas.get(0))) {//序号不为空
                        String[] split = datas.get(0).split("[-/.]");
                        tmp.setTid(tmp.getDetailId().toString());
                        tidMap.put(datas.get(0), tmp.getDetailId());
                        if (split.length > 1) {
                            parentWarn=true;
                            vo.setTpid(datas.get(0).substring(0, datas.get(0).length() - split[split.length - 1].length() - 1));
                        }else{
                            vo.setParentId(999L);
                        }
                    } else {
                        tmp.setTid(tmp.getDetailId().toString());
                        tmp.setTpid("");
                        tmp.setParentId(999L);
                    }

                    if (indexMap.containsKey(datas.get(0))) {//序号重复
                        return CommonResponse.error("第" + (i + 2) + "行序号和第" + (indexMap.get(datas.get(0)) + 2) + "行重复");
                    } else {
                        indexMap.put(datas.get(0), i);
                    }
                    if(StringUtils.isBlank(tmp.getTreeIndex())) {
                        tmp.setErrorMsg("序号为空");
                        errorsList.add(tmp);
                        continue;
                    }
                    if(StringUtils.isBlank(tmp.getConstructionRegion())) {
                        tmp.setErrorMsg("施工区域为空");
                        errorsList.add(tmp);
                        continue;
                    }
                    if(importDataMap.containsKey(tmp.getTreeIndex())) {
                        //序号重复
                        tmp.setErrorMsg("序号重复");
                        errorsList.add(tmp);
                        continue;
                    }



                    //存在父级
                    if(tmp.getTreeIndex().indexOf(".") >= 0) {
                        parent = importDataMap.get(tmp.getTreeIndex().substring(0, tmp.getTreeIndex().lastIndexOf(".")));
                        //父级不存在
                        if(null == parent) {
                            tmp.setErrorMsg("父级不存在");
                            errorsList.add(tmp);
                            continue;
                        } else {
                            //设置父级Id信息
                            tmp.setTpid(parent.getTid());
                            tmp.setParentId(Long.valueOf(parent.getTid()));
                        }
                    }

                    importDataMap.put(tmp.getTreeIndex(), tmp);
                    successList.add(tmp);
                }
                for (ConstructAreaImportVO tVo : successList) {
                    tVo.setTpid(String.valueOf(tidMap.get(tVo.getTpid())));
                }
                resp.put("errorList", errorsList );
                resp.put("errorNum", errorsList.size());
                resp.put("successList", successList);
                resp.put("successNum", successList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }
}
