/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.construct.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaDetailEntity;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaEntity;
import com.ejianc.business.probuilddiary.construct.enums.AreaStatusEnum;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaDetailService;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaService;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaDetailVO;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaImportVO;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"constructArea"})
public class ConstructAreaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IConstructAreaDetailService detailService;
    @Autowired
    private IConstructAreaService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConstructAreaVO> saveOrUpdate(@RequestBody ConstructAreaVO saveOrUpdateVO) {
        return this.service.insertOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConstructAreaVO> queryDetail(Long id, String operate) {
        ConstructAreaVO entity = this.service.queryDetail(id, operate);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)entity);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConstructAreaVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("staffingDate");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConstructAreaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<ConstructAreaVO>> iPageCommonResponse = this.queryList(param);
        List records = new ArrayList();
        if (null != iPageCommonResponse.getData()) {
            records = ((IPage)iPageCommonResponse.getData()).getRecords();
            records.forEach(c -> c.setBillStateStr(BillStateEnum.getEnumByStateCode((Integer)c.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", records);
        ExcelExport.getInstance().export("ConstructArea-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refConstructAreaData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaVO>> refConstructAreaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConstructAreaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAreaDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConstructAreaDetailEntity>> queryAreaDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.parseLong(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
        }
        Page pageData = new Page(1L, 10L, 0L);
        List constructAreaEntities = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)constructAreaEntities)) {
            ConstructAreaEntity entity = (ConstructAreaEntity)((Object)constructAreaEntities.get(0));
            QueryParam queryParam = new QueryParam();
            queryParam.getFuzzyFields().add("dutyName");
            queryParam.getFuzzyFields().add("constructionRegion");
            queryParam.setPageSize(pageSize.intValue());
            queryParam.setPageIndex(pageNumber.intValue());
            queryParam.setSearchText(searchText);
            queryParam.setSearchObject(searchObject);
            queryParam.getParams().put("area_id", new Parameter("eq", (Object)entity.getId()));
            queryParam.getParams().put("detail_status", new Parameter("eq", (Object)AreaStatusEnum.\u542f\u7528.getCode()));
            IPage page = this.detailService.queryPage(queryParam);
            pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(page.getRecords());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"constructArea-import.xlsx", (String)"\u65bd\u5de5\u533a\u57df\u8bbe\u7f6e\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        ArrayList<ConstructAreaImportVO> errorsList = new ArrayList<ConstructAreaImportVO>();
        ArrayList<ConstructAreaImportVO> successList = new ArrayList<ConstructAreaImportVO>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        this.logger.info("result:");
        if (result != null && result.size() > 0) {
            HashMap indexMap = new HashMap();
            ArrayList detailVoList = new ArrayList();
            HashMap<String, ConstructAreaImportVO> importDataMap = new HashMap<String, ConstructAreaImportVO>();
            HashMap tidMap = new HashMap();
            ConstructAreaImportVO tmp = null;
            ConstructAreaImportVO parent = null;
            for (int i = 0; i < result.size(); ++i) {
                boolean parentWarn = false;
                List datas = (List)result.get(i);
                ConstructAreaDetailVO vo = new ConstructAreaDetailVO();
                tmp = new ConstructAreaImportVO();
                tmp.setTreeIndex((String)datas.get(0));
                tmp.setConstructionRegion((String)datas.get(1));
                tmp.setDetailId(Long.valueOf(IdWorker.getId()));
                tmp.setTid(tmp.getDetailId().toString());
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    String[] split = ((String)datas.get(0)).split("[-/.]");
                    tmp.setTid(tmp.getDetailId().toString());
                    tidMap.put(datas.get(0), tmp.getDetailId());
                    if (split.length > 1) {
                        parentWarn = true;
                        vo.setTpid(((String)datas.get(0)).substring(0, ((String)datas.get(0)).length() - split[split.length - 1].length() - 1));
                    } else {
                        vo.setParentId(Long.valueOf(999L));
                    }
                } else {
                    tmp.setTid(tmp.getDetailId().toString());
                    tmp.setTpid("");
                    tmp.setParentId(Long.valueOf(999L));
                }
                if (indexMap.containsKey(datas.get(0))) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(datas.get(0)) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(datas.get(0), i);
                if (StringUtils.isBlank((CharSequence)tmp.getTreeIndex())) {
                    tmp.setErrorMsg("\u5e8f\u53f7\u4e3a\u7a7a");
                    errorsList.add(tmp);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)tmp.getConstructionRegion())) {
                    tmp.setErrorMsg("\u65bd\u5de5\u533a\u57df\u4e3a\u7a7a");
                    errorsList.add(tmp);
                    continue;
                }
                if (importDataMap.containsKey(tmp.getTreeIndex())) {
                    tmp.setErrorMsg("\u5e8f\u53f7\u91cd\u590d");
                    errorsList.add(tmp);
                    continue;
                }
                if (tmp.getTreeIndex().indexOf(".") >= 0) {
                    parent = (ConstructAreaImportVO)importDataMap.get(tmp.getTreeIndex().substring(0, tmp.getTreeIndex().lastIndexOf(".")));
                    if (null == parent) {
                        tmp.setErrorMsg("\u7236\u7ea7\u4e0d\u5b58\u5728");
                        errorsList.add(tmp);
                        continue;
                    }
                    tmp.setTpid(parent.getTid());
                    tmp.setParentId(Long.valueOf(parent.getTid()));
                }
                importDataMap.put(tmp.getTreeIndex(), tmp);
                successList.add(tmp);
            }
            List detailVOList = BeanMapper.mapList(successList, ConstructAreaDetailVO.class);
            resp.put("errorList", errorsList);
            resp.put("errorNum", (Object)errorsList.size());
            resp.put("successList", (Object)detailVOList);
            resp.put("successNum", (Object)detailVOList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }
}

