package com.ejianc.business.probuilddiary.person.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaDetailEntity;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaDetailVO;
import com.ejianc.business.probuilddiary.person.bean.TemplateEntity;
import com.ejianc.business.probuilddiary.person.enums.DiaryEnum;
import com.ejianc.business.probuilddiary.person.service.ITemplateService;
import com.ejianc.business.probuilddiary.person.vo.TemplateVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.probuilddiary.person.bean.PersonEntity;
import com.ejianc.business.probuilddiary.person.service.IPersonService;
import com.ejianc.business.probuilddiary.person.vo.PersonVO;

/**
 * 个人施工日志
 *
 * @author generator
 */
@Controller
@RequestMapping("person")
public class PersonController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PERSON_LOG";//此处需要根据实际修改

    @Autowired
    private IPersonService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemplateService templateService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PersonVO> saveOrUpdate(@RequestBody PersonVO saveOrUpdateVO) {
        return service.newSaveOrUpdate(saveOrUpdateVO);
    }


    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PersonVO> queryDetail(Long id) {
        PersonEntity entity = service.selectById(id);
        PersonVO vo = BeanMapper.map(entity, PersonVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PersonVO> vos) {
        service.removeByIds(vos.stream().map(PersonVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PersonVO>> queryList(@RequestBody QueryParam param) {
        return service.newQuery(param);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PersonEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Person-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPersonData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PersonVO>> refPersonData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PersonEntity> page = service.queryPage(param, false);
        IPage<PersonVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PersonVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @Description 查询模板
     * @Return void
     */
    @RequestMapping(value = "/queryTemplate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TemplateVO>> queryTemplate(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                    String condition,
                                                    String searchObject,
                                                    String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("sorted", QueryParam.ASC);
        queryParam.setOrderMap(orderMap);
        IPage<TemplateEntity> page = templateService.queryPage(queryParam);
        IPage<TemplateVO> pageData  =new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(),TemplateVO.class));
        return CommonResponse.success("查询数据成功！", pageData);
    }

    /**
     * @Description 查询模板
     * @Return void
     */
    @RequestMapping(value = "/queryUserTemplate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<TemplateVO>> queryUserTemplate(Long userId) {
        QueryWrapper<PersonEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("informant_id",userId);
        queryWrapper.orderByDesc("create_time");
        queryWrapper.last("limit 1");
        PersonEntity one = service.getOne(queryWrapper);
        List codes = new ArrayList<>();
        if (one!=null){
            PersonEntity personEntity = service.selectById(one.getId());


            if (CollectionUtils.isNotEmpty(personEntity.getDetailList())){
                codes.add(DiaryEnum.施工内容.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getEquipmentList())){
                codes.add(DiaryEnum.设备进场情况.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getExamineList())){
                codes.add(DiaryEnum.原材料检验时间试块及见证取样送检等情况.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getInformationList())){
                codes.add(DiaryEnum.工程资料归档及会议情况.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getMaterialList())){
                codes.add(DiaryEnum.材料进场情况.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getOtherList())){
                codes.add(DiaryEnum.进度情况.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getQualityList())){
                codes.add(DiaryEnum.工程质量检查验收情况.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getSafetyList())){
                codes.add(DiaryEnum.安全活动情况.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getTypeList())){
                codes.add(DiaryEnum.施工组织设计方案交底变更情况.getCode());
            }
            if (CollectionUtils.isNotEmpty(personEntity.getScheduleList())){
                codes.add(DiaryEnum.进度情况.getCode());
            }
        }
        List<TemplateVO> voList = new ArrayList<>();
        if (!codes.isEmpty()){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("bill_code",new Parameter(QueryParam.IN,codes));
            LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
            orderMap.put("sorted", QueryParam.ASC);
            queryParam.setOrderMap(orderMap);
            List<TemplateEntity> templateEntities = templateService.queryList(queryParam);
            voList= BeanMapper.mapList(templateEntities, TemplateVO.class);

        }

        return CommonResponse.success("查询数据成功！", voList);
    }
}
