package com.ejianc.business.probuilddiary.ledger.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 日志台账
 *
 * @author baipengyan
 */
@TableName("ejc_probuilddiary_ledger")
public class LedgerEntity extends BaseEntity {
	private static final long serialVersionUID = -3818478255335352184L;

	@TableField(value = "effective_date")
	private Date effectiveDate; // 生效日期
	@TableField(value = "bill_code")
	private String billCode; // 单据编号
	@TableField(value = "bill_name")
	private String billName; // 单据名称
	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "org_id")
	private Long orgId; // 项目部id
	@TableField(value = "org_code")
	private String orgCode; // 项目部编码
	@TableField(value = "org_name")
	private String orgName; // 项目部名称
	@TableField(value = "parent_org_id")
	private Long parentOrgId; // 项目部所属组织id
	@TableField(value = "parent_org_code")
	private String parentOrgCode; // 项目部所属组织编码
	@TableField(value = "parent_org_name")
	private String parentOrgName; // 项目部所属组织名称
	@TableField(value = "project_id")
	private Long projectId; // 项目id
	@TableField(value = "project_code")
	private String projectCode; // 项目编码
	@TableField(value = "project_name")
	private String projectName; // 项目名称
	@TableField(value = "source_type")
	private String sourceType; // 来源
	@TableField(value = "fill_date")
	private Date fillDate; // 填报日期
	@TableField(value = "week")
	private String week; // 星期
	@TableField(value = "weather")
	private String weather; // 天气
	@TableField(value = "wind_power")
	private String windPower; // 风力
	@TableField(value = "temperature")
	private String temperature; // 温度
	@TableField(value = "humidity")
	private String humidity; // 湿度
	@TableField(value = "air_quality")
	private Long airQuality; // 空气质量
	@TableField(value = "commit_user_id")
	private Long commitUserId; // 提交人id
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期
	@TableField(value = "project_log_id")
	private Long projectLogId; // 项目日志id


	@TableField(exist = false)
	@SubEntity(serviceName = "ledgerDetailService", pidName = "ledgerId")//此处有pid="xxx"，默认值pid="pid"
	private List<LedgerDetailEntity> ledgerDetailList = new ArrayList<>(); // 日志台账-施工内容（施工员）
	@TableField(exist = false)
	@SubEntity(serviceName = "ledgerScheduleService", pidName = "ledgerId")//此处有pid="xxx"，默认值pid="pid"
	private List<LedgerScheduleEntity> ledgerScheduleList = new ArrayList<>(); // 日志台账-进度情况（施工员）
	@TableField(exist = false)
	@SubEntity(serviceName = "ledgerTypeService", pidName = "ledgerId")//此处有pid="xxx"，默认值pid="pid"
	private List<LedgerTypeEntity> ledgerTypeList = new ArrayList<>(); // 日志台账-施工组织设计、方案、交底、变更情况（技术负责人）
	@TableField(exist = false)
	@SubEntity(serviceName = "ledgerQualityService", pidName = "ledgerId")//此处有pid="xxx"，默认值pid="pid"
	private List<LedgerQualityEntity> ledgerQualityList = new ArrayList<>(); // 日志台账-工程质量检查、验收情况（质检员）
	@TableField(exist = false)
	@SubEntity(serviceName = "ledgerSafetyService", pidName = "ledgerId")//此处有pid="xxx"，默认值pid="pid"
	private List<LedgerSafetyEntity> ledgerSafetyList = new ArrayList<>(); // 日志台账-安全活动情况（安全员）
	@TableField(exist = false)
	@SubEntity(serviceName = "ledgerMaterialService", pidName = "ledgerId")//此处有pid="xxx"，默认值pid="pid"
	private List<LedgerMaterialEntity> ledgerMaterialList = new ArrayList<>(); // 日志台账-材料进场情况（材料员）
	@TableField(exist = false)
	@SubEntity(serviceName = "ledgerEquipmentService", pidName = "ledgerId")//此处有pid="xxx"，默认值pid="pid"
	private List<LedgerEquipmentEntity> ledgerEquipmentList = new ArrayList<>(); // 日志台账-设备进场情况（设备管理员）
	@TableField(exist = false)
	@SubEntity(serviceName = "ledgerExamineService", pidName = "ledgerId")//此处有pid="xxx"，默认值pid="pid"
	private List<LedgerExamineEntity> ledgerExamineList = new ArrayList<>(); // 日志台账-原材料检验、时间、试块及见证取样送检等情况（取样员）
	@TableField(exist = false)
	@SubEntity(serviceName = "ledgerInformationService", pidName = "ledgerId")//此处有pid="xxx"，默认值pid="pid"
	private List<LedgerInformationEntity> ledgerInformationList = new ArrayList<>(); // 日志台账-工程资料归档及会议情况（资料员）
	@TableField(exist = false)
	@SubEntity(serviceName = "ledgerOtherService", pidName = "ledgerId")//此处有pid="xxx"，默认值pid="pid"
	private List<LedgerOtherEntity> ledgerOtherList = new ArrayList<>(); // 日志台账-其他情况


	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getParentOrgId() {
		return parentOrgId;
	}

	public void setParentOrgId(Long parentOrgId) {
		this.parentOrgId = parentOrgId;
	}

	public String getParentOrgCode() {
		return parentOrgCode;
	}

	public void setParentOrgCode(String parentOrgCode) {
		this.parentOrgCode = parentOrgCode;
	}

	public String getParentOrgName() {
		return parentOrgName;
	}

	public void setParentOrgName(String parentOrgName) {
		this.parentOrgName = parentOrgName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getSourceType() {
		return sourceType;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public Date getFillDate() {
		return fillDate;
	}

	public void setFillDate(Date fillDate) {
		this.fillDate = fillDate;
	}

	public String getWeek() {
		return week;
	}

	public void setWeek(String week) {
		this.week = week;
	}

	public String getWeather() {
		return weather;
	}

	public void setWeather(String weather) {
		this.weather = weather;
	}

	public String getWindPower() {
		return windPower;
	}

	public void setWindPower(String windPower) {
		this.windPower = windPower;
	}

	public String getTemperature() {
		return temperature;
	}

	public void setTemperature(String temperature) {
		this.temperature = temperature;
	}

	public String getHumidity() {
		return humidity;
	}

	public void setHumidity(String humidity) {
		this.humidity = humidity;
	}

	public Long getCommitUserId() {
		return commitUserId;
	}

	public void setCommitUserId(Long commitUserId) {
		this.commitUserId = commitUserId;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public Long getProjectLogId() {
		return projectLogId;
	}

	public void setProjectLogId(Long projectLogId) {
		this.projectLogId = projectLogId;
	}

	public List<LedgerDetailEntity> getLedgerDetailList() {
		return ledgerDetailList;
	}

	public void setLedgerDetailList(List<LedgerDetailEntity> ledgerDetailList) {
		this.ledgerDetailList = ledgerDetailList;
	}

	public List<LedgerScheduleEntity> getLedgerScheduleList() {
		return ledgerScheduleList;
	}

	public void setLedgerScheduleList(List<LedgerScheduleEntity> ledgerScheduleList) {
		this.ledgerScheduleList = ledgerScheduleList;
	}

	public List<LedgerTypeEntity> getLedgerTypeList() {
		return ledgerTypeList;
	}

	public void setLedgerTypeList(List<LedgerTypeEntity> ledgerTypeList) {
		this.ledgerTypeList = ledgerTypeList;
	}

	public List<LedgerQualityEntity> getLedgerQualityList() {
		return ledgerQualityList;
	}

	public void setLedgerQualityList(List<LedgerQualityEntity> ledgerQualityList) {
		this.ledgerQualityList = ledgerQualityList;
	}

	public List<LedgerSafetyEntity> getLedgerSafetyList() {
		return ledgerSafetyList;
	}

	public void setLedgerSafetyList(List<LedgerSafetyEntity> ledgerSafetyList) {
		this.ledgerSafetyList = ledgerSafetyList;
	}

	public List<LedgerMaterialEntity> getLedgerMaterialList() {
		return ledgerMaterialList;
	}

	public void setLedgerMaterialList(List<LedgerMaterialEntity> ledgerMaterialList) {
		this.ledgerMaterialList = ledgerMaterialList;
	}

	public List<LedgerEquipmentEntity> getLedgerEquipmentList() {
		return ledgerEquipmentList;
	}

	public void setLedgerEquipmentList(List<LedgerEquipmentEntity> ledgerEquipmentList) {
		this.ledgerEquipmentList = ledgerEquipmentList;
	}

	public List<LedgerExamineEntity> getLedgerExamineList() {
		return ledgerExamineList;
	}

	public void setLedgerExamineList(List<LedgerExamineEntity> ledgerExamineList) {
		this.ledgerExamineList = ledgerExamineList;
	}

	public List<LedgerInformationEntity> getLedgerInformationList() {
		return ledgerInformationList;
	}

	public void setLedgerInformationList(List<LedgerInformationEntity> ledgerInformationList) {
		this.ledgerInformationList = ledgerInformationList;
	}

	public List<LedgerOtherEntity> getLedgerOtherList() {
		return ledgerOtherList;
	}

	public void setLedgerOtherList(List<LedgerOtherEntity> ledgerOtherList) {
		this.ledgerOtherList = ledgerOtherList;
	}

	public Long getAirQuality() {
		return airQuality;
	}

	public void setAirQuality(Long airQuality) {
		this.airQuality = airQuality;
	}
}
