package com.ejianc.business.probuilddiary.project.dtomapper;

import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

/**
 * 映射接口：项目日志
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
// @Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
@Mapper
public interface ProjectLogMapper {
	ProjectLogMapper INSTANCE = Mappers.getMapper(ProjectLogMapper.class);

	@Mappings(value = {
			@Mapping(target = "id", ignore = true),
			@Mapping(target = "createUserCode", ignore = true),
			@Mapping(target = "createTime", ignore = true),
			@Mapping(target = "updateUserCode", ignore = true),
			@Mapping(target = "updateTime", ignore = true),
			@Mapping(target = "dr", ignore = true),
			@Mapping(target = "tenantId", ignore = true),
			@Mapping(target = "syncEsFlag", ignore = true),
			@Mapping(target = "version", ignore = true),
			// @Mapping(source = "projectLogDetailList", target = "ledgerDetailList"),
			// @Mapping(source = "projectLogScheduleList", target = "ledgerScheduleList"),
			// @Mapping(source = "projectLogTypeList", target = "ledgerTypeList"),
			// @Mapping(source = "projectLogQualityList", target = "ledgerQualityList"),
			// @Mapping(source = "projectLogSafetyList", target = "ledgerSafetyList"),
			// @Mapping(source = "projectLogMaterialList", target = "ledgerMaterialList"),
			// @Mapping(source = "projectLogEquipmentList", target = "ledgerEquipmentList"),
			// @Mapping(source = "projectLogExamineList", target = "ledgerExamineList"),
			// @Mapping(source = "projectLogInformationList", target = "ledgerInformationList"),
			// @Mapping(source = "projectLogOtherList", target = "ledgerOtherList"),

			@Mapping(target = "ledgerDetailList", ignore = true),
			@Mapping(target = "ledgerScheduleList", ignore = true),
			@Mapping(target = "ledgerTypeList", ignore = true),
			@Mapping(target = "ledgerQualityList", ignore = true),
			@Mapping(target = "ledgerSafetyList", ignore = true),
			@Mapping(target = "ledgerMaterialList", ignore = true),
			@Mapping(target = "ledgerEquipmentList", ignore = true),
			@Mapping(target = "ledgerExamineList", ignore = true),
			@Mapping(target = "ledgerInformationList", ignore = true),
			@Mapping(target = "ledgerOtherList", ignore = true),
			@Mapping(source = "id", target = "projectLogId")
	})
	LedgerEntity transToLedgerEntity(ProjectLogEntity projectLogEntity);

}
