/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.project.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerService;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogDetailEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEquipmentEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogExamineEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogInformationEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogMaterialEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogOtherEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogQualityEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogSafetyEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogScheduleEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogTypeEntity;
import com.ejianc.business.probuilddiary.project.service.IProjectLogDetailService;
import com.ejianc.business.probuilddiary.project.service.IProjectLogEquipmentService;
import com.ejianc.business.probuilddiary.project.service.IProjectLogExamineService;
import com.ejianc.business.probuilddiary.project.service.IProjectLogInformationService;
import com.ejianc.business.probuilddiary.project.service.IProjectLogMaterialService;
import com.ejianc.business.probuilddiary.project.service.IProjectLogOtherService;
import com.ejianc.business.probuilddiary.project.service.IProjectLogQualityService;
import com.ejianc.business.probuilddiary.project.service.IProjectLogSafetyService;
import com.ejianc.business.probuilddiary.project.service.IProjectLogScheduleService;
import com.ejianc.business.probuilddiary.project.service.IProjectLogService;
import com.ejianc.business.probuilddiary.project.service.IProjectLogTypeService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectLog")
public class ProjectLogBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IProjectLogService service;
    private final ILedgerService ledgerService;
    @Autowired
    private IProjectLogDetailService detailService;
    @Autowired
    private IProjectLogScheduleService scheduleService;
    @Autowired
    private IProjectLogTypeService typeService;
    @Autowired
    private IProjectLogQualityService qualityService;
    @Autowired
    private IProjectLogSafetyService safetyService;
    @Autowired
    private IProjectLogMaterialService materialService;
    @Autowired
    private IProjectLogEquipmentService equipmentService;
    @Autowired
    private IProjectLogExamineService examineService;
    @Autowired
    private IProjectLogInformationService informationService;
    @Autowired
    private IProjectLogOtherService otherService;

    public ProjectLogBpmServiceImpl(SessionManager sessionManager, IBillTypeApi billTypeApi, IProjectLogService service, ILedgerService ledgerService) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.service = service;
        this.ledgerService = ledgerService;
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        ProjectLogEntity entity = (ProjectLogEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        List detailEntities = this.detailService.list((Wrapper)Wrappers.lambdaQuery().eq(ProjectLogDetailEntity::getProjectLogId, (Object)billId));
        if (ListUtil.isEmpty((List)detailEntities)) {
            throw new BusinessException("\u65bd\u5de5\u5185\u5bb9\uff08\u65bd\u5de5\u5458\uff09\u4fe1\u606f\u672a\u586b\u5199\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        List scheduleEntities = this.scheduleService.list((Wrapper)Wrappers.lambdaQuery().eq(ProjectLogScheduleEntity::getProjectLogId, (Object)billId));
        if (ListUtil.isEmpty((List)scheduleEntities)) {
            throw new BusinessException("\u8fdb\u5ea6\u60c5\u51b5\uff08\u65bd\u5de5\u5458\uff09\u4fe1\u606f\u672a\u586b\u5199\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        List typeEntities = this.typeService.list((Wrapper)Wrappers.lambdaQuery().eq(ProjectLogTypeEntity::getProjectLogId, (Object)billId));
        if (ListUtil.isEmpty((List)typeEntities)) {
            throw new BusinessException("\u65bd\u5de5\u7ec4\u7ec7\u8bbe\u8ba1\u3001\u65b9\u6848\u3001\u4ea4\u5e95\u3001\u53d8\u66f4\u60c5\u51b5\uff08\u6280\u672f\u8d1f\u8d23\u4eba\uff09\u4fe1\u606f\u672a\u586b\u5199\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        List qualityEntities = this.qualityService.list((Wrapper)Wrappers.lambdaQuery().eq(ProjectLogQualityEntity::getProjectLogId, (Object)billId));
        if (ListUtil.isEmpty((List)qualityEntities)) {
            throw new BusinessException("\u5de5\u7a0b\u8d28\u91cf\u68c0\u67e5\u3001\u9a8c\u6536\u60c5\u51b5\uff08\u8d28\u68c0\u5458\uff09\u4fe1\u606f\u672a\u586b\u5199\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        List safetyEntities = this.safetyService.list((Wrapper)Wrappers.lambdaQuery().eq(ProjectLogSafetyEntity::getProjectLogId, (Object)billId));
        if (ListUtil.isEmpty((List)safetyEntities)) {
            throw new BusinessException("\u5b89\u5168\u6d3b\u52a8\u60c5\u51b5\uff08\u5b89\u5168\u5458\uff09\u4fe1\u606f\u672a\u586b\u5199\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        List materialEntities = this.materialService.list((Wrapper)Wrappers.lambdaQuery().eq(ProjectLogMaterialEntity::getProjectLogId, (Object)billId));
        if (ListUtil.isEmpty((List)materialEntities)) {
            throw new BusinessException("\u9879\u76ee\u65e5\u5fd7-\u6750\u6599\u8fdb\u573a\u60c5\u51b5\uff08\u6750\u6599\u5458\uff09\u4fe1\u606f\u672a\u586b\u5199\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        List equipmentEntities = this.equipmentService.list((Wrapper)Wrappers.lambdaQuery().eq(ProjectLogEquipmentEntity::getProjectLogId, (Object)billId));
        if (ListUtil.isEmpty((List)equipmentEntities)) {
            throw new BusinessException("\u8bbe\u5907\u8fdb\u573a\u60c5\u51b5\uff08\u8bbe\u5907\u7ba1\u7406\u5458\uff09\u4fe1\u606f\u672a\u586b\u5199\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        List examineEntities = this.examineService.list((Wrapper)Wrappers.lambdaQuery().eq(ProjectLogExamineEntity::getProjectLogId, (Object)billId));
        if (ListUtil.isEmpty((List)examineEntities)) {
            throw new BusinessException("\u539f\u6750\u6599\u68c0\u9a8c\u3001\u65f6\u95f4\u3001\u8bd5\u5757\u53ca\u89c1\u8bc1\u53d6\u6837\u9001\u68c0\u7b49\u60c5\u51b5\uff08\u53d6\u6837\u5458\uff09\u4fe1\u606f\u672a\u586b\u5199\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        List informationEntities = this.informationService.list((Wrapper)Wrappers.lambdaQuery().eq(ProjectLogInformationEntity::getProjectLogId, (Object)billId));
        if (ListUtil.isEmpty((List)informationEntities)) {
            throw new BusinessException("\u5de5\u7a0b\u8d44\u6599\u5f52\u6863\u53ca\u4f1a\u8bae\u60c5\u51b5\uff08\u8d44\u6599\u5458\uff09\u4fe1\u606f\u672a\u586b\u5199\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        List otherEntities = this.otherService.list((Wrapper)Wrappers.lambdaQuery().eq(ProjectLogOtherEntity::getProjectLogId, (Object)billId));
        if (ListUtil.isEmpty((List)otherEntities)) {
            throw new BusinessException("\u5176\u4ed6\u60c5\u51b5\u4fe1\u606f\u672a\u586b\u5199\uff0c\u65e0\u6cd5\u63d0\u4ea4\uff01");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserId(userContext.getUserId());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        this.service.saveOrUpdate((Object)entity, false);
        this.logger.info("\u63d0\u4ea4\u5b8c\u56de\u8c03--end");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        ProjectLogEntity entity = (ProjectLogEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            UserContext userContext = this.sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserId(userContext.getUserId());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        this.syncLedger(entity);
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    private void syncLedger(ProjectLogEntity entity) {
        LedgerEntity ledgerEntity = this.ledgerService.projectLogConvertToLedger(entity);
        this.ledgerService.saveOrUpdate((Object)ledgerEntity, false);
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ProjectLogEntity entity = (ProjectLogEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        if (entity.getEffectiveDate() != null) {
            LocalDateTime effectiveDate = entity.getEffectiveDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            LocalDateTime afterSevenDays = effectiveDate.plusDays(7L);
            LocalDateTime now = LocalDateTime.now();
            if (now.isAfter(afterSevenDays)) {
                throw new BusinessException("\u8d85\u51fa\u5ba1\u6279\u901a\u8fc7\u540e\u76847\u5929\u540e\uff0c\u4e0d\u652f\u6301\u64a4\u56de\u6216\u5f03\u5ba1\uff01");
            }
            this.ledgerService.deleteAllDataByProjectLogId(entity.getId());
            return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de/\u5f03\u5ba1\u6210\u529f");
        }
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de/\u5f03\u5ba1\u6210\u529f");
    }
}

