package com.ejianc.business.probuilddiary.waring;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerService;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.warn.vo.CustomWarnSettingVO;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/ledgerWarn/")
public class LogWarnController {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ILedgerService ledgerService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Value(value = "${ledgerWarning.code}")
    private String WARN_CODE;

    @PostMapping(value = "testWarnExecute")
    public CommonResponse<String> budgetWarnExecute(@RequestBody JSONArray jsonParam) {
        logger.info("接收到Task参数：{}", jsonParam);
        List<EarlyWarnTransVO> warnList = new ArrayList<>();
        String warnCode = null;

        for (int i = 0; i < jsonParam.size(); i++) {//循环每个租户数据
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");

            /**
             *  1、根据项目维度,查询施工日志台账中的数据
             *  2、根据施工日志台账单据所属组织，找到对应的预警设置，也就是这条施工日志适用于那个设置
             *  3、根据预警设置判断该施工日志数据属于哪个等级
             *  4、符合等级，则拼接预警数据，并保存到list
             *  5、发送数据
             */
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, tenantId));

            //查询所有在施项目
            //1502571152583692289L 郑州一建集团层级
            CommonResponse<List<ProjectVO>> listCommonResponse = projectPoolApi.queryProjectsByOrgId(1502571152583692289L);

            List<Long> ids = new ArrayList<>();
            Map<Long, ProjectVO> projectMap = new HashMap<>();
            if(listCommonResponse.isSuccess()){
                List<ProjectVO> projectVOS = listCommonResponse.getData();
                projectMap = projectVOS.stream().collect(Collectors.toMap(ProjectVO::getId, Function.identity()));
                ids = projectVOS.stream().map(ProjectVO::getId).collect(Collectors.toList());
            }

            if (ListUtil.isNotEmpty(ids)) {
                for (Long id : ids) {
                    JSONObject orgSet = null;
                    JSONObject defaultSet = null;
//                    Long orgId = contractEntity.getOrgId();
//                    OrgVO orgVO = iOrgApi.getOneById(orgId).getData();
//                    if(orgVO==null){
//                        continue;
//                    }
//                    String innerCode = orgVO.getInnerCode();
//                    String[] parentIds = innerCode.split("\\|");
                    /**
                     * 如果当前组织没查到配置，则找其直接上级的配置，
                     * 再找不到，再找其上级，以此类推，
                     * 直至上级为空，还没找到则用默认配置，
                     * 默认配置为空，则不预警
                     * 使用当前组织的innerCode进行父级查找
                     * */
//                    logger.info("parentIds______"+innerCode);
//                    for (int i1 = parentIds.length - 1; i1 >= 0; i1--) {
//                        /** 反向查找 */
//                        Long pOrgId = Long.parseLong(parentIds[i1]);
//                        for (int j = 0 ; j < orgSettings.size(); j++) {
//                            JSONObject set = orgSettings.getJSONObject(j);
//                            if (pOrgId.equals(set.getLong("orgId"))) {
//                                orgSet = set;
//                                break;
//                            }
//                        }
//                        if(orgSet!=null){
//                            break;
//                        }
//                    }
                    /** 查找默认的 */
                    for (int i1 = 0 ; i1 < orgSettings.size(); i1++) {
                        JSONObject set = orgSettings.getJSONObject(i1);
                        if (set.getBoolean("default")) {
                            defaultSet = set;
                            break;
                        }
                    }

                    if (orgSet == null) {
                        /** 使用默认配置 */
                        orgSet = defaultSet;
                    }
                    if (orgSet != null && ListUtil.isNotEmpty(orgSet.getJSONArray("warningSetings"))) {

                        /** 间隔天数 */
                        JSONArray warningSettings = orgSet.getJSONArray("warningSetings");

                        boolean high = false;
                        boolean meddle = false;
                        boolean low = false;
                        JSONObject useSetHigh = null;
                        JSONObject useSetMeddle = null;
                        JSONObject useSetLow = null;
                        /*BigDecimal overAmtHigh = null;
                        BigDecimal overAmtMeddle = null;
                        BigDecimal overAmtLow = null;*/


                        for (int i1 = 0; i1 < warningSettings.size(); i1++) {
                            JSONObject set = warningSettings.getJSONObject(i1);
                            LocalDate date = LocalDate.now();


                            if ("高".equals(set.getString("warningLevel"))) {
                                int day = Integer.parseInt(set.getString("parameterValue"));
                                String startDate = date.minusDays(day).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                                String endDate = date.minusDays(1).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                                List<LedgerEntity> list = ledgerService.list(Wrappers.<LedgerEntity>lambdaQuery()
                                        .eq(LedgerEntity::getProjectId, id)
                                        .between(LedgerEntity::getFillDate, startDate, endDate)
                                );
                                logger.info("预警等级高时间条件为{}{}",startDate,endDate);
                                logger.info("查询数据为{}",list);
                                if (ListUtil.isEmpty(list)) {
                                    //overAmtHigh = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    high = true;
                                    useSetHigh = set;
                                }
                            }
                            if ("中".equals(set.getString("warningLevel"))) {
                                Long day = set.getLong("parameterValue");
                                String startDate = date.minusDays(day).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                                String endDate = date.minusDays(1).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                                List<LedgerEntity> list = ledgerService.list(Wrappers.<LedgerEntity>lambdaQuery()
                                        .eq(LedgerEntity::getProjectId, id)
                                        .between(LedgerEntity::getFillDate, startDate, endDate)
                                );
                                if (ListUtil.isEmpty(list)) {
                                    //overAmtHigh = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
                                    meddle = true;
                                    useSetMeddle = set;
                                }
                            }
//                            if ("低".equals(set.getString("warningLevel"))) {
//                                BigDecimal parameterValue = set.getBigDecimal("parameterValue");
//                                if (day > new Integer(parameterValue.toString())) {
//                                    //overAmtLow = set.getBigDecimal("parameterValue").divide(new BigDecimal("100")).multiply(contractMoney);
//                                    low = true;
//                                    useSetLow = set;
//                                }
//                            }
                        }
                        //DecimalFormat df = new DecimalFormat("###,##0.00");
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        if (high || meddle || low) {
                            EarlyWarnTransVO vo = new EarlyWarnTransVO();
                            ProjectVO projectVO = projectMap.get(id);
                            vo.setBillName(orgSet.getString("moduleName")+"-"+projectVO.getProjectName());
                            vo.setPcTitle("项目日志预警");
                            vo.setOrgId(projectVO.getOrgId());
                            vo.setSendOrgId(String.valueOf(projectVO.getOrgId()));
                            vo.setOrgName(projectVO.getOrgName());
                            vo.setSourceId(projectVO.getId().toString());
                            vo.setTenantId(tenantId);
                            vo.setWarnSetId(orgSet.getLong("warnId"));
                            vo.setEarlywarnName(orgSet.getString("warnName"));
                            vo.setWarnType(orgSet.getString("warnType"));
                            String tmpContent = orgSet.getString("warningContentTemplate");
                            if (high) {
                                vo.setWarnLevel("高");
                                vo.setWarnSetParamId(useSetHigh.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", projectVO.getProjectName())
                                                .replaceAll("#day#","3")
                                );
                            } else if (meddle) {
                                vo.setWarnLevel("中");
                                vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", projectVO.getProjectName())
                                                .replaceAll("#day#","1")
                                );
                            } else {
                                vo.setWarnLevel("低");
                                vo.setWarnSetParamId(useSetLow.getLong("id"));
                                vo.setEarlywarnContent(
                                        tmpContent.replaceAll("#projectName#", projectVO.getProjectName())
                                                .replaceAll("#day#",null)
                                );
                            }
                            warnList.add(vo);
                        }
                    }
                }
            }
        }

        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if(!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        logger.info("预警中心响应：{}", JSON.toJSONString(warnResp, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        return CommonResponse.success("任务接受处理成功！");
    }
    /**
     * 拼接数据
     *
     * @param warningDTO  预警配置
     * @param warn        预警日期
     * @param formatter   日期格式化模版
     * @param warnTransVO 预警数据
     * @param values      未填报的
     */
    private static void splice(WarningDTO warningDTO, LocalDate warn, DateTimeFormatter formatter, List<EarlyWarnTransVO> warnTransVO, Collection<ProjectVO> values) {
        for (ProjectVO projectVO : values) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setSourceId(String.valueOf(projectVO.getId()));
            vo.setTenantId(projectVO.getTenantId());
            vo.setOrgId(projectVO.getOrgId());
            vo.setOrgName(projectVO.getOrgName());
            vo.setSendOrgId(String.valueOf(projectVO.getOrgId()));
            vo.setEarlywarnName(warningDTO.getName());
            vo.setBillName(projectVO.getProjectName());
            vo.setEarlywarnContent(warningDTO.getWarningContentTemplate().replace("#projectName#", projectVO.getProjectName()).replace("#fillDate#", warn.format(formatter)));
            vo.setWarnSetId(warningDTO.getId());
            vo.setWarnSetParamId(CollectionUtils.isNotEmpty(warningDTO.getWarningSetings()) ? warningDTO.getWarningSetings().get(0).getId() : null);
//            vo.setMoUrl("/ejc-probuilddiary-mobile/#/projectLog/card");
            vo.setPcTitle("日志台账");
            vo.setWarnLevel(warningDTO.getWarningLevel());
            vo.setWarnType(String.valueOf(warningDTO.getWarnType()));
            warnTransVO.add(vo);
        }
    }
}
