/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.waring;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.pro.rmat.utils.PageUtil;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerEntity;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerService;
import com.ejianc.business.warn.vo.CustomWarnSettingVO;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ledgerWarn/"})
public class LogWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private ILedgerService ledgerService;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @PostMapping(value={"testWarnExecute"})
    public CommonResponse<String> budgetWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230Task\u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            CommonResponse queryProjectPoolList = this.projectPoolApi.queryProjectPoolList("1", null, null);
            List<Object> projectPoolSetVOS = new ArrayList();
            if (queryProjectPoolList.isSuccess()) {
                JSONArray poolListData = (JSONArray)queryProjectPoolList.getData();
                this.logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u9879\u76ee---------------------{}", (Object)poolListData);
                projectPoolSetVOS = JSON.parseArray((String)JSON.toJSONString((Object)poolListData), ProjectPoolSetVO.class);
                this.logger.info("\u89e3\u6790\u67e5\u8be2\u51fa\u6765\u7684\u9879\u76ee---------------------{}", projectPoolSetVOS);
                projectPoolSetVOS = projectPoolSetVOS.stream().filter(s -> "2".equals(s.getBusinessStatus()) && s.getSimpleFlag() != null && !"1".equals(s.getSimpleFlag()) && (s.getPlanDateNum() != null && s.getPlanDateNum() > 30 || s.getPlanDateNum() == null) && s.getProjectType() != null && 0 != s.getProjectType().compareTo(1506581524095864833L) && 0 != s.getProjectType().compareTo(1506581563782369282L)).collect(Collectors.toList());
                this.logger.info("\u9884\u8b66\u9879\u76ee------------------------{}", projectPoolSetVOS);
            }
            if (!ListUtil.isNotEmpty(projectPoolSetVOS)) continue;
            for (ProjectPoolSetVO projectPoolSetVO : projectPoolSetVOS) {
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                for (int i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                Object useSetLow = null;
                for (int i1 = 0; i1 < warningSettings.size(); ++i1) {
                    List list;
                    String endDate;
                    String startDate;
                    JSONObject set = warningSettings.getJSONObject(i1);
                    LocalDate date = LocalDate.now();
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        int day = Integer.parseInt(set.getString("parameterValue"));
                        startDate = date.minusDays(day).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                        endDate = date.minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                        list = this.ledgerService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(LedgerEntity::getProjectId, (Object)projectPoolSetVO.getId())).between(LedgerEntity::getFillDate, (Object)startDate, (Object)endDate));
                        this.logger.info("\u9884\u8b66\u7b49\u7ea7\u9ad8\u65f6\u95f4\u6761\u4ef6\u4e3a{}{}", (Object)startDate, (Object)endDate);
                        this.logger.info("\u67e5\u8be2\u6570\u636e\u4e3a{}", (Object)list);
                        if (ListUtil.isEmpty((List)list)) {
                            high = true;
                            useSetHigh = set;
                        }
                    }
                    if (!"\u4e2d".equals(set.getString("warningLevel"))) continue;
                    Long day = set.getLong("parameterValue");
                    startDate = date.minusDays(day).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    endDate = date.minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    list = this.ledgerService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(LedgerEntity::getProjectId, (Object)projectPoolSetVO.getId())).between(LedgerEntity::getFillDate, (Object)startDate, (Object)endDate));
                    if (!ListUtil.isEmpty((List)list)) continue;
                    meddle = true;
                    useSetMeddle = set;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName(orgSet.getString("moduleName") + "-" + projectPoolSetVO.getName());
                vo.setPcTitle("\u9879\u76ee\u65e5\u5fd7\u9884\u8b66");
                vo.setOrgId(projectPoolSetVO.getOrgId());
                vo.setSendOrgId(String.valueOf(projectPoolSetVO.getOrgId()));
                vo.setOrgName(projectPoolSetVO.getOrgName());
                vo.setSourceId(projectPoolSetVO.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", projectPoolSetVO.getName()).replaceAll("#day#", "3"));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", projectPoolSetVO.getName()).replaceAll("#day#", "1"));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", projectPoolSetVO.getName()).replaceAll("#day#", null));
                }
                warnList.add(vo);
            }
        }
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        this.logger.info("\u9884\u8b66\u4e2d\u5fc3\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)warnResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private static void splice(WarningDTO warningDTO, LocalDate warn, DateTimeFormatter formatter, List<EarlyWarnTransVO> warnTransVO, Collection<ProjectVO> values) {
        for (ProjectVO projectVO : values) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setSourceId(String.valueOf(projectVO.getId()));
            vo.setTenantId(projectVO.getTenantId());
            vo.setOrgId(projectVO.getOrgId());
            vo.setOrgName(projectVO.getOrgName());
            vo.setSendOrgId(String.valueOf(projectVO.getOrgId()));
            vo.setEarlywarnName(warningDTO.getName());
            vo.setBillName(projectVO.getProjectName());
            vo.setEarlywarnContent(warningDTO.getWarningContentTemplate().replace("#projectName#", projectVO.getProjectName()).replace("#fillDate#", warn.format(formatter)));
            vo.setWarnSetId(warningDTO.getId());
            vo.setWarnSetParamId(CollectionUtils.isNotEmpty((Collection)warningDTO.getWarningSetings()) ? ((CustomWarnSettingVO)warningDTO.getWarningSetings().get(0)).getId() : null);
            vo.setPcTitle("\u65e5\u5fd7\u53f0\u8d26");
            vo.setWarnLevel(warningDTO.getWarningLevel());
            vo.setWarnType(String.valueOf(warningDTO.getWarnType()));
            warnTransVO.add(vo);
        }
    }

    @RequestMapping(value={"/queryWarnProjectList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ProjectPoolSetVO>> queryWarnProjectList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse queryProjectPoolList = this.projectPoolApi.queryProjectPoolList("1", null, null);
        List<Object> projectPoolSetVOS = new ArrayList();
        if (queryProjectPoolList.isSuccess()) {
            JSONArray poolListData = (JSONArray)queryProjectPoolList.getData();
            this.logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u9879\u76ee---------------------{}", (Object)poolListData);
            projectPoolSetVOS = JSON.parseArray((String)JSON.toJSONString((Object)poolListData), ProjectPoolSetVO.class);
            this.logger.info("\u89e3\u6790\u67e5\u8be2\u51fa\u6765\u7684\u9879\u76ee---------------------{}", projectPoolSetVOS);
            projectPoolSetVOS = projectPoolSetVOS.stream().filter(s -> "2".equals(s.getBusinessStatus()) && s.getSimpleFlag() != null && !"1".equals(s.getSimpleFlag()) && (s.getPlanDateNum() != null && s.getPlanDateNum() > 30 || s.getPlanDateNum() == null) && s.getProjectType() != null && 0 != s.getProjectType().compareTo(1506581524095864833L) && 0 != s.getProjectType().compareTo(1506581563782369282L)).collect(Collectors.toList());
            this.logger.info("\u9884\u8b66\u9879\u76ee------------------------{}", projectPoolSetVOS);
        }
        List pageData = PageUtil.listToPage(projectPoolSetVOS, (int)param.getPageIndex(), (int)param.getPageSize());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

