/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.project.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.acceptance.api.IPurchaseAcceptanceApi;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.probuilddiary.ledger.bean.LedgerTemplateEntity;
import com.ejianc.business.probuilddiary.ledger.service.ILedgerTemplateService;
import com.ejianc.business.probuilddiary.person.bean.PersonDetailEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonEquipmentEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonExamineEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonInformationEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonMaterialEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonOtherEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonQualityEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonSafetyEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonScheduleEntity;
import com.ejianc.business.probuilddiary.person.bean.PersonTypeEntity;
import com.ejianc.business.probuilddiary.person.service.IPersonService;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogDetailEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogEquipmentEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogExamineEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogInformationEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogMaterialEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogOtherEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogQualityEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogSafetyEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogScheduleEntity;
import com.ejianc.business.probuilddiary.project.bean.ProjectLogTypeEntity;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogDetailMapper;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogEquipmentMapper;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogExamineMapper;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogInformationMapper;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogMapper;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogMaterialMapper;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogOtherMapper;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogQualityMapper;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogSafetyMapper;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogScheduleMapper;
import com.ejianc.business.probuilddiary.project.mapper.ProjectLogTypeMapper;
import com.ejianc.business.probuilddiary.project.service.IProjectLogService;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogInformationVO;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogOtherVO;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogVO;
import com.ejianc.business.promaterial.check.api.ICheckApi;
import com.ejianc.business.rent.api.IRentAcceptanceApi;
import com.ejianc.business.warn.vo.CustomWarnSettingVO;
import com.ejianc.business.warn.vo.WarningDTO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="projectLogService")
public class ProjectLogServiceImpl
extends BaseServiceImpl<ProjectLogMapper, ProjectLogEntity>
implements IProjectLogService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_NAME = "\u9879\u76ee\u65e5\u5fd7";
    private static final String AUTO_SOURCE_TYPE = "\u81ea\u52a8\u751f\u6210";
    private static final String RULE_CODE = "PRO-BUILD-DIARY-PROJECT-LOG";
    private static final String CHECK_INFO = "\u4e2a\u4eba\u65e5\u5fd7\u5df2\u88ab\u64a4\u56de\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5";
    private static final String PERSON_BILL_TYPE = "EJCBT202209000022";
    private static final String PROJECT_LOG_BILL_TYPE = "EJCBT202209000019";
    private static final String EJC_BILL_ATTACHES = "ejc-bill-attaches";
    private static final String SCHEDULE_WORK_TYPE = "schedule_work_type";
    private static final String TYPE_WORK_TYPE = "type_work_type";
    private static final String QUALITY_WORK_TYPE = "quality_work_type";
    private static final String SAFETY_WORK_TYPE = "safety_work_type";
    private static final String MATERIAL_WORK_TYPE = "material_work_type";
    private static final String EQUIPMENT_WORK_TYPE = "equipment_work_type";
    private static final String EXAMINE_WORK_TYPE = "examine_work_type";
    private static final String INFORMATION_WORK_TYPE = "information_work_type";
    private static final String OTHER_WORK_TYPE = "other_work_type";
    private static final String SCHEDULE_TITLE = "\u8fdb\u5ea6\u60c5\u51b5\uff08\u65bd\u5de5\u5458\uff09";
    private static final String TYPE_TITLE = "\u65bd\u5de5\u7ec4\u7ec7\u8bbe\u8ba1\u3001\u65b9\u6848\u3001\u4ea4\u5e95\u3001\u53d8\u66f4\u60c5\u51b5\uff08\u6280\u672f\u8d1f\u8d23\u4eba\uff09";
    private static final String QUALITY_TITLE = "\u5de5\u7a0b\u8d28\u91cf\u68c0\u67e5\u3001\u9a8c\u6536\u60c5\u51b5\uff08\u8d28\u68c0\u5458\uff09";
    private static final String SAFETY_TITLE = "\u5b89\u5168\u6d3b\u52a8\u60c5\u51b5\uff08\u5b89\u5168\u5458\uff09";
    private static final String MATERIAL_TITLE = "\u6750\u6599\u8fdb\u51fa\u573a\u60c5\u51b5\uff08\u6750\u6599\u5458\uff09";
    private static final String EQUIPMENT_TITLE = "\u8bbe\u5907\u8fdb\u51fa\u573a\u60c5\u51b5\uff08\u8bbe\u5907\u7ba1\u7406\u5458\uff09";
    private static final String EXAMINE_TITLE = "\u68c0\u9a8c\u8bd5\u9a8c\u60c5\u51b5\uff08\u53d6\u6837\u5458\uff09";
    private static final String INFORMATION_TITLE = "\u5de5\u7a0b\u8d44\u6599\u5f52\u6863\u53ca\u4f1a\u8bae\u60c5\u51b5\uff08\u8d44\u6599\u5458\uff09";
    private static final String OTHER_TITLE = "\u5176\u4ed6\u60c5\u51b5";
    private final ProjectLogMapper mapper;
    private final ProjectLogDetailMapper projectLogDetailMapper;
    private final ProjectLogScheduleMapper projectLogScheduleMapper;
    private final ProjectLogTypeMapper projectLogTypeMapper;
    private final ProjectLogQualityMapper projectLogQualityMapper;
    private final ProjectLogSafetyMapper projectLogSafetyMapper;
    private final ProjectLogMaterialMapper projectLogMaterialMapper;
    private final ProjectLogEquipmentMapper projectLogEquipmentMapper;
    private final ProjectLogExamineMapper projectLogExamineMapper;
    private final ProjectLogInformationMapper projectLogInformationMapper;
    private final ProjectLogOtherMapper projectLogOtherMapper;
    private final IBillCodeApi billCodeApi;
    private final ICheckApi checkApi;
    private final IRentAcceptanceApi rentAcceptanceApi;
    private final IPurchaseAcceptanceApi purchaseAcceptanceApi;
    private final IPersonService personService;
    private final IWarnCenterApi warnCenterApi;
    private final IProjectPoolApi projectPoolApi;
    private final IAttachmentApi attachmentApi;
    @Value(value="${warning.code}")
    private String WARN_CODE;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private ILedgerTemplateService templateService;

    public ProjectLogServiceImpl(ProjectLogMapper mapper, ProjectLogDetailMapper projectLogDetailMapper, ProjectLogScheduleMapper projectLogScheduleMapper, ProjectLogTypeMapper projectLogTypeMapper, ProjectLogQualityMapper projectLogQualityMapper, ProjectLogSafetyMapper projectLogSafetyMapper, ProjectLogMaterialMapper projectLogMaterialMapper, ProjectLogEquipmentMapper projectLogEquipmentMapper, ProjectLogExamineMapper projectLogExamineMapper, ProjectLogInformationMapper projectLogInformationMapper, ProjectLogOtherMapper projectLogOtherMapper, IBillCodeApi billCodeApi, ICheckApi checkApi, IRentAcceptanceApi rentAcceptanceApi, IPurchaseAcceptanceApi purchaseAcceptanceApi, IPersonService personService, IWarnCenterApi warnCenterApi, IProjectPoolApi projectPoolApi, IAttachmentApi attachmentApi) {
        this.mapper = mapper;
        this.projectLogDetailMapper = projectLogDetailMapper;
        this.projectLogScheduleMapper = projectLogScheduleMapper;
        this.projectLogTypeMapper = projectLogTypeMapper;
        this.projectLogQualityMapper = projectLogQualityMapper;
        this.projectLogSafetyMapper = projectLogSafetyMapper;
        this.projectLogMaterialMapper = projectLogMaterialMapper;
        this.projectLogEquipmentMapper = projectLogEquipmentMapper;
        this.projectLogExamineMapper = projectLogExamineMapper;
        this.projectLogInformationMapper = projectLogInformationMapper;
        this.projectLogOtherMapper = projectLogOtherMapper;
        this.billCodeApi = billCodeApi;
        this.checkApi = checkApi;
        this.rentAcceptanceApi = rentAcceptanceApi;
        this.purchaseAcceptanceApi = purchaseAcceptanceApi;
        this.personService = personService;
        this.warnCenterApi = warnCenterApi;
        this.projectPoolApi = projectPoolApi;
        this.attachmentApi = attachmentApi;
    }

    @Override
    public boolean hasProjectLog(Long projectId, Date fillDate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"project_id", (Object)projectId)).eq((Object)"fill_date", (Object)fillDate)).last("LIMIT 1");
        int count = this.mapper.selectCount((Wrapper)queryWrapper);
        return count == 1;
    }

    @Override
    public void personLogConvertToProjectLog(PersonEntity person, boolean hasProjectLog) {
        this.logger.info("\u6821\u9a8c\u5f53\u5929\u662f\u5426\u6709\u9879\u76ee\u65e5\u5fd7\uff1a{}\uff0c\u4e2a\u4eba\u65e5\u5fd7\u6570\u636e\uff1a{}", (Object)hasProjectLog, (Object)JSON.toJSONString((Object)((Object)person), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", request.getHeader("authority"));
        headers.put("ejc-token", request.getHeader("ejc-token"));
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        if (hasProjectLog) {
            LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(ProjectLogEntity::getProjectId, (Object)person.getProjectId());
            lambdaQuery.eq(ProjectLogEntity::getFillDate, (Object)person.getInformantDate());
            ProjectLogEntity projectLogEntity = (ProjectLogEntity)((Object)super.getOne((Wrapper)lambdaQuery));
            Integer billState = projectLogEntity.getBillState();
            if (billState.equals(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()) || billState.equals(BillStateEnum.UNAPPROVED.getBillStateCode())) {
                ProjectLogEntity projectLog = (ProjectLogEntity)((Object)super.selectById((Serializable)projectLogEntity.getId()));
                ProjectLogEntity entity = this.spliceSubEntity(person, projectLog, headers, executorService);
                super.saveOrUpdate((Object)entity, false);
                this.writeBackGatherFlag(person.getId());
                this.transportCommonAttachment(person, headers, executorService, projectLogEntity.getId());
            }
        } else {
            ProjectLogEntity entity = this.generateProjectLog(person, headers, executorService);
            super.saveOrUpdate((Object)entity, false);
            this.writeBackGatherFlag(person.getId());
        }
    }

    private void transportAttachment(Long sourceBillId, Long targetBillId, String sourceType, HashMap<String, String> headers, ExecutorService executorService) {
        this.logger.info("\u4e2a\u4eba\u65e5\u5fd7\u540c\u6b65\u9644\u4ef6\u5230\u9879\u76ee\u65e5\u5fd7--start\uff0c\u5165\u53c2\uff1asourceBillId--{}\uff0ctargetBillId--{}\uff0csourceType--{}\uff0cheaders--{}", new Object[]{sourceBillId, targetBillId, sourceType, JSON.toJSONString(headers)});
        CompletableFuture.runAsync(() -> {
            this.logger.info("\u4e2a\u4eba\u65e5\u5fd7\u540c\u6b65\u9644\u4ef6\u5230\u9879\u76ee\u65e5\u5fd7--start");
            HashMap<String, Object> paramMaps = new HashMap<String, Object>();
            paramMaps.put("sourceBillId", sourceBillId);
            paramMaps.put("sourceBillType", PERSON_BILL_TYPE);
            paramMaps.put("sourceBillSourceType", sourceType);
            paramMaps.put("targetBillId", targetBillId);
            paramMaps.put("targetBillType", PROJECT_LOG_BILL_TYPE);
            paramMaps.put("targetBillSourceType", sourceType);
            String responseBody = ((HttpRequest)HttpUtil.createGet((String)(this.BaseHost + "ejc-file-web/api/attachref/copyFilesFromSourceBillToTargetBill")).addHeaders((Map)headers)).form(paramMaps).execute().body();
            CommonResponse res = (CommonResponse)JSON.parseObject((String)responseBody, CommonResponse.class);
            if (!res.isSuccess()) {
                this.logger.info("\u4e2a\u4eba\u65e5\u5fd7\u540c\u6b65\u9644\u4ef6\u5230\u9879\u76ee\u65e5\u5fd7\u5931\u8d25\uff0csourceBillId--{}\uff0csourceBillSourceType--{}\uff0ctargetBillId--{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{sourceBillId, sourceType, targetBillId, res.getMsg()});
            }
            this.logger.info("\u4e2a\u4eba\u65e5\u5fd7\u540c\u6b65\u9644\u4ef6\u5230\u9879\u76ee\u65e5\u5fd7--end");
        }, executorService);
    }

    private void writeBackGatherFlag(Long id) {
        LambdaUpdateWrapper lambdaUpdate = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)lambdaUpdate.eq(BaseEntity::getId, (Object)id)).set(PersonEntity::getGatherFlag, (Object)true);
        this.personService.update((Wrapper)lambdaUpdate);
    }

    private ProjectLogEntity spliceSubEntity(PersonEntity person, ProjectLogEntity entity, HashMap<String, String> headers, ExecutorService executorService) {
        BaseEntity p;
        ArrayList<ProjectLogExamineEntity> list;
        List<PersonDetailEntity> detailList = person.getDetailList();
        List<PersonScheduleEntity> scheduleList = person.getScheduleList();
        List<PersonTypeEntity> typeList = person.getTypeList();
        List<PersonQualityEntity> qualityList = person.getQualityList();
        List<PersonSafetyEntity> safetyList = person.getSafetyList();
        List<PersonMaterialEntity> materialList = person.getMaterialList();
        List<PersonEquipmentEntity> equipmentList = person.getEquipmentList();
        List<PersonExamineEntity> examineList = person.getExamineList();
        List<PersonInformationEntity> informationList = person.getInformationList();
        List<PersonOtherEntity> otherList = person.getOtherList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogDetailList())) {
                for (PersonDetailEntity personDetailEntity : detailList) {
                    ProjectLogDetailEntity projectLogDetailEntity = new ProjectLogDetailEntity();
                    projectLogDetailEntity.setPersonId(personDetailEntity.getPersonId());
                    projectLogDetailEntity.setConstructId(personDetailEntity.getConstructId());
                    projectLogDetailEntity.setConstructName(personDetailEntity.getConstructName());
                    projectLogDetailEntity.setConstructCode(personDetailEntity.getConstructCode());
                    projectLogDetailEntity.setTeamName(personDetailEntity.getTeamName());
                    projectLogDetailEntity.setWorkNum(personDetailEntity.getWorkNum());
                    projectLogDetailEntity.setWorkMemo(personDetailEntity.getWorkMemo());
                    projectLogDetailEntity.setCommitUserId(person.getCommitUserId());
                    projectLogDetailEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogDetailEntity.setCommitUserName(person.getCommitUserName());
                    projectLogDetailEntity.setCommitDate(person.getCommitDate());
                    projectLogDetailEntity.setProjectLogId(entity.getId());
                    projectLogDetailEntity.setLogNumber(personDetailEntity.getLogNumber());
                    projectLogDetailEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogDetailEntity.setDutyId(personDetailEntity.getDutyId());
                    projectLogDetailEntity.setDutyCode(personDetailEntity.getDutyCode());
                    projectLogDetailEntity.setDutyName(personDetailEntity.getDutyName());
                    projectLogDetailEntity.setFileType(personDetailEntity.getFileType());
                    projectLogDetailEntity.setUpdateFlag(Boolean.TRUE);
                    entity.getProjectLogDetailList().add(projectLogDetailEntity);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personDetailEntity.getFileType()), person.getId(), entity.getId(), personDetailEntity.getFileType(), headers, executorService);
                }
            } else {
                list = new ArrayList();
                for (PersonDetailEntity personDetailEntity : detailList) {
                    p = new ProjectLogDetailEntity();
                    p.setPersonId(personDetailEntity.getPersonId());
                    p.setConstructId(personDetailEntity.getConstructId());
                    p.setConstructName(personDetailEntity.getConstructName());
                    p.setConstructCode(personDetailEntity.getConstructCode());
                    p.setTeamName(personDetailEntity.getTeamName());
                    p.setWorkNum(personDetailEntity.getWorkNum());
                    p.setWorkMemo(personDetailEntity.getWorkMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personDetailEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setDutyId(personDetailEntity.getDutyId());
                    p.setDutyCode(personDetailEntity.getDutyCode());
                    p.setDutyName(personDetailEntity.getDutyName());
                    p.setFileType(personDetailEntity.getFileType());
                    p.setUpdateFlag(Boolean.TRUE);
                    list.add((ProjectLogExamineEntity)p);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personDetailEntity.getFileType()), person.getId(), entity.getId(), personDetailEntity.getFileType(), headers, executorService);
                }
                entity.setProjectLogDetailList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(scheduleList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogScheduleList())) {
                for (PersonScheduleEntity personScheduleEntity : scheduleList) {
                    ProjectLogScheduleEntity projectLogScheduleEntity = new ProjectLogScheduleEntity();
                    projectLogScheduleEntity.setPersonId(personScheduleEntity.getPersonId());
                    projectLogScheduleEntity.setScheduleMemo(personScheduleEntity.getScheduleMemo());
                    projectLogScheduleEntity.setCommitUserId(person.getCommitUserId());
                    projectLogScheduleEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogScheduleEntity.setCommitUserName(person.getCommitUserName());
                    projectLogScheduleEntity.setCommitDate(person.getCommitDate());
                    projectLogScheduleEntity.setProjectLogId(entity.getId());
                    projectLogScheduleEntity.setLogNumber(personScheduleEntity.getLogNumber());
                    projectLogScheduleEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogScheduleEntity.setFileType(personScheduleEntity.getFileType());
                    projectLogScheduleEntity.setUpdateFlag(Boolean.TRUE);
                    entity.getProjectLogScheduleList().add(projectLogScheduleEntity);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personScheduleEntity.getFileType()), person.getId(), entity.getId(), personScheduleEntity.getFileType(), headers, executorService);
                }
            } else {
                list = new ArrayList();
                for (PersonScheduleEntity personScheduleEntity : scheduleList) {
                    p = new ProjectLogScheduleEntity();
                    p.setPersonId(personScheduleEntity.getPersonId());
                    p.setScheduleMemo(personScheduleEntity.getScheduleMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personScheduleEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personScheduleEntity.getFileType());
                    p.setUpdateFlag(Boolean.TRUE);
                    list.add((ProjectLogExamineEntity)p);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personScheduleEntity.getFileType()), person.getId(), entity.getId(), personScheduleEntity.getFileType(), headers, executorService);
                }
                entity.setProjectLogScheduleList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(typeList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogTypeList())) {
                for (PersonTypeEntity personTypeEntity : typeList) {
                    ProjectLogTypeEntity projectLogTypeEntity = new ProjectLogTypeEntity();
                    projectLogTypeEntity.setPersonId(personTypeEntity.getPersonId());
                    projectLogTypeEntity.setWorkTypeId(personTypeEntity.getWorkTypeId());
                    projectLogTypeEntity.setWorkTypeName(personTypeEntity.getWorkTypeName());
                    projectLogTypeEntity.setWorkTypeCode(personTypeEntity.getWorkTypeCode());
                    projectLogTypeEntity.setWorkTypeMemo(personTypeEntity.getWorkTypeMemo());
                    projectLogTypeEntity.setCommitUserId(person.getCommitUserId());
                    projectLogTypeEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogTypeEntity.setCommitUserName(person.getCommitUserName());
                    projectLogTypeEntity.setCommitDate(person.getCommitDate());
                    projectLogTypeEntity.setProjectLogId(entity.getId());
                    projectLogTypeEntity.setLogNumber(personTypeEntity.getLogNumber());
                    projectLogTypeEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogTypeEntity.setFileType(personTypeEntity.getFileType());
                    projectLogTypeEntity.setUpdateFlag(Boolean.TRUE);
                    entity.getProjectLogTypeList().add(projectLogTypeEntity);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personTypeEntity.getFileType()), person.getId(), entity.getId(), personTypeEntity.getFileType(), headers, executorService);
                }
            } else {
                list = new ArrayList<ProjectLogDetailEntity>();
                for (PersonTypeEntity personTypeEntity : typeList) {
                    p = new ProjectLogTypeEntity();
                    p.setPersonId(personTypeEntity.getPersonId());
                    p.setWorkTypeId(personTypeEntity.getWorkTypeId());
                    p.setWorkTypeName(personTypeEntity.getWorkTypeName());
                    p.setWorkTypeCode(personTypeEntity.getWorkTypeCode());
                    p.setWorkTypeMemo(personTypeEntity.getWorkTypeMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personTypeEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personTypeEntity.getFileType());
                    p.setUpdateFlag(Boolean.TRUE);
                    list.add((ProjectLogExamineEntity)p);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personTypeEntity.getFileType()), person.getId(), entity.getId(), personTypeEntity.getFileType(), headers, executorService);
                }
                entity.setProjectLogTypeList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(qualityList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogQualityList())) {
                for (PersonQualityEntity personQualityEntity : qualityList) {
                    ProjectLogQualityEntity projectLogQualityEntity = new ProjectLogQualityEntity();
                    projectLogQualityEntity.setPersonId(personQualityEntity.getPersonId());
                    projectLogQualityEntity.setQualityId(personQualityEntity.getQualityId());
                    projectLogQualityEntity.setQualityName(personQualityEntity.getQualityName());
                    projectLogQualityEntity.setQualityCode(personQualityEntity.getQualityCode());
                    projectLogQualityEntity.setQualityMemo(personQualityEntity.getQualityMemo());
                    projectLogQualityEntity.setCommitUserId(person.getCommitUserId());
                    projectLogQualityEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogQualityEntity.setCommitUserName(person.getCommitUserName());
                    projectLogQualityEntity.setCommitDate(person.getCommitDate());
                    projectLogQualityEntity.setProjectLogId(entity.getId());
                    projectLogQualityEntity.setLogNumber(personQualityEntity.getLogNumber());
                    projectLogQualityEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogQualityEntity.setFileType(personQualityEntity.getFileType());
                    projectLogQualityEntity.setUpdateFlag(Boolean.TRUE);
                    entity.getProjectLogQualityList().add(projectLogQualityEntity);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personQualityEntity.getFileType()), person.getId(), entity.getId(), personQualityEntity.getFileType(), headers, executorService);
                }
            } else {
                list = new ArrayList<ProjectLogScheduleEntity>();
                for (PersonQualityEntity personQualityEntity : qualityList) {
                    p = new ProjectLogQualityEntity();
                    p.setPersonId(personQualityEntity.getPersonId());
                    p.setQualityId(personQualityEntity.getQualityId());
                    p.setQualityName(personQualityEntity.getQualityName());
                    p.setQualityCode(personQualityEntity.getQualityCode());
                    p.setQualityMemo(personQualityEntity.getQualityMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personQualityEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personQualityEntity.getFileType());
                    p.setUpdateFlag(Boolean.TRUE);
                    list.add((ProjectLogExamineEntity)p);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personQualityEntity.getFileType()), person.getId(), entity.getId(), personQualityEntity.getFileType(), headers, executorService);
                }
                entity.setProjectLogQualityList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(safetyList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogSafetyList())) {
                for (PersonSafetyEntity personSafetyEntity : safetyList) {
                    ProjectLogSafetyEntity projectLogSafetyEntity = new ProjectLogSafetyEntity();
                    projectLogSafetyEntity.setPersonId(personSafetyEntity.getPersonId());
                    projectLogSafetyEntity.setSafetyId(personSafetyEntity.getSafetyId());
                    projectLogSafetyEntity.setSafetyName(personSafetyEntity.getSafetyName());
                    projectLogSafetyEntity.setSafetyCode(personSafetyEntity.getSafetyCode());
                    projectLogSafetyEntity.setSafetyMemo(personSafetyEntity.getSafetyMemo());
                    projectLogSafetyEntity.setCommitUserId(person.getCommitUserId());
                    projectLogSafetyEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogSafetyEntity.setCommitUserName(person.getCommitUserName());
                    projectLogSafetyEntity.setCommitDate(person.getCommitDate());
                    projectLogSafetyEntity.setProjectLogId(entity.getId());
                    projectLogSafetyEntity.setLogNumber(personSafetyEntity.getLogNumber());
                    projectLogSafetyEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogSafetyEntity.setFileType(personSafetyEntity.getFileType());
                    projectLogSafetyEntity.setUpdateFlag(Boolean.TRUE);
                    entity.getProjectLogSafetyList().add(projectLogSafetyEntity);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personSafetyEntity.getFileType()), person.getId(), entity.getId(), personSafetyEntity.getFileType(), headers, executorService);
                }
            } else {
                list = new ArrayList<ProjectLogTypeEntity>();
                for (PersonSafetyEntity personSafetyEntity : safetyList) {
                    p = new ProjectLogSafetyEntity();
                    p.setPersonId(personSafetyEntity.getPersonId());
                    p.setSafetyId(personSafetyEntity.getSafetyId());
                    p.setSafetyName(personSafetyEntity.getSafetyName());
                    p.setSafetyCode(personSafetyEntity.getSafetyCode());
                    p.setSafetyMemo(personSafetyEntity.getSafetyMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personSafetyEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personSafetyEntity.getFileType());
                    p.setUpdateFlag(Boolean.TRUE);
                    list.add((ProjectLogExamineEntity)p);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personSafetyEntity.getFileType()), person.getId(), entity.getId(), personSafetyEntity.getFileType(), headers, executorService);
                }
                entity.setProjectLogSafetyList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(materialList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogMaterialList())) {
                for (PersonMaterialEntity personMaterialEntity : materialList) {
                    ProjectLogMaterialEntity projectLogMaterialEntity = new ProjectLogMaterialEntity();
                    projectLogMaterialEntity.setPersonId(personMaterialEntity.getPersonId());
                    projectLogMaterialEntity.setMaterialMemo(personMaterialEntity.getMaterialMemo());
                    projectLogMaterialEntity.setCommitUserId(person.getCommitUserId());
                    projectLogMaterialEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogMaterialEntity.setCommitUserName(person.getCommitUserName());
                    projectLogMaterialEntity.setCommitDate(person.getCommitDate());
                    projectLogMaterialEntity.setProjectLogId(entity.getId());
                    projectLogMaterialEntity.setLogNumber(personMaterialEntity.getLogNumber());
                    projectLogMaterialEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogMaterialEntity.setFileType(personMaterialEntity.getFileType());
                    projectLogMaterialEntity.setUpdateFlag(Boolean.TRUE);
                    entity.getProjectLogMaterialList().add(projectLogMaterialEntity);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personMaterialEntity.getFileType()), person.getId(), entity.getId(), personMaterialEntity.getFileType(), headers, executorService);
                }
            } else {
                list = new ArrayList<ProjectLogQualityEntity>();
                for (PersonMaterialEntity personMaterialEntity : materialList) {
                    p = new ProjectLogMaterialEntity();
                    p.setPersonId(personMaterialEntity.getPersonId());
                    p.setMaterialMemo(personMaterialEntity.getMaterialMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personMaterialEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personMaterialEntity.getFileType());
                    p.setUpdateFlag(Boolean.TRUE);
                    list.add((ProjectLogExamineEntity)p);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personMaterialEntity.getFileType()), person.getId(), entity.getId(), personMaterialEntity.getFileType(), headers, executorService);
                }
                entity.setProjectLogMaterialList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(equipmentList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogEquipmentList())) {
                for (PersonEquipmentEntity personEquipmentEntity : equipmentList) {
                    ProjectLogEquipmentEntity projectLogEquipmentEntity = new ProjectLogEquipmentEntity();
                    projectLogEquipmentEntity.setPersonId(personEquipmentEntity.getPersonId());
                    projectLogEquipmentEntity.setEquipmentMemo(personEquipmentEntity.getEquipmentMemo());
                    projectLogEquipmentEntity.setCommitUserId(person.getCommitUserId());
                    projectLogEquipmentEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogEquipmentEntity.setCommitUserName(person.getCommitUserName());
                    projectLogEquipmentEntity.setCommitDate(person.getCommitDate());
                    projectLogEquipmentEntity.setProjectLogId(entity.getId());
                    projectLogEquipmentEntity.setLogNumber(personEquipmentEntity.getLogNumber());
                    projectLogEquipmentEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogEquipmentEntity.setFileType(personEquipmentEntity.getFileType());
                    projectLogEquipmentEntity.setUpdateFlag(Boolean.TRUE);
                    entity.getProjectLogEquipmentList().add(projectLogEquipmentEntity);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personEquipmentEntity.getFileType()), person.getId(), entity.getId(), personEquipmentEntity.getFileType(), headers, executorService);
                }
            } else {
                list = new ArrayList<ProjectLogSafetyEntity>();
                for (PersonEquipmentEntity personEquipmentEntity : equipmentList) {
                    p = new ProjectLogEquipmentEntity();
                    p.setPersonId(personEquipmentEntity.getPersonId());
                    p.setEquipmentMemo(personEquipmentEntity.getEquipmentMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personEquipmentEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personEquipmentEntity.getFileType());
                    p.setUpdateFlag(Boolean.TRUE);
                    list.add((ProjectLogExamineEntity)p);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personEquipmentEntity.getFileType()), person.getId(), entity.getId(), personEquipmentEntity.getFileType(), headers, executorService);
                }
                entity.setProjectLogEquipmentList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(examineList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogExamineList())) {
                for (PersonExamineEntity personExamineEntity : examineList) {
                    ProjectLogExamineEntity projectLogExamineEntity = new ProjectLogExamineEntity();
                    projectLogExamineEntity.setPersonId(personExamineEntity.getPersonId());
                    projectLogExamineEntity.setMoldId(personExamineEntity.getMoldId());
                    projectLogExamineEntity.setMoldName(personExamineEntity.getMoldName());
                    projectLogExamineEntity.setMoldCode(personExamineEntity.getMoldCode());
                    projectLogExamineEntity.setMakeName(personExamineEntity.getMakeName());
                    projectLogExamineEntity.setInspectName(personExamineEntity.getInspectName());
                    projectLogExamineEntity.setExamineName(personExamineEntity.getExamineName());
                    projectLogExamineEntity.setExamineNum(personExamineEntity.getExamineNum());
                    projectLogExamineEntity.setCommitUserId(person.getCommitUserId());
                    projectLogExamineEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogExamineEntity.setCommitUserName(person.getCommitUserName());
                    projectLogExamineEntity.setCommitDate(person.getCommitDate());
                    projectLogExamineEntity.setProjectLogId(entity.getId());
                    projectLogExamineEntity.setLogNumber(personExamineEntity.getLogNumber());
                    projectLogExamineEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogExamineEntity.setFileType(personExamineEntity.getFileType());
                    projectLogExamineEntity.setUpdateFlag(Boolean.TRUE);
                    entity.getProjectLogExamineList().add(projectLogExamineEntity);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personExamineEntity.getFileType()), person.getId(), entity.getId(), personExamineEntity.getFileType(), headers, executorService);
                }
            } else {
                list = new ArrayList<ProjectLogMaterialEntity>();
                for (PersonExamineEntity personExamineEntity : examineList) {
                    p = new ProjectLogExamineEntity();
                    p.setPersonId(personExamineEntity.getPersonId());
                    p.setMoldId(personExamineEntity.getMoldId());
                    p.setMoldName(personExamineEntity.getMoldName());
                    p.setMoldCode(personExamineEntity.getMoldCode());
                    p.setMakeName(personExamineEntity.getMakeName());
                    p.setInspectName(personExamineEntity.getInspectName());
                    p.setExamineName(personExamineEntity.getExamineName());
                    p.setExamineNum(personExamineEntity.getExamineNum());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personExamineEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personExamineEntity.getFileType());
                    p.setUpdateFlag(Boolean.TRUE);
                    list.add((ProjectLogExamineEntity)p);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personExamineEntity.getFileType()), person.getId(), entity.getId(), personExamineEntity.getFileType(), headers, executorService);
                }
                entity.setProjectLogExamineList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(informationList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogInformationList())) {
                for (PersonInformationEntity personInformationEntity : informationList) {
                    ProjectLogInformationEntity projectLogInformationEntity = new ProjectLogInformationEntity();
                    projectLogInformationEntity.setPersonId(personInformationEntity.getPersonId());
                    projectLogInformationEntity.setInformMoldId(personInformationEntity.getInformMoldId());
                    projectLogInformationEntity.setInformMoldName(personInformationEntity.getInformMoldName());
                    projectLogInformationEntity.setInformMoldCode(personInformationEntity.getInformMoldCode());
                    projectLogInformationEntity.setInformationMemo(personInformationEntity.getInformationMemo());
                    projectLogInformationEntity.setCommitUserId(person.getCommitUserId());
                    projectLogInformationEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogInformationEntity.setCommitUserName(person.getCommitUserName());
                    projectLogInformationEntity.setCommitDate(person.getCommitDate());
                    projectLogInformationEntity.setProjectLogId(entity.getId());
                    projectLogInformationEntity.setLogNumber(personInformationEntity.getLogNumber());
                    projectLogInformationEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogInformationEntity.setFileType(personInformationEntity.getFileType());
                    projectLogInformationEntity.setUpdateFlag(Boolean.TRUE);
                    entity.getProjectLogInformationList().add(projectLogInformationEntity);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personInformationEntity.getFileType()), person.getId(), entity.getId(), personInformationEntity.getFileType(), headers, executorService);
                }
            } else {
                list = new ArrayList<ProjectLogEquipmentEntity>();
                for (PersonInformationEntity personInformationEntity : informationList) {
                    p = new ProjectLogInformationEntity();
                    p.setPersonId(personInformationEntity.getPersonId());
                    p.setInformMoldId(personInformationEntity.getInformMoldId());
                    p.setInformMoldName(personInformationEntity.getInformMoldName());
                    p.setInformMoldCode(personInformationEntity.getInformMoldCode());
                    p.setInformationMemo(personInformationEntity.getInformationMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personInformationEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personInformationEntity.getFileType());
                    p.setUpdateFlag(Boolean.TRUE);
                    list.add((ProjectLogExamineEntity)p);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personInformationEntity.getFileType()), person.getId(), entity.getId(), personInformationEntity.getFileType(), headers, executorService);
                }
                entity.setProjectLogInformationList(list);
            }
        }
        if (CollectionUtils.isNotEmpty(otherList)) {
            if (CollectionUtils.isNotEmpty(entity.getProjectLogOtherList())) {
                for (PersonOtherEntity personOtherEntity : otherList) {
                    ProjectLogOtherEntity projectLogOtherEntity = new ProjectLogOtherEntity();
                    projectLogOtherEntity.setPersonId(personOtherEntity.getPersonId());
                    projectLogOtherEntity.setOtherMemo(personOtherEntity.getOtherMemo());
                    projectLogOtherEntity.setCommitUserId(person.getCommitUserId());
                    projectLogOtherEntity.setCommitUserCode(person.getCommitUserCode());
                    projectLogOtherEntity.setCommitUserName(person.getCommitUserName());
                    projectLogOtherEntity.setCommitDate(person.getCommitDate());
                    projectLogOtherEntity.setProjectLogId(entity.getId());
                    projectLogOtherEntity.setLogNumber(personOtherEntity.getLogNumber());
                    projectLogOtherEntity.setProjectManagerFlag(Boolean.FALSE);
                    projectLogOtherEntity.setFileType(personOtherEntity.getFileType());
                    projectLogOtherEntity.setUpdateFlag(Boolean.TRUE);
                    entity.getProjectLogOtherList().add(projectLogOtherEntity);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personOtherEntity.getFileType()), person.getId(), entity.getId(), personOtherEntity.getFileType(), headers, executorService);
                }
            } else {
                list = new ArrayList<ProjectLogExamineEntity>();
                for (PersonOtherEntity personOtherEntity : otherList) {
                    p = new ProjectLogOtherEntity();
                    p.setPersonId(personOtherEntity.getPersonId());
                    p.setOtherMemo(personOtherEntity.getOtherMemo());
                    p.setCommitUserId(person.getCommitUserId());
                    p.setCommitUserCode(person.getCommitUserCode());
                    p.setCommitUserName(person.getCommitUserName());
                    p.setCommitDate(person.getCommitDate());
                    p.setProjectLogId(entity.getId());
                    p.setLogNumber(personOtherEntity.getLogNumber());
                    p.setProjectManagerFlag(Boolean.FALSE);
                    p.setFileType(personOtherEntity.getFileType());
                    p.setUpdateFlag(Boolean.TRUE);
                    list.add((ProjectLogExamineEntity)p);
                    this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)personOtherEntity.getFileType()), person.getId(), entity.getId(), personOtherEntity.getFileType(), headers, executorService);
                }
                entity.setProjectLogOtherList(list);
            }
        }
        return entity;
    }

    private void transportToProjectLogSub(boolean e, Long personId, Long targetBillId, String sourceType, HashMap<String, String> headers, ExecutorService executorService) {
        if (e) {
            this.transportAttachment(personId, targetBillId, sourceType, headers, executorService);
        }
    }

    private ProjectLogEntity generateProjectLog(PersonEntity person, HashMap<String, String> headers, ExecutorService executorService) {
        ProjectLogEntity entity = new ProjectLogEntity();
        long targetBillId = IdWorker.getId();
        entity.setId(targetBillId);
        entity.setBillCode(this.generateBillCode());
        entity.setBillName(BILL_NAME);
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        entity.setOrgId(person.getOrgId());
        entity.setOrgCode(person.getOrgCode());
        entity.setOrgName(person.getOrgName());
        entity.setParentOrgId(person.getParentOrgId());
        entity.setParentOrgCode(person.getParentOrgCode());
        entity.setParentOrgName(person.getParentOrgName());
        entity.setProjectId(person.getProjectId());
        entity.setProjectCode(person.getProjectCode());
        entity.setProjectName(person.getProjectName());
        entity.setSourceType(AUTO_SOURCE_TYPE);
        entity.setFillDate(person.getInformantDate());
        entity.setWeek(this.getDayOfTheWeek(person.getInformantDate()));
        this.transportCommonAttachment(person, headers, executorService, targetBillId);
        entity.setProjectLogDetailList(this.personConvertToProjectLogDetail(person, person.getDetailList(), headers, executorService, targetBillId));
        entity.setProjectLogScheduleList(this.personConvertToProjectLogSchedule(person, person.getScheduleList(), headers, executorService, targetBillId));
        entity.setProjectLogTypeList(this.personConvertToProjectLogType(person, person.getTypeList(), headers, executorService, targetBillId));
        entity.setProjectLogQualityList(this.personConvertToProjectLogQuality(person, person.getQualityList(), headers, executorService, targetBillId));
        entity.setProjectLogSafetyList(this.personConvertToProjectLogSafety(person, person.getSafetyList(), headers, executorService, targetBillId));
        entity.setProjectLogMaterialList(this.personConvertToProjectLogMaterial(person, person.getMaterialList(), headers, executorService, targetBillId));
        entity.setProjectLogEquipmentList(this.personConvertToProjectLogEquipment(person, person.getEquipmentList(), headers, executorService, targetBillId));
        entity.setProjectLogExamineList(this.personConvertToProjectLogExamine(person, person.getExamineList(), headers, executorService, targetBillId));
        entity.setProjectLogInformationList(this.personConvertToProjectLogInformation(person, person.getInformationList(), headers, executorService, targetBillId));
        entity.setProjectLogOtherList(this.personConvertToProjectLogOther(person, person.getOtherList(), headers, executorService, targetBillId));
        return entity;
    }

    private void transportCommonAttachment(PersonEntity person, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        CommonResponse commonResponse = this.attachmentApi.queryListBySourceId(person.getId(), PERSON_BILL_TYPE, EJC_BILL_ATTACHES, null);
        this.transportToProjectLogSub(commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData())), person.getId(), targetBillId, EJC_BILL_ATTACHES, headers, executorService);
    }

    private String generateBillCode() {
        BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)new ProjectLogVO());
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return (String)billCode.getData();
    }

    private String getDayOfTheWeek(Date date) {
        String[][] strArray = new String[][]{{"MONDAY", "\u661f\u671f\u4e00"}, {"TUESDAY", "\u661f\u671f\u4e8c"}, {"WEDNESDAY", "\u661f\u671f\u4e09"}, {"THURSDAY", "\u661f\u671f\u56db"}, {"FRIDAY", "\u661f\u671f\u4e94"}, {"SATURDAY", "\u661f\u671f\u516d"}, {"SUNDAY", "\u661f\u671f\u65e5"}};
        LocalDate currentDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        String k = String.valueOf(currentDate.getDayOfWeek());
        String week = null;
        for (String[] strings : strArray) {
            if (!k.equals(strings[0])) continue;
            week = strings[1];
            break;
        }
        return week;
    }

    private List<ProjectLogDetailEntity> personConvertToProjectLogDetail(PersonEntity person, List<PersonDetailEntity> detailList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        ArrayList<ProjectLogDetailEntity> list = new ArrayList<ProjectLogDetailEntity>();
        for (PersonDetailEntity e : detailList) {
            ProjectLogDetailEntity p = new ProjectLogDetailEntity();
            p.setPersonId(e.getPersonId());
            p.setConstructId(e.getConstructId());
            p.setConstructName(e.getConstructName());
            p.setConstructCode(e.getConstructCode());
            p.setTeamName(e.getTeamName());
            p.setWorkNum(e.getWorkNum());
            p.setWorkMemo(e.getWorkMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setDutyId(e.getDutyId());
            p.setDutyCode(e.getDutyCode());
            p.setDutyName(e.getDutyName());
            p.setFileType(e.getFileType());
            p.setUpdateFlag(Boolean.TRUE);
            list.add(p);
            this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
        }
        return list;
    }

    private List<ProjectLogScheduleEntity> personConvertToProjectLogSchedule(PersonEntity person, List<PersonScheduleEntity> scheduleList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        ArrayList<ProjectLogScheduleEntity> list = new ArrayList<ProjectLogScheduleEntity>();
        for (PersonScheduleEntity e : scheduleList) {
            ProjectLogScheduleEntity p = new ProjectLogScheduleEntity();
            p.setPersonId(e.getPersonId());
            p.setScheduleMemo(e.getScheduleMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            p.setUpdateFlag(Boolean.TRUE);
            list.add(p);
            this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
        }
        return list;
    }

    private List<ProjectLogTypeEntity> personConvertToProjectLogType(PersonEntity person, List<PersonTypeEntity> typeList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        ArrayList<ProjectLogTypeEntity> list = new ArrayList<ProjectLogTypeEntity>();
        for (PersonTypeEntity e : typeList) {
            ProjectLogTypeEntity p = new ProjectLogTypeEntity();
            p.setPersonId(e.getPersonId());
            p.setWorkTypeId(e.getWorkTypeId());
            p.setWorkTypeName(e.getWorkTypeName());
            p.setWorkTypeCode(e.getWorkTypeCode());
            p.setWorkTypeMemo(e.getWorkTypeMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            p.setUpdateFlag(Boolean.TRUE);
            list.add(p);
            this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
        }
        return list;
    }

    private List<ProjectLogQualityEntity> personConvertToProjectLogQuality(PersonEntity person, List<PersonQualityEntity> qualityList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        ArrayList<ProjectLogQualityEntity> list = new ArrayList<ProjectLogQualityEntity>();
        for (PersonQualityEntity e : qualityList) {
            ProjectLogQualityEntity p = new ProjectLogQualityEntity();
            p.setPersonId(e.getPersonId());
            p.setQualityId(e.getQualityId());
            p.setQualityName(e.getQualityName());
            p.setQualityCode(e.getQualityCode());
            p.setQualityMemo(e.getQualityMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            p.setUpdateFlag(Boolean.TRUE);
            list.add(p);
            this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
        }
        return list;
    }

    private List<ProjectLogSafetyEntity> personConvertToProjectLogSafety(PersonEntity person, List<PersonSafetyEntity> safetyList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        ArrayList<ProjectLogSafetyEntity> list = new ArrayList<ProjectLogSafetyEntity>();
        for (PersonSafetyEntity e : safetyList) {
            ProjectLogSafetyEntity p = new ProjectLogSafetyEntity();
            p.setPersonId(e.getPersonId());
            p.setSafetyId(e.getSafetyId());
            p.setSafetyName(e.getSafetyName());
            p.setSafetyCode(e.getSafetyCode());
            p.setSafetyMemo(e.getSafetyMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            p.setUpdateFlag(Boolean.TRUE);
            list.add(p);
            this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
        }
        return list;
    }

    private List<ProjectLogMaterialEntity> personConvertToProjectLogMaterial(PersonEntity person, List<PersonMaterialEntity> materialList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        ArrayList<ProjectLogMaterialEntity> list = new ArrayList<ProjectLogMaterialEntity>();
        for (PersonMaterialEntity e : materialList) {
            ProjectLogMaterialEntity p = new ProjectLogMaterialEntity();
            p.setPersonId(e.getPersonId());
            p.setMaterialMemo(e.getMaterialMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            p.setUpdateFlag(Boolean.TRUE);
            list.add(p);
            this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
        }
        return list;
    }

    private List<ProjectLogEquipmentEntity> personConvertToProjectLogEquipment(PersonEntity person, List<PersonEquipmentEntity> equipmentList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        ArrayList<ProjectLogEquipmentEntity> list = new ArrayList<ProjectLogEquipmentEntity>();
        for (PersonEquipmentEntity e : equipmentList) {
            ProjectLogEquipmentEntity p = new ProjectLogEquipmentEntity();
            p.setPersonId(e.getPersonId());
            p.setEquipmentMemo(e.getEquipmentMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            p.setUpdateFlag(Boolean.TRUE);
            list.add(p);
            this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
        }
        return list;
    }

    private List<ProjectLogExamineEntity> personConvertToProjectLogExamine(PersonEntity person, List<PersonExamineEntity> examineList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        ArrayList<ProjectLogExamineEntity> list = new ArrayList<ProjectLogExamineEntity>();
        for (PersonExamineEntity e : examineList) {
            ProjectLogExamineEntity p = new ProjectLogExamineEntity();
            p.setPersonId(e.getPersonId());
            p.setMoldId(e.getMoldId());
            p.setMoldName(e.getMoldName());
            p.setMoldCode(e.getMoldCode());
            p.setMakeName(e.getMakeName());
            p.setExamineMemo(e.getExamineMemo());
            p.setInspectName(e.getInspectName());
            p.setExamineName(e.getExamineName());
            p.setExamineNum(e.getExamineNum());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            p.setUpdateFlag(Boolean.TRUE);
            list.add(p);
            this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
        }
        return list;
    }

    private List<ProjectLogInformationEntity> personConvertToProjectLogInformation(PersonEntity person, List<PersonInformationEntity> informationList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        ArrayList<ProjectLogInformationEntity> list = new ArrayList<ProjectLogInformationEntity>();
        for (PersonInformationEntity e : informationList) {
            ProjectLogInformationEntity p = new ProjectLogInformationEntity();
            p.setPersonId(e.getPersonId());
            p.setInformMoldId(e.getInformMoldId());
            p.setInformMoldName(e.getInformMoldName());
            p.setInformMoldCode(e.getInformMoldCode());
            p.setInformationMemo(e.getInformationMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            p.setUpdateFlag(Boolean.TRUE);
            list.add(p);
            this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
        }
        return list;
    }

    private List<ProjectLogOtherEntity> personConvertToProjectLogOther(PersonEntity person, List<PersonOtherEntity> otherList, HashMap<String, String> headers, ExecutorService executorService, long targetBillId) {
        ArrayList<ProjectLogOtherEntity> list = new ArrayList<ProjectLogOtherEntity>();
        for (PersonOtherEntity e : otherList) {
            ProjectLogOtherEntity p = new ProjectLogOtherEntity();
            p.setPersonId(e.getPersonId());
            p.setOtherMemo(e.getOtherMemo());
            p.setCommitUserId(person.getCommitUserId());
            p.setCommitUserCode(person.getCommitUserCode());
            p.setCommitUserName(person.getCommitUserName());
            p.setCommitDate(person.getCommitDate());
            p.setLogNumber(e.getLogNumber());
            p.setProjectManagerFlag(Boolean.FALSE);
            p.setFileType(e.getFileType());
            p.setUpdateFlag(Boolean.TRUE);
            list.add(p);
            this.transportToProjectLogSub(StringUtils.isNotBlank((CharSequence)e.getFileType()), person.getId(), targetBillId, e.getFileType(), headers, executorService);
        }
        return list;
    }

    @Override
    public Map<String, Integer> countBillNum(JSONObject jsonObject) {
        if (!jsonObject.containsKey((Object)"projectId")) {
            throw new BusinessException("\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!jsonObject.containsKey((Object)"fillDate")) {
            throw new BusinessException("\u586b\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CommonResponse res1 = this.checkApi.countBillNum(jsonObject);
        if (!res1.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u6d88\u8017\u6750\u3001\u6df7\u51dd\u571f\u5355\u636e\u6570\u91cf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res1.getMsg());
        }
        Map data = (Map)res1.getData();
        CommonResponse res2 = this.rentAcceptanceApi.countBillNum(jsonObject);
        if (!res2.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u8bbe\u5907\u79df\u8d41\u5355\u636e\u6570\u91cf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res2.getMsg());
        }
        data.put("\u8bbe\u5907\u79df\u8d41", res2.getData());
        CommonResponse res3 = this.purchaseAcceptanceApi.countBillNum(jsonObject);
        if (!res3.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u8bbe\u5907\u91c7\u8d2d\u5355\u636e\u6570\u91cf\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res3.getMsg());
        }
        data.put("\u8bbe\u5907\u91c7\u8d2d", res3.getData());
        return data;
    }

    @Override
    public void checkPersonBillState(ProjectLogEntity entity) {
        Integer count;
        List<ProjectLogDetailEntity> projectLogDetailList = entity.getProjectLogDetailList();
        List<ProjectLogScheduleEntity> projectLogScheduleList = entity.getProjectLogScheduleList();
        List<ProjectLogTypeEntity> projectLogTypeList = entity.getProjectLogTypeList();
        List<ProjectLogQualityEntity> projectLogQualityList = entity.getProjectLogQualityList();
        List<ProjectLogSafetyEntity> projectLogSafetyList = entity.getProjectLogSafetyList();
        List<ProjectLogMaterialEntity> projectLogMaterialList = entity.getProjectLogMaterialList();
        List<ProjectLogEquipmentEntity> projectLogEquipmentList = entity.getProjectLogEquipmentList();
        List<ProjectLogExamineEntity> projectLogExamineList = entity.getProjectLogExamineList();
        List<ProjectLogInformationEntity> projectLogInformationList = entity.getProjectLogInformationList();
        List<ProjectLogOtherEntity> projectLogOtherList = entity.getProjectLogOtherList();
        HashSet<Long> ids = new HashSet<Long>();
        if (CollectionUtils.isNotEmpty(projectLogDetailList)) {
            ids.addAll(projectLogDetailList.stream().map(ProjectLogDetailEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogScheduleList)) {
            ids.addAll(projectLogScheduleList.stream().map(ProjectLogScheduleEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogTypeList)) {
            ids.addAll(projectLogTypeList.stream().map(ProjectLogTypeEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogQualityList)) {
            ids.addAll(projectLogQualityList.stream().map(ProjectLogQualityEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogSafetyList)) {
            ids.addAll(projectLogSafetyList.stream().map(ProjectLogSafetyEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogMaterialList)) {
            ids.addAll(projectLogMaterialList.stream().map(ProjectLogMaterialEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogEquipmentList)) {
            ids.addAll(projectLogEquipmentList.stream().map(ProjectLogEquipmentEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogExamineList)) {
            ids.addAll(projectLogExamineList.stream().map(ProjectLogExamineEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogInformationList)) {
            ids.addAll(projectLogInformationList.stream().map(ProjectLogInformationEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(projectLogOtherList)) {
            ids.addAll(projectLogOtherList.stream().map(ProjectLogOtherEntity::getPersonId).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(ids) && (count = this.personService.countUncommitedState(ids)) > 0) {
            throw new BusinessException(CHECK_INFO);
        }
    }

    @Override
    public void warn(HttpServletRequest request) {
        this.logger.warn("\u6839\u636e\u8c03\u5ea6\u53c2\u6570\u7f16\u7801\uff1a{}\uff0c\u5f53\u524d\u7ec4\u7ec7id\uff1a{}", (Object)this.WARN_CODE, (Object)InvocationInfoProxy.getOrgId());
        CommonResponse commonResponse = this.warnCenterApi.getWarnSet(this.WARN_CODE, InvocationInfoProxy.getOrgId());
        if (!commonResponse.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u8c03\u5ea6\u53c2\u6570\u7f16\u7801\uff1a" + this.WARN_CODE + "\uff0c\u5f53\u524d\u7ec4\u7ec7id\uff1a" + InvocationInfoProxy.getOrgId() + ",\u83b7\u53d6\u9884\u8b66\u914d\u7f6e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + commonResponse.getMsg());
        }
        this.logger.info("\u67e5\u8be2\u9884\u8b66\u4e2d\u5fc3\u8bbe\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)commonResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        WarningDTO warningDTO = (WarningDTO)commonResponse.getData();
        List customWarnSettingVOS = warningDTO.getWarningSetings();
        if (CollectionUtils.isNotEmpty((Collection)customWarnSettingVOS)) {
            CommonResponse response = this.projectPoolApi.queryProjectsByOrgId(InvocationInfoProxy.getOrgId());
            if (!response.isSuccess()) {
                throw new BusinessException("\u6839\u636e\u5f53\u524d\u7ec4\u7ec7\uff1a" + InvocationInfoProxy.getOrgId() + "\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u4e0b\u6240\u6709\u542f\u7528\u4e14\u5728\u5efa\u7684\u9879\u76ee\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            List data = (List)response.getData();
            this.logger.info("\u542f\u7528\u4e14\u5728\u5efa\u7684\u9879\u76ee\uff1a{}", (Object)JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                CustomWarnSettingVO customWarnSettingVO = (CustomWarnSettingVO)customWarnSettingVOS.get(0);
                int day = Integer.parseInt(customWarnSettingVO.getParameterValue());
                LocalDate now = LocalDate.now();
                LocalDate warn = now.minusDays(day);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                this.logger.info("\u5f53\u524d\u65e5\u671f\uff1a{}\uff0c\u9884\u8b66\u524d{}\u5929\uff0c\u8981\u9884\u8b66\u7684\u65e5\u671f\uff1a{}", new Object[]{now.format(formatter), day, warn.format(formatter)});
                Date warnDate = Date.from(warn.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
                lambdaQuery.eq(ProjectLogEntity::getFillDate, (Object)warnDate);
                List projectLogEntityList = super.list((Wrapper)lambdaQuery);
                ArrayList<EarlyWarnTransVO> warnTransVO = new ArrayList<EarlyWarnTransVO>();
                if (CollectionUtils.isNotEmpty((Collection)projectLogEntityList)) {
                    this.logger.info("\u9884\u8b66\u5728\u5efa\u542f\u7528\u7684\u9879\u76ee--part\uff0c\u5df2\u586b\u62a5\u7684\u9879\u76ee\u65e5\u5fd7\uff1a{}", (Object)JSON.toJSONString((Object)projectLogEntityList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                    Map projectVOMap = data.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                    for (ProjectLogEntity projectLogEntity : projectLogEntityList) {
                        projectVOMap.remove(projectLogEntity.getProjectId());
                    }
                    if (!projectVOMap.isEmpty()) {
                        Collection<ProjectVO> values = projectVOMap.values();
                        this.logger.info("\u9884\u8b66\u5728\u5efa\u542f\u7528\u7684\u9879\u76ee--part\uff0c\u672a\u586b\u62a5\u7684\u9879\u76ee\uff1a{}", (Object)JSON.toJSONString(values, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                        ProjectLogServiceImpl.splice(warningDTO, warn, formatter, warnTransVO, values);
                    }
                } else {
                    this.logger.info("\u9884\u8b66\u5728\u5efa\u542f\u7528\u7684\u9879\u76ee--all");
                    ProjectLogServiceImpl.splice(warningDTO, warn, formatter, warnTransVO, data);
                }
                if (CollectionUtils.isNotEmpty(warnTransVO)) {
                    CommonResponse res = this.warnCenterApi.sendToWarnCenterByCode(warnTransVO, this.WARN_CODE);
                    if (!res.isSuccess()) {
                        this.logger.info("\u9884\u8b66\u5185\u5bb9\u53d1\u9001\u81f3\u9884\u8b66\u4e2d\u5fc3\u5931\u8d25\uff0c\u5177\u4f53\u53c2\u6570\uff1a{},\u9884\u8b66\u53c2\u6570\u7f16\u7801\uff1a{}\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{JSON.toJSONString(warnTransVO), this.WARN_CODE, res.getMsg()});
                    }
                    this.logger.info("\u9884\u8b66\u4e2d\u5fc3\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
                }
            }
        }
    }

    private static void splice(WarningDTO warningDTO, LocalDate warn, DateTimeFormatter formatter, List<EarlyWarnTransVO> warnTransVO, Collection<ProjectVO> values) {
        for (ProjectVO projectVO : values) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setSourceId(String.valueOf(projectVO.getId()));
            vo.setTenantId(projectVO.getTenantId());
            vo.setOrgId(projectVO.getOrgId());
            vo.setOrgName(projectVO.getOrgName());
            vo.setSendOrgId(String.valueOf(projectVO.getOrgId()));
            vo.setEarlywarnName(warningDTO.getName());
            vo.setBillName(projectVO.getProjectName());
            vo.setEarlywarnContent(warningDTO.getWarningContentTemplate().replace("#projectName#", projectVO.getProjectName()).replace("#fillDate#", warn.format(formatter)));
            vo.setWarnSetId(warningDTO.getId());
            vo.setWarnSetParamId(CollectionUtils.isNotEmpty((Collection)warningDTO.getWarningSetings()) ? ((CustomWarnSettingVO)warningDTO.getWarningSetings().get(0)).getId() : null);
            vo.setMoUrl("/ejc-probuilddiary-mobile/#/projectLog/card");
            vo.setPcTitle(BILL_NAME);
            vo.setWarnLevel(warningDTO.getWarningLevel());
            vo.setWarnType(String.valueOf(warningDTO.getWarnType()));
            warnTransVO.add(vo);
        }
    }

    @Override
    public void deleteAllDataByPersonId(Long id, Long projectId, Date informantDate) {
        ProjectLogEntity entity;
        ProjectLogEntity projectLogEntity;
        this.projectLogDetailMapper.deleteByPersonId(id);
        this.projectLogScheduleMapper.deleteByPersonId(id);
        this.projectLogTypeMapper.deleteByPersonId(id);
        this.projectLogQualityMapper.deleteByPersonId(id);
        this.projectLogSafetyMapper.deleteByPersonId(id);
        this.projectLogMaterialMapper.deleteByPersonId(id);
        this.projectLogEquipmentMapper.deleteByPersonId(id);
        this.projectLogExamineMapper.deleteByPersonId(id);
        this.projectLogInformationMapper.deleteByPersonId(id);
        this.projectLogOtherMapper.deleteByPersonId(id);
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(ProjectLogEntity::getProjectId, (Object)projectId)).eq(ProjectLogEntity::getFillDate, (Object)informantDate);
        List list = super.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)list) && null != (projectLogEntity = (ProjectLogEntity)((Object)list.get(0))) && (entity = (ProjectLogEntity)((Object)super.selectById((Serializable)projectLogEntity.getId()))) != null && CollectionUtils.isEmpty(entity.getProjectLogDetailList()) && CollectionUtils.isEmpty(entity.getProjectLogScheduleList()) && CollectionUtils.isEmpty(entity.getProjectLogTypeList()) && CollectionUtils.isEmpty(entity.getProjectLogQualityList()) && CollectionUtils.isEmpty(entity.getProjectLogSafetyList()) && CollectionUtils.isEmpty(entity.getProjectLogMaterialList()) && CollectionUtils.isEmpty(entity.getProjectLogEquipmentList()) && CollectionUtils.isEmpty(entity.getProjectLogExamineList()) && CollectionUtils.isEmpty(entity.getProjectLogInformationList()) && CollectionUtils.isEmpty(entity.getProjectLogOtherList())) {
            this.mapper.deleteByProjectIdAndFillDate(projectId, informantDate);
        }
    }

    @Override
    public List<JSONObject> fetchOtherSubDetail(Long id) {
        LedgerTemplateEntity collect;
        LedgerTemplateEntity collect2;
        LedgerTemplateEntity collect3;
        LedgerTemplateEntity collect4;
        LedgerTemplateEntity collect5;
        LedgerTemplateEntity collect6;
        LedgerTemplateEntity collect7;
        LedgerTemplateEntity collect8;
        LedgerTemplateEntity collect9;
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        ProjectLogEntity entity = (ProjectLogEntity)((Object)super.selectById((Serializable)id));
        ProjectLogVO logVO = (ProjectLogVO)BeanMapper.map((Object)((Object)entity), ProjectLogVO.class);
        List ledgerScheduleList = logVO.getProjectLogScheduleList();
        List ledgerTypeList = logVO.getProjectLogTypeList();
        List ledgerQualityList = logVO.getProjectLogQualityList();
        List ledgerSafetyList = logVO.getProjectLogSafetyList();
        List ledgerMaterialList = logVO.getProjectLogMaterialList();
        List ledgerEquipmentList = logVO.getProjectLogEquipmentList();
        List ledgerExamineList = logVO.getProjectLogExamineList();
        List ledgerInformationList = logVO.getProjectLogInformationList();
        List ledgerOtherList = logVO.getProjectLogOtherList();
        List ledgerTemplates = this.templateService.list();
        if (CollectionUtils.isNotEmpty((Collection)ledgerScheduleList) && null != (collect9 = ProjectLogServiceImpl.getTemplateContent(ledgerTemplates, SCHEDULE_WORK_TYPE))) {
            for (Object vo : ledgerScheduleList) {
                vo.setTemplateContent(collect9.getTemplateContent());
            }
        }
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("title", (Object)SCHEDULE_TITLE);
        jsonObject1.put("describe", (Object)ledgerScheduleList);
        jsonObjects.add(jsonObject1);
        if (CollectionUtils.isNotEmpty((Collection)ledgerTypeList) && null != (collect8 = ProjectLogServiceImpl.getTemplateContent(ledgerTemplates, TYPE_WORK_TYPE))) {
            for (Object vo : ledgerTypeList) {
                vo.setTemplateContent(collect8.getTemplateContent());
            }
        }
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("title", (Object)TYPE_TITLE);
        jsonObject2.put("describe", (Object)ledgerTypeList);
        jsonObjects.add(jsonObject2);
        if (CollectionUtils.isNotEmpty((Collection)ledgerQualityList) && null != (collect7 = ProjectLogServiceImpl.getTemplateContent(ledgerTemplates, QUALITY_WORK_TYPE))) {
            for (Object vo : ledgerQualityList) {
                vo.setTemplateContent(collect7.getTemplateContent());
            }
        }
        JSONObject jsonObject3 = new JSONObject();
        jsonObject3.put("title", (Object)QUALITY_TITLE);
        jsonObject3.put("describe", (Object)ledgerQualityList);
        jsonObjects.add(jsonObject3);
        if (CollectionUtils.isNotEmpty((Collection)ledgerSafetyList) && null != (collect6 = ProjectLogServiceImpl.getTemplateContent(ledgerTemplates, SAFETY_WORK_TYPE))) {
            for (Object vo : ledgerSafetyList) {
                vo.setTemplateContent(collect6.getTemplateContent());
            }
        }
        JSONObject jsonObject4 = new JSONObject();
        jsonObject4.put("title", (Object)SAFETY_TITLE);
        jsonObject4.put("describe", (Object)ledgerSafetyList);
        jsonObjects.add(jsonObject4);
        if (CollectionUtils.isNotEmpty((Collection)ledgerMaterialList) && null != (collect5 = ProjectLogServiceImpl.getTemplateContent(ledgerTemplates, MATERIAL_WORK_TYPE))) {
            for (Object vo : ledgerMaterialList) {
                vo.setTemplateContent(collect5.getTemplateContent());
            }
        }
        JSONObject jsonObject5 = new JSONObject();
        jsonObject5.put("title", (Object)MATERIAL_TITLE);
        jsonObject5.put("describe", (Object)ledgerMaterialList);
        jsonObjects.add(jsonObject5);
        if (CollectionUtils.isNotEmpty((Collection)ledgerEquipmentList) && null != (collect4 = ProjectLogServiceImpl.getTemplateContent(ledgerTemplates, EQUIPMENT_WORK_TYPE))) {
            for (Object vo : ledgerEquipmentList) {
                vo.setTemplateContent(collect4.getTemplateContent());
            }
        }
        JSONObject jsonObject6 = new JSONObject();
        jsonObject6.put("title", (Object)EQUIPMENT_TITLE);
        jsonObject6.put("describe", (Object)ledgerEquipmentList);
        jsonObjects.add(jsonObject6);
        if (CollectionUtils.isNotEmpty((Collection)ledgerExamineList) && null != (collect3 = ProjectLogServiceImpl.getTemplateContent(ledgerTemplates, EXAMINE_WORK_TYPE))) {
            for (Object vo : ledgerExamineList) {
                vo.setTemplateContent(collect3.getTemplateContent());
            }
        }
        JSONObject jsonObject7 = new JSONObject();
        jsonObject7.put("title", (Object)EXAMINE_TITLE);
        jsonObject7.put("describe", (Object)ledgerExamineList);
        jsonObjects.add(jsonObject7);
        if (CollectionUtils.isNotEmpty((Collection)ledgerInformationList) && null != (collect2 = ProjectLogServiceImpl.getTemplateContent(ledgerTemplates, INFORMATION_WORK_TYPE))) {
            for (ProjectLogInformationVO vo : ledgerInformationList) {
                vo.setTemplateContent(collect2.getTemplateContent());
            }
        }
        JSONObject jsonObject8 = new JSONObject();
        jsonObject8.put("title", (Object)INFORMATION_TITLE);
        jsonObject8.put("describe", (Object)ledgerInformationList);
        jsonObjects.add(jsonObject8);
        if (CollectionUtils.isNotEmpty((Collection)ledgerOtherList) && null != (collect = ProjectLogServiceImpl.getTemplateContent(ledgerTemplates, OTHER_WORK_TYPE))) {
            for (ProjectLogOtherVO vo : ledgerOtherList) {
                vo.setTemplateContent(collect.getTemplateContent());
            }
        }
        JSONObject jsonObject9 = new JSONObject();
        jsonObject9.put("title", (Object)OTHER_TITLE);
        jsonObject9.put("describe", (Object)ledgerOtherList);
        jsonObjects.add(jsonObject9);
        return jsonObjects;
    }

    private static LedgerTemplateEntity getTemplateContent(List<LedgerTemplateEntity> ledgerTemplates, String type) {
        for (LedgerTemplateEntity entity : ledgerTemplates) {
            if (!type.equals(entity.getTemplateType())) continue;
            return entity;
        }
        return null;
    }
}

