package com.ejianc.business.probuilddiary.project.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目日志
 *
 * @author baipengyan
 */
@TableName("ejc_probuilddiary_project_log")
public class ProjectLogEntity extends BaseEntity {
	private static final long serialVersionUID = -2243026133718890200L;

	@TableField(value = "effective_date")
	private Date effectiveDate; // 生效日期
	@TableField(value = "bill_code")
	private String billCode; // 单据编号
	@TableField(value = "bill_name")
	private String billName; // 单据名称
	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "org_id")
	private Long orgId; // 项目部id
	@TableField(value = "org_code")
	private String orgCode; // 项目部编码
	@TableField(value = "org_name")
	private String orgName; // 项目部名称
	@TableField(value = "parent_org_id")
	private Long parentOrgId; // 项目部所属组织id
	@TableField(value = "parent_org_code")
	private String parentOrgCode; // 项目部所属组织编码
	@TableField(value = "parent_org_name")
	private String parentOrgName; // 项目部所属组织名称
	@TableField(value = "project_id")
	private Long projectId; // 项目id
	@TableField(value = "project_code")
	private String projectCode; // 项目编码
	@TableField(value = "project_name")
	private String projectName; // 项目名称
	@TableField(value = "source_type")
	private String sourceType; // 来源
	@TableField(value = "fill_date")
	private Date fillDate; // 填报日期
	@TableField(value = "week")
	private String week; // 星期
	@TableField(value = "weather")
	private String weather; // 天气
	@TableField(value = "wind_power")
	private String windPower; // 风力
	@TableField(value = "temperature")
	private String temperature; // 温度
	@TableField(value = "humidity")
	private String humidity; // 湿度
	@TableField(value = "air_quality")
	private Long airQuality; // 空气质量
	@TableField(value = "commit_user_id")
	private Long commitUserId; // 提交人id
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期

	@TableField(value = "province_name")
	private String provinceName; //省
	@TableField(value = "city_name")
	private String cityName; //市
	@TableField(value = "district_name")
	private String districtName; //区

	@TableField(exist = false)
	@SubEntity(serviceName = "projectLogDetailService", pidName = "projectLogId")//此处有pid="xxx"，默认值pid="pid"
	private List<ProjectLogDetailEntity> projectLogDetailList = new ArrayList<>(); // 项目日志-施工内容（施工员）
	@TableField(exist = false)
	@SubEntity(serviceName = "projectLogScheduleService", pidName = "projectLogId")//此处有pid="xxx"，默认值pid="pid"
	private List<ProjectLogScheduleEntity> projectLogScheduleList = new ArrayList<>(); // 项目日志-进度情况（施工员）
	@TableField(exist = false)
	@SubEntity(serviceName = "projectLogTypeService", pidName = "projectLogId")//此处有pid="xxx"，默认值pid="pid"
	private List<ProjectLogTypeEntity> projectLogTypeList = new ArrayList<>(); // 项目日志-施工组织设计、方案、交底、变更情况（技术负责人）
	@TableField(exist = false)
	@SubEntity(serviceName = "projectLogQualityService", pidName = "projectLogId")//此处有pid="xxx"，默认值pid="pid"
	private List<ProjectLogQualityEntity> projectLogQualityList = new ArrayList<>(); // 项目日志-工程质量检查、验收情况（质检员）
	@TableField(exist = false)
	@SubEntity(serviceName = "projectLogSafetyService", pidName = "projectLogId")//此处有pid="xxx"，默认值pid="pid"
	private List<ProjectLogSafetyEntity> projectLogSafetyList = new ArrayList<>(); // 项目日志-安全活动情况（安全员）
	@TableField(exist = false)
	@SubEntity(serviceName = "projectLogMaterialService", pidName = "projectLogId")//此处有pid="xxx"，默认值pid="pid"
	private List<ProjectLogMaterialEntity> projectLogMaterialList = new ArrayList<>(); // 项目日志-材料进出场情况（材料员）
	@TableField(exist = false)
	@SubEntity(serviceName = "projectLogEquipmentService", pidName = "projectLogId")//此处有pid="xxx"，默认值pid="pid"
	private List<ProjectLogEquipmentEntity> projectLogEquipmentList = new ArrayList<>(); // 项目日志-设备进出场情况（设备管理员）
	@TableField(exist = false)
	@SubEntity(serviceName = "projectLogExamineService", pidName = "projectLogId")//此处有pid="xxx"，默认值pid="pid"
	private List<ProjectLogExamineEntity> projectLogExamineList = new ArrayList<>(); // 项目日志-检验试验情况（取样员）
	@TableField(exist = false)
	@SubEntity(serviceName = "projectLogInformationService", pidName = "projectLogId")//此处有pid="xxx"，默认值pid="pid"
	private List<ProjectLogInformationEntity> projectLogInformationList = new ArrayList<>(); // 项目日志-工程资料归档及会议情况（资料员）
	@TableField(exist = false)
	@SubEntity(serviceName = "projectLogOtherService", pidName = "projectLogId")//此处有pid="xxx"，默认值pid="pid"
	private List<ProjectLogOtherEntity> projectLogOtherList = new ArrayList<>(); // 项目日志-其他情况

	public String getProvinceName() {
		return provinceName;
	}

	public void setProvinceName(String provinceName) {
		this.provinceName = provinceName;
	}

	public String getCityName() {
		return cityName;
	}

	public void setCityName(String cityName) {
		this.cityName = cityName;
	}

	public String getDistrictName() {
		return districtName;
	}

	public void setDistrictName(String districtName) {
		this.districtName = districtName;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getParentOrgId() {
		return parentOrgId;
	}

	public void setParentOrgId(Long parentOrgId) {
		this.parentOrgId = parentOrgId;
	}

	public String getParentOrgCode() {
		return parentOrgCode;
	}

	public void setParentOrgCode(String parentOrgCode) {
		this.parentOrgCode = parentOrgCode;
	}

	public String getParentOrgName() {
		return parentOrgName;
	}

	public void setParentOrgName(String parentOrgName) {
		this.parentOrgName = parentOrgName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getSourceType() {
		return sourceType;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public Date getFillDate() {
		return fillDate;
	}

	public void setFillDate(Date fillDate) {
		this.fillDate = fillDate;
	}

	public String getWeek() {
		return week;
	}

	public void setWeek(String week) {
		this.week = week;
	}

	public String getWeather() {
		return weather;
	}

	public void setWeather(String weather) {
		this.weather = weather;
	}

	public String getWindPower() {
		return windPower;
	}

	public void setWindPower(String windPower) {
		this.windPower = windPower;
	}

	public String getTemperature() {
		return temperature;
	}

	public void setTemperature(String temperature) {
		this.temperature = temperature;
	}

	public String getHumidity() {
		return humidity;
	}

	public void setHumidity(String humidity) {
		this.humidity = humidity;
	}

	public Long getAirQuality() {
		return airQuality;
	}

	public void setAirQuality(Long airQuality) {
		this.airQuality = airQuality;
	}

	public Long getCommitUserId() {
		return commitUserId;
	}

	public void setCommitUserId(Long commitUserId) {
		this.commitUserId = commitUserId;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public List<ProjectLogDetailEntity> getProjectLogDetailList() {
		return projectLogDetailList;
	}

	public void setProjectLogDetailList(List<ProjectLogDetailEntity> projectLogDetailList) {
		this.projectLogDetailList = projectLogDetailList;
	}

	public List<ProjectLogScheduleEntity> getProjectLogScheduleList() {
		return projectLogScheduleList;
	}

	public void setProjectLogScheduleList(List<ProjectLogScheduleEntity> projectLogScheduleList) {
		this.projectLogScheduleList = projectLogScheduleList;
	}

	public List<ProjectLogTypeEntity> getProjectLogTypeList() {
		return projectLogTypeList;
	}

	public void setProjectLogTypeList(List<ProjectLogTypeEntity> projectLogTypeList) {
		this.projectLogTypeList = projectLogTypeList;
	}

	public List<ProjectLogQualityEntity> getProjectLogQualityList() {
		return projectLogQualityList;
	}

	public void setProjectLogQualityList(List<ProjectLogQualityEntity> projectLogQualityList) {
		this.projectLogQualityList = projectLogQualityList;
	}

	public List<ProjectLogSafetyEntity> getProjectLogSafetyList() {
		return projectLogSafetyList;
	}

	public void setProjectLogSafetyList(List<ProjectLogSafetyEntity> projectLogSafetyList) {
		this.projectLogSafetyList = projectLogSafetyList;
	}

	public List<ProjectLogMaterialEntity> getProjectLogMaterialList() {
		return projectLogMaterialList;
	}

	public void setProjectLogMaterialList(List<ProjectLogMaterialEntity> projectLogMaterialList) {
		this.projectLogMaterialList = projectLogMaterialList;
	}

	public List<ProjectLogEquipmentEntity> getProjectLogEquipmentList() {
		return projectLogEquipmentList;
	}

	public void setProjectLogEquipmentList(List<ProjectLogEquipmentEntity> projectLogEquipmentList) {
		this.projectLogEquipmentList = projectLogEquipmentList;
	}

	public List<ProjectLogExamineEntity> getProjectLogExamineList() {
		return projectLogExamineList;
	}

	public void setProjectLogExamineList(List<ProjectLogExamineEntity> projectLogExamineList) {
		this.projectLogExamineList = projectLogExamineList;
	}

	public List<ProjectLogInformationEntity> getProjectLogInformationList() {
		return projectLogInformationList;
	}

	public void setProjectLogInformationList(List<ProjectLogInformationEntity> projectLogInformationList) {
		this.projectLogInformationList = projectLogInformationList;
	}

	public List<ProjectLogOtherEntity> getProjectLogOtherList() {
		return projectLogOtherList;
	}

	public void setProjectLogOtherList(List<ProjectLogOtherEntity> projectLogOtherList) {
		this.projectLogOtherList = projectLogOtherList;
	}
}
