package com.ejianc.business.probuilddiary.construct.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaEntity;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaDetailService;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service("constructArea") 
public class ConstructAreaBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IConstructAreaDetailService detailService;

	@Autowired
	private IConstructAreaService service;
	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IBillTypeApi billTypeApi;
	/**
	 * 更新子表单据状态
	 *
	 * @param billId 区域id
	 * @param state  单据状态
	 */
	private void updateSubBillState(Long billId, Integer state) {
		detailService.updateBillState(billId, state);
	}


	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("终审审核完回调--start，billId={},state={},billTypeCode={}", billId, state, billTypeCode);
		ConstructAreaEntity entity = service.selectById(billId);
		if (entity == null) {
			throw new BusinessException("查询不到单据信息");
		}
		UserContext userContext = sessionManager.getUserContext();

		// 区分提交和审批
		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			// 直审更新提交相关字段
			entity.setCommitDate(new Date());
			entity.setCommitUserCode(userContext.getUserCode());
			entity.setCommitUserName(userContext.getUserName());
		}
		// 生效时间
		entity.setEffectiveDate(new Date());
		// 执行更新
		service.saveOrUpdate(entity, false);
		// 更新子表单据状态
		updateSubBillState(billId, state);
		logger.info("终审审核完回调--end");
		return CommonResponse.success("终审审核完回调成功");
	}
	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId 单据id
	 * @param state  单据状态
	 *
	 * @return 响应信息
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}
	/**
	 * 弃审前事件回调
	 *
	 * @param billId 单据id
	 * @param state  单据状态
	 *
	 * @return 响应信息
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		ConstructAreaEntity entity = service.selectById(billId);
		if (entity == null) {
			throw new BusinessException("查询不到单据信息");
		}

		if(entity.getModifyFlag().equals(1)) {
			//已修改单据不能执行撤回弃审操作
			return CommonResponse.error("当前单据已被修改，不能撤回/弃审！");
		}

		// 是否被下游引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况：{}，{}", res.isSuccess(), res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被项目还款单引用，不能撤回/弃审！");
		}
		// 更新子表单据状态
		updateSubBillState(billId, state);

		return CommonResponse.success("单据撤回/弃审成功");
	}
}
