/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.probuilddiary.construct.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaDetailEntity;
import com.ejianc.business.probuilddiary.construct.bean.ConstructAreaEntity;
import com.ejianc.business.probuilddiary.construct.mapper.ConstructAreaMapper;
import com.ejianc.business.probuilddiary.construct.service.IConstructAreaService;
import com.ejianc.business.probuilddiary.construct.utils.TreeNodeBUtil;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaDetailVO;
import com.ejianc.business.probuilddiary.construct.vo.ConstructAreaVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="constructAreaService")
public class ConstructAreaServiceImpl
extends BaseServiceImpl<ConstructAreaMapper, ConstructAreaEntity>
implements IConstructAreaService {
    private static final String BILL_CODE = "AREA_WORK";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<ConstructAreaVO> insertOrUpdate(ConstructAreaVO vo) {
        ConstructAreaEntity entity = (ConstructAreaEntity)((Object)BeanMapper.map((Object)vo, ConstructAreaEntity.class));
        if (entity.getId() == null) {
            QueryWrapper listQuery = new QueryWrapper();
            listQuery.eq((Object)"project_id", (Object)entity.getProjectId());
            listQuery.eq((Object)"dr", (Object)0);
            int resultCount = super.count((Wrapper)listQuery);
            if (resultCount > 0) {
                return CommonResponse.error((String)"\u4e00\u4e2a\u9879\u76ee\u53ea\u53ef\u4ee5\u6709\u4e00\u4e2a\u65bd\u5de5\u533a\u57df\u5355\u636e\uff01");
            }
            entity.setId(IdWorker.getId());
            CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo));
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (entity.getHoldStatus() == null) {
                entity.setHoldStatus("1");
            }
            entity.setModifyFlag(0);
        } else {
            ConstructAreaEntity entity1 = (ConstructAreaEntity)((Object)super.selectById((Serializable)entity.getId()));
            if (entity1 != null) {
                entity.setBillState(entity1.getBillState());
                if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState())) {
                    entity.setModifyFlag(1);
                }
            }
        }
        this.resetPid(entity.getDetailList());
        super.saveOrUpdate((Object)entity, false);
        ConstructAreaVO constructAreaVO = this.queryDetail(entity.getId(), vo.getOperate());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)constructAreaVO);
    }

    @Override
    public ConstructAreaVO queryDetail(Long id, String operate) {
        HashMap orderMap = new HashMap();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<String, String>();
        orderParams.put("treeIndex", "asc");
        orderMap.put("detailList", orderParams);
        ConstructAreaEntity constructAreaEntity = (ConstructAreaEntity)((Object)super.selectById((Serializable)id, orderMap));
        ConstructAreaVO contractVO = (ConstructAreaVO)BeanMapper.map((Object)((Object)constructAreaEntity), ConstructAreaVO.class);
        if (CollectionUtils.isNotEmpty((Collection)contractVO.getDetailList())) {
            for (ConstructAreaDetailVO detail : contractVO.getDetailList()) {
                detail.setTid(detail.getId().toString());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            contractVO.setDetailList(TreeNodeBUtil.buildTree((List)contractVO.getDetailList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)operate)) {
            contractVO.setBillState(Integer.valueOf(0));
        }
        return contractVO;
    }

    private void resetPid(List<ConstructAreaDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ConstructAreaDetailEntity cdEntity : detailList) {
                if ("del".equals(cdEntity.getRowState())) continue;
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                    cdEntity.setDetailId(cdEntity.getId());
                }
                idMap.put(cdEntity.getTid().toString(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (ConstructAreaDetailEntity cdEntity : detailList) {
                if ("del".equals(cdEntity.getRowState()) || !StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid().toString()));
            }
        }
    }
}

