package com.ejianc.business.probuilddiary.person.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 个人施工日志
 * 
 * @author generator
 * 
 */
 @TableName("ejc_probuilddiary_person")
public class PersonEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value = "commit_user_id")
    private Long commitUserId; // 提交人id
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_state_name")
    private String billStateName; // 单据状态名称
    @TableField(value="informant_id")
    private Long informantId; // 填报人id
    @TableField(value="informant_name")
    private String informantName; // 填报人名称
    @TableField(value="informant_code")
    private String informantCode; // 填报人编码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="informant_date")
    private Date informantDate; // 填报日期
    @TableField(value="org_id")
    private Long orgId; // 项目所属项目部ID
    @TableField(value="org_code")
    private String orgCode; // 项目所属项目部编码
    @TableField(value="org_name")
    private String orgName; // 项目所属项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属上级组织ID
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属上级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属上级组织名称
    @TableField(value="log_template_name")
    private String logTemplateName;//日志模板名称
    @TableField(value="log_template_code")
    private String logTemplateCode;//日志模板编码
    @TableField(value = "gather_flag")
    private Boolean gatherFlag;// 是否汇总到项目日志
    @TableField(exist=false)
    @SubEntity(serviceName="personDetailService",pidName = "personId")//此处有pid="xxx"，默认值pid="pid"
    private List<PersonDetailEntity> detailList = new ArrayList<>(); // 个人日志-施工内容（施工员）
    @TableField(exist=false)
    @SubEntity(serviceName="personScheduleService",pidName = "personId")//此处有pid="xxx"，默认值pid="pid"
    private List<PersonScheduleEntity> scheduleList = new ArrayList<>(); // 个人日志-进度情况（施工员）
    @TableField(exist=false)
    @SubEntity(serviceName="personTypeService",pidName = "personId")//此处有pid="xxx"，默认值pid="pid"
    private List<PersonTypeEntity> typeList = new ArrayList<>(); // 个人日志-施工组织设计、方案、交底、变更情况（技术负责人）
    @TableField(exist=false)
    @SubEntity(serviceName="personQualityService",pidName = "personId")//此处有pid="xxx"，默认值pid="pid"
    private List<PersonQualityEntity> qualityList = new ArrayList<>(); // 个人日志-工程质量检查、验收情况（质检员）
    @TableField(exist=false)
    @SubEntity(serviceName="personSafetyService",pidName = "personId")//此处有pid="xxx"，默认值pid="pid"
    private List<PersonSafetyEntity> safetyList = new ArrayList<>(); // 个人日志-安全活动情况（安全员）
    @TableField(exist=false)
    @SubEntity(serviceName="personMaterialService",pidName = "personId")//此处有pid="xxx"，默认值pid="pid"
    private List<PersonMaterialEntity> materialList = new ArrayList<>(); // 个人日志-材料进出场情况
    @TableField(exist=false)
    @SubEntity(serviceName="personEquipmentService",pidName = "personId")//此处有pid="xxx"，默认值pid="pid"
    private List<PersonEquipmentEntity> equipmentList = new ArrayList<>(); // 个人日志-设备进出场情况（设备管理员）
    @TableField(exist=false)
    @SubEntity(serviceName="personExamineService",pidName = "personId")//此处有pid="xxx"，默认值pid="pid"
    private List<PersonExamineEntity> examineList = new ArrayList<>(); // 个人日志-检验试验情况（取样员）
    @TableField(exist=false)
    @SubEntity(serviceName="personInformationService",pidName = "personId")//此处有pid="xxx"，默认值pid="pid"
    private List<PersonInformationEntity> informationList = new ArrayList<>(); // 个人日志-工程资料归档及会议情况（资料员）
    @TableField(exist=false)
    @SubEntity(serviceName="personOtherService",pidName = "personId")//此处有pid="xxx"，默认值pid="pid"
    private List<PersonOtherEntity> otherList = new ArrayList<>(); // 个人日志-其他情况
    @TableField(value = "log_template")
    private String logTemplate;//日志模板

    public String getLogTemplateName() {
        return logTemplateName;
    }

    public void setLogTemplateName(String logTemplateName) {
        this.logTemplateName = logTemplateName;
    }

    public String getLogTemplateCode() {
        return logTemplateCode;
    }

    public void setLogTemplateCode(String logTemplateCode) {
        this.logTemplateCode = logTemplateCode;
    }

    public Boolean getGatherFlag() {
        return gatherFlag;
    }

    public void setGatherFlag(Boolean gatherFlag) {
        this.gatherFlag = gatherFlag;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getLogTemplate() {
        return logTemplate;
    }

    public void setLogTemplate(String logTemplate) {
        this.logTemplate = logTemplate;
    }

    public Long getCommitUserId() {
        return commitUserId;
    }

    public void setCommitUserId(Long commitUserId) {
        this.commitUserId = commitUserId;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public Long getInformantId() {
        return informantId;
    }

    public void setInformantId(Long informantId) {
        this.informantId = informantId;
    }
    public String getInformantName() {
        return informantName;
    }

    public void setInformantName(String informantName) {
        this.informantName = informantName;
    }
    public String getInformantCode() {
        return informantCode;
    }

    public void setInformantCode(String informantCode) {
        this.informantCode = informantCode;
    }
    public Date getInformantDate() {
        return informantDate;
    }

    public void setInformantDate(Date informantDate) {
        this.informantDate = informantDate;
    }
    
    public List<PersonDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PersonDetailEntity> detailList) {
        this.detailList = detailList;
    }
    public List<PersonScheduleEntity> getScheduleList() {
        return scheduleList;
    }

    public void setScheduleList(List<PersonScheduleEntity> scheduleList) {
        this.scheduleList = scheduleList;
    }
    public List<PersonTypeEntity> getTypeList() {
        return typeList;
    }

    public void setTypeList(List<PersonTypeEntity> typeList) {
        this.typeList = typeList;
    }
    public List<PersonQualityEntity> getQualityList() {
        return qualityList;
    }

    public void setQualityList(List<PersonQualityEntity> qualityList) {
        this.qualityList = qualityList;
    }
    public List<PersonSafetyEntity> getSafetyList() {
        return safetyList;
    }

    public void setSafetyList(List<PersonSafetyEntity> safetyList) {
        this.safetyList = safetyList;
    }
    public List<PersonMaterialEntity> getMaterialList() {
        return materialList;
    }

    public void setMaterialList(List<PersonMaterialEntity> materialList) {
        this.materialList = materialList;
    }
    public List<PersonEquipmentEntity> getEquipmentList() {
        return equipmentList;
    }

    public void setEquipmentList(List<PersonEquipmentEntity> equipmentList) {
        this.equipmentList = equipmentList;
    }
    public List<PersonExamineEntity> getExamineList() {
        return examineList;
    }

    public void setExamineList(List<PersonExamineEntity> examineList) {
        this.examineList = examineList;
    }
    public List<PersonInformationEntity> getInformationList() {
        return informationList;
    }

    public void setInformationList(List<PersonInformationEntity> informationList) {
        this.informationList = informationList;
    }
    public List<PersonOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<PersonOtherEntity> otherList) {
        this.otherList = otherList;
    }
}
