package com.ejianc.business.procost.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 实际成本来源类型枚举类
 *
 * @author sunyj
 * @Description:
 * @date 2022/5/24 11:42
 */
public enum SourceTypeEnum {
    劳务分包过程结算("1","劳务分包过程结算"),

    劳务分包完工结算("2","劳务分包完工结算"),

    专业分包过程结算("3","专业分包过程结算"),

    专业分包完工结算("4", "专业分包完工结算"),

    材料验收单("5", "材料验收单"),

    领料出库("6", "领料出库"),

    仓库盘点("7", "仓库盘点"),

    调拨出库单("8", "调拨出库单"),

    消耗材调差单("9", "消耗材调差单"),

    材料处置单("10", "材料处置单"),

    混凝土验收单("11", "混凝土验收单"),

    混凝土调差单("12", "混凝土调差单"),

    固定资产摊销("13", "固定资产摊销"),

    设备租金计算("14", "设备租金计算"),

    设备租赁结算("15", "设备租赁结算"),

    临时机械设备结算单("16", "临时机械设备结算单"),

    设备安拆结算单("17",  "设备安拆结算单"),

    设备调出单("18", "设备调出单"),

    设备处置单("19", "设备处置单"),

    周转材租金计算单("20", "周转材租金计算单"),

    自有周转材摊销("21", "自有周转材摊销"),

    周转材租赁结算("22", "周转材租赁结算"),

    周转材调出单("23", "周转材调出单"),

    周转材处置单("24", "周转材处置单"),

    其他支出合同结算("25", "其他支出合同结算"),

    成本单据("26", "成本单据"),

    零星费用分配单("27", "零星费用分配单"),

    材料退库("28", "材料退库"),

    材料采购结算("29", "材料采购结算"),

    混凝土采购结算("30", "混凝土采购结算"),

    固定资产设备处置("31", "固定资产设备处置"),

    固定资产设备调出("32", "固定资产设备调出"),

    固定资产摊销_财务("33", "固定资产摊销_财务");


    SourceTypeEnum(String typeCode, String typeName) {
        this.typeCode = typeCode;
        this.typeName = typeName;
    }

    private String typeCode;
    private String typeName;
    private static Map<String, SourceTypeEnum> enumMap = new HashMap<>();

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    static {
        enumMap = EnumSet.allOf(SourceTypeEnum.class).stream().collect(Collectors.toMap(SourceTypeEnum::getTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    public static SourceTypeEnum getByCode(String code) {
        return enumMap.get(code);
    }
}
