package com.ejianc.business.procost.vo;

import com.ejianc.business.procost.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;


/**
 * 科目明细数据展示
 * 
 * @author sunyj
 * 
 */
public class SubjectReportVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private Long subjectId; // subjectId
    private String subjectName; // 科目名称
    private java.lang.String subjectCode; // 科目编码
    private String happenDate; // 发生日期
    private Long parentId; // parent_id
    private java.math.BigDecimal happenMny; // 发生成本(无税)
    private java.math.BigDecimal happenTaxMny; // 发生成本(含税)
    private java.lang.String detailIndex; // 序号  1   1.1
    private BigDecimal sjcbFlRate;//实际成本-分类占比
    private BigDecimal sjcbAllRate;//实际成本-总额占比
    private java.math.BigDecimal happenMnySum; // 截止上期发生成本
    private java.lang.Long wbsId; // 核算对象主键
    private java.lang.String wbsCode; // 核算对象编号
    private java.lang.String wbsName; // 核算对象名称

    private java.lang.String sourceBillCode; // 来源单据编号
    private java.lang.String sourceBillName; // 来源单据名称
    private java.lang.String sourceBillUrl; // 来源单据跳转url

    public BigDecimal getSjcbFlRate() {
        return sjcbFlRate;
    }

    public void setSjcbFlRate(BigDecimal sjcbFlRate) {
        this.sjcbFlRate = sjcbFlRate;
    }

    public BigDecimal getSjcbAllRate() {
        return sjcbAllRate;
    }

    public void setSjcbAllRate(BigDecimal sjcbAllRate) {
        this.sjcbAllRate = sjcbAllRate;
    }

    public BigDecimal getHappenTaxMny() {
        return happenTaxMny;
    }

    public void setHappenTaxMny(BigDecimal happenTaxMny) {
        this.happenTaxMny = happenTaxMny;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public String getSourceBillName() {
        return sourceBillName;
    }

    public void setSourceBillName(String sourceBillName) {
        this.sourceBillName = sourceBillName;
    }

    public String getSourceBillUrl() {
        return sourceBillUrl;
    }

    public void setSourceBillUrl(String sourceBillUrl) {
        this.sourceBillUrl = sourceBillUrl;
    }

    private List<ITreeNodeB> children; //子集数据

    public String getDetailIndex() {
        return detailIndex;
    }

    public void setDetailIndex(String detailIndex) {
        this.detailIndex = detailIndex;
    }

    public BigDecimal getHappenMnySum() {
        return happenMnySum;
    }

    public void setHappenMnySum(BigDecimal happenMnySum) {
        this.happenMnySum = happenMnySum;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getHappenDate() {
        return happenDate;
    }

    public void setHappenDate(String happenDate) {
        this.happenDate = happenDate;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public BigDecimal getHappenMny() {
        return happenMny;
    }

    public void setHappenMny(BigDecimal happenMny) {
        this.happenMny = happenMny;
    }

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return parentId;
    }

    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;

    }
    
}
