/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.bean.ShareEntity;
import com.ejianc.business.procost.bean.SubjectEntity;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.service.IShareService;
import com.ejianc.business.procost.service.ISubjectService;
import com.ejianc.business.procost.utils.TreeNodeBUtil;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"setting"})
public class SettingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISettingService service;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IShareService shareService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettingVO> saveOrUpdate(@RequestBody SettingVO saveorUpdateVO) {
        List details;
        if (CollectionUtils.isEmpty((Collection)saveorUpdateVO.getSubjectDetails())) {
            return CommonResponse.error((String)"\u79d1\u76ee\u660e\u7ec6\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(SettingEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
        if (null != saveorUpdateVO.getId()) {
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(details = this.service.list((Wrapper)lambda)))) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u5df2\u5b58\u5728,\u4e0d\u5141\u8bb8\u91cd\u590d\u65b0\u589e\uff01");
        }
        if (null == saveorUpdateVO.getId()) {
            List listbs = saveorUpdateVO.getSubjectDetails();
            listbs.forEach(e -> e.setId(null));
        }
        SettingEntity entity = (SettingEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SettingEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        List<SubjectEntity> listbs = entity.getSubjectDetails();
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        for (SubjectEntity cdEntity : listbs) {
            idMap.put(cdEntity.getTid(), cdEntity.getId());
        }
        for (SubjectEntity cdEntity : listbs) {
            if (999L != cdEntity.getParentId()) {
                cdEntity.setParentId((Long)idMap.get(cdEntity.getParentId()));
                cdEntity.setTid(cdEntity.getId());
                continue;
            }
            cdEntity.setTid(cdEntity.getId());
        }
        this.subjectService.saveOrUpdateBatch(listbs, listbs.size(), false);
        SettingVO vo = (SettingVO)BeanMapper.map((Object)((Object)entity), SettingVO.class);
        vo.setSubjectDetails(TreeNodeBUtil.buildTree((List)vo.getSubjectDetails()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettingVO> queryDetail(Long id) {
        SettingEntity entity = (SettingEntity)((Object)this.service.selectById(id));
        SettingVO settingVO = (SettingVO)BeanMapper.map((Object)((Object)entity), SettingVO.class);
        if (CollectionUtils.isNotEmpty(entity.getSubjectDetails())) {
            settingVO.setSubjectDetails(TreeNodeBUtil.buildTree((List)settingVO.getSubjectDetails()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)settingVO);
    }

    @RequestMapping(value={"/queryCopyDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettingVO> queryCopyDetail(Long id) {
        SettingVO settingVO;
        SettingEntity entity = (SettingEntity)((Object)this.service.selectById(id));
        entity.setId(null);
        entity.setCreateUserName("");
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setProjectId(null);
        entity.setProjectName("");
        entity.setOrgId(null);
        entity.setOrgName("");
        entity.setBillState(null);
        if (CollectionUtils.isNotEmpty(entity.getSubjectDetails())) {
            entity.getSubjectDetails().forEach(vo -> vo.setRowState("add"));
        }
        if (CollectionUtils.isNotEmpty((Collection)(settingVO = (SettingVO)BeanMapper.map((Object)((Object)entity), SettingVO.class)).getSubjectDetails())) {
            settingVO.setSubjectDetails(TreeNodeBUtil.buildTree((List)settingVO.getSubjectDetails()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)settingVO);
    }

    @RequestMapping(value={"/querySettingFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> querySettingFlag(Long projectId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(SettingEntity::getProjectId, (Object)projectId);
        lambda.in(SettingEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List details = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            return CommonResponse.success((String)"\u8be5\u9879\u76ee\u5df2\u6210\u672c\u8bbe\u7f6e", (Object)true);
        }
        return CommonResponse.success((String)"\u8be5\u9879\u76ee\u672a\u6210\u672c\u8bbe\u7f6e", (Object)false);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettingVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("createUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        page.getRecords().forEach(vo -> {
            vo.setTaxFlag("0".equals(vo.getTaxFlag()) ? "\u662f" : "\u5426");
            vo.setMaterialCost("0".equals(vo.getMaterialCost()) ? "\u51fa\u5e93\u5165\u6210\u672c" : "\u7269\u8d44\u5408\u540c\u7ed3\u7b97\u5165\u6210\u672c");
        });
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"costSettingRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SettingVO>> orderDetailRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            queryParam.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billStateList));
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("type")) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambda.notIn(ShareEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            List list = this.shareService.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List projects = list.stream().map(ShareEntity::getProjectId).collect(Collectors.toList());
                queryParam.getParams().put("projectId", new Parameter("not_in", projects));
            }
        }
        queryParam.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        page.getRecords().forEach(vo -> {
            vo.setTaxFlag("0".equals(vo.getTaxFlag()) ? "\u662f" : "\u5426");
            vo.setMaterialCost("0".equals(vo.getMaterialCost()) ? "\u51fa\u5e93\u5165\u6210\u672c" : "\u7269\u8d44\u5408\u540c\u7ed3\u7b97\u5165\u6210\u672c");
        });
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

