package com.ejianc.business.procost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.bean.HandshareDetailEntity;
import com.ejianc.business.procost.bean.HandshareEntity;
import com.ejianc.business.procost.service.IHandshareService;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("handshare") 
public class HandshareBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IHandshareService service;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ICostDetailApi costDetailApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		HandshareEntity handshareEntity = service.getById(billId);
		//推送成本
		//明细
		List<CostDetailVO> costDetailVOList = new ArrayList<>();
		List<HandshareDetailEntity> handshareDetailList = handshareEntity.getHandshareDetailList();
		if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handshareDetailList)) {
			for (HandshareDetailEntity handshareDetailEntity : handshareDetailList) {
				CostDetailVO costDetailVO = new CostDetailVO();
				costDetailVO.setSubjectId(handshareDetailEntity.getSubjectId());
				costDetailVO.setSubjectCode(handshareDetailEntity.getSubjectCode());
				costDetailVO.setSubjectName(handshareDetailEntity.getSubjectName());
				costDetailVO.setWbsId(handshareDetailEntity.getWbsId());
				costDetailVO.setWbsCode(handshareDetailEntity.getWbsCode());
				costDetailVO.setWbsName(handshareDetailEntity.getWbsName());
				costDetailVO.setSourceId(handshareEntity.getId());
				costDetailVO.setSourceDetailId(handshareDetailEntity.getId());
				costDetailVO.setHappenTaxMny(handshareDetailEntity.getHappenTaxMny()==null?BigDecimal.ZERO:handshareDetailEntity.getHappenTaxMny());
				costDetailVO.setHappenMny(handshareDetailEntity.getHappenMny()==null?BigDecimal.ZERO:handshareDetailEntity.getHappenMny());
				costDetailVO.setHappenDate(new Date());
				costDetailVO.setCreateUserName(handshareEntity.getCreateUserName());
				costDetailVO.setSourceType("COST_HANDSHARE");
				costDetailVO.setSourceTabType("COST_HANDSHARE_DETAIL");
				costDetailVO.setProjectId(handshareEntity.getProjectId());
				costDetailVOList.add(costDetailVO);
			}
		}

		if (ListUtil.isNotEmpty(costDetailVOList)) {
			logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
			CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
			logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
			if (stringCommonResponse.isSuccess()) {
			} else {
				return CommonResponse.success(stringCommonResponse.getMsg());
			}
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		HandshareEntity handshareEntity = service.getById(billId);
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(handshareEntity.getId());
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			return CommonResponse.success(stringCommonResponse.getMsg());
		}
		return CommonResponse.success();
	}

}
