package com.ejianc.business.procost.controller;

import java.io.Serializable;

import com.ejianc.business.financeintegration.PMPayApply.api.IPMJJFApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMJJFVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.procost.bean.HandshareEntity;
import com.ejianc.business.procost.service.IHandshareService;
import com.ejianc.business.procost.vo.HandshareVO;

/**
 * 成本单据
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("handshare")
@Api(value = "成本单据", tags = {"成本单据"})
public class HandshareController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "HAND_SHARE";//此处需要根据实际修改

    @Autowired
    private IHandshareService service;

    @Autowired
    private IPMJJFApi pmjjfApi;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<HandshareVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody HandshareVO saveOrUpdateVO) {
    	HandshareEntity entity = BeanMapper.map(saveOrUpdateVO, HandshareEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        HandshareEntity dbentity =null;
        if((null != saveOrUpdateVO.getId()) &&"1".equals(entity.getCwFlag())){
            dbentity = service.selectById(saveOrUpdateVO.getId());
        }
        service.saveOrUpdate(entity, false);
    	if((saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0)&&"1".equals(entity.getCwFlag())){
    	    //新增保存时，如果是财务取数，需要更新费用中间表标识
            PMJJFVO jjfVo = BeanMapper.map(entity,PMJJFVO.class);
            String period = jjfVo.getPeriod();
            jjfVo.setPeriod(period.replace("-",""));
            logger.info("调用费用期间传参："+JSONObject.toJSONString(jjfVo));
            pmjjfApi.updateFlag(jjfVo);
        }
        if((null != saveOrUpdateVO.getId()) &&"1".equals(entity.getCwFlag())){
            if(!"1".equals(dbentity.getCwFlag())){
                //数据库是0  前端传1  说明需要更新费用中间表标识
                PMJJFVO jjfVo = BeanMapper.map(entity,PMJJFVO.class);
                String period = jjfVo.getPeriod();
                jjfVo.setPeriod(period.replace("-",""));
                logger.info("调用费用期间传参："+JSONObject.toJSONString(jjfVo));
                pmjjfApi.updateFlag(jjfVo);
            }
        }
    	HandshareVO vo = BeanMapper.map(entity, HandshareVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<HandshareVO> queryDetail(@RequestParam Long id) {
    	HandshareEntity entity = service.selectById(id);
    	HandshareVO vo = BeanMapper.map(entity, HandshareVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<HandshareVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (HandshareVO vo : vos) {
                HandshareEntity entity = service.selectById(vo.getId());
                if("1".equals(entity.getCwFlag())){
                    //如果是财务取数，需要更新费用中间表标识
                    PMJJFVO jjfVo = BeanMapper.map(entity,PMJJFVO.class);
                    String period = jjfVo.getPeriod();
                    jjfVo.setPeriod(period.replace("-",""));
                    jjfVo.setCwFlag("0");
                    logger.info("调用费用期间传参："+JSONObject.toJSONString(jjfVo));
                    pmjjfApi.updateFlag(jjfVo);
                }
            }
        }
        service.removeByIds(vos.stream().map(HandshareVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<HandshareVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }

        IPage<HandshareEntity> page = service.queryPage(param,false);
        IPage<HandshareVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), HandshareVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<HandshareEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Handshare-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refHandshareData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<HandshareVO>> refHandshareData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<HandshareEntity> page = service.queryPage(param,false);
        IPage<HandshareVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), HandshareVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
