/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.procost.bean.CostDetailEntity;
import com.ejianc.business.procost.bean.HandshareDetailEntity;
import com.ejianc.business.procost.bean.HandshareEntity;
import com.ejianc.business.procost.service.ICostDetailService;
import com.ejianc.business.procost.service.IHandshareService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handshare")
public class HandshareBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IHandshareService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailService costDetailService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        HandshareEntity handshareEntity = (HandshareEntity)((Object)this.service.selectById(billId));
        this.logger.info("\u63a8\u9001\u6570\u636e\u5f00\u59cb--------");
        ArrayList<CostDetailEntity> costDetailVOList = new ArrayList<CostDetailEntity>();
        List<HandshareDetailEntity> handshareDetailList = handshareEntity.getHandshareDetailList();
        if (CollectionUtils.isNotEmpty(handshareDetailList)) {
            this.logger.info("\u5f00\u59cb\u5904\u7406\u5b50\u8868--------" + handshareDetailList.size());
            for (HandshareDetailEntity handshareDetailEntity : handshareDetailList) {
                CostDetailEntity costDetailVO = new CostDetailEntity();
                costDetailVO.setSubjectId(handshareDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(handshareDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(handshareDetailEntity.getSubjectName());
                costDetailVO.setWbsId(handshareDetailEntity.getWbsId());
                costDetailVO.setWbsCode(handshareDetailEntity.getWbsCode());
                costDetailVO.setWbsName(handshareDetailEntity.getWbsName());
                costDetailVO.setSourceId(handshareEntity.getId());
                costDetailVO.setSourceDetailId(handshareDetailEntity.getId());
                costDetailVO.setHappenTaxMny(handshareDetailEntity.getHappenTaxMny() == null ? BigDecimal.ZERO : handshareDetailEntity.getHappenTaxMny());
                costDetailVO.setHappenMny(handshareDetailEntity.getHappenMny() == null ? BigDecimal.ZERO : handshareDetailEntity.getHappenMny());
                costDetailVO.setHappenDate(new Date());
                costDetailVO.setPeriod(handshareEntity.getPeriod());
                costDetailVO.setProportionFlag("1");
                costDetailVO.setCreateUserName(handshareEntity.getCreateUserName());
                costDetailVO.setSourceType("COST_HANDSHARE");
                costDetailVO.setSourceTabType("COST_HANDSHARE_DETAIL");
                costDetailVO.setProjectId(handshareEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            this.costDetailService.saveOrUpdateBatch(costDetailVOList);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        HandshareEntity handshareEntity = (HandshareEntity)((Object)this.service.selectById(billId));
        this.costDetailService.deleteCostDetail(handshareEntity.getId());
        return CommonResponse.success();
    }
}

