/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.mapper.SettingMapper;
import com.ejianc.business.procost.service.ISettingService;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settingService")
public class SettingServiceImpl
extends BaseServiceImpl<SettingMapper, SettingEntity>
implements ISettingService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISettingService service;

    @Override
    public SettingVO queryByOrgId(Long orgId) {
        CommonResponse orgListResp;
        if (null == orgId || 0L == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        if (!(orgListResp = this.orgApi.findParentsByOrgId(orgId)).isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25!");
        }
        List orgList = ((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        orgList.sort(Comparator.reverseOrder());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        List settingList = this.service.list((Wrapper)lambda.in(SettingEntity::getOrgId, orgList));
        SettingVO vo = new SettingVO();
        if (CollectionUtils.isNotEmpty((Collection)settingList)) {
            Map settingMap = settingList.stream().collect(Collectors.toMap(SettingEntity::getOrgId, Function.identity(), (key1, key2) -> key2));
            for (Long id : orgList) {
                SettingEntity entity = (SettingEntity)((Object)settingMap.get(id));
                if (ObjectUtils.isEmpty((Object)((Object)entity))) continue;
                vo = (SettingVO)BeanMapper.map((Object)((Object)entity), SettingVO.class);
                break;
            }
        }
        return vo;
    }
}

