/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procost.service.impl;

import com.ejianc.business.procost.bean.HandshareEntity;
import com.ejianc.business.procost.mapper.HandshareMapper;
import com.ejianc.business.procost.service.IHandshareService;
import com.ejianc.business.procost.vo.HandshareDetailVO;
import com.ejianc.business.procost.vo.HandshareVO;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="handshareService")
public class HandshareServiceImpl
extends BaseServiceImpl<HandshareMapper, HandshareEntity>
implements IHandshareService {
    private static final String BillType = "EJCBT202205000032";
    private static final String linkUrl = "/ejc-procost-frontend/#/handshare/card?id=";
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    @Override
    public ExecutionVO targetCost(HandshareVO vo) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(vo.getId());
        totalVO.setTenantId(vo.getTenantId());
        totalVO.setBillCode(vo.getBillCode());
        totalVO.setBillType(BillType);
        totalVO.setBussinessType(BussinessTypeEnum.\u8d22\u52a1\u53d6\u6570\u6210\u672c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5176\u4ed6.getCode());
        totalVO.setProjectId(vo.getProjectId());
        totalVO.setOrgId(vo.getOrgId());
        totalVO.setMoney(vo.getCostTaxMny());
        totalVO.setTaxMoney(vo.getCostTaxMny());
        totalVO.setLinkUrl(this.BaseHost + linkUrl + vo.getId());
        for (HandshareDetailVO planDetailVO : vo.getHandshareDetailList()) {
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(planDetailVO.getId());
            detailExecutionVO.setSourceBillId(vo.getId());
            detailExecutionVO.setDocType(DocTypeEnum.\u6210\u672c\u79d1\u76ee.getCode());
            detailExecutionVO.setDocId(planDetailVO.getSubjectId());
            detailExecutionVO.setName(planDetailVO.getSubjectName());
            detailExecutionVO.setCode(planDetailVO.getSubjectCode());
            detailExecutionVO.setCategoryId(planDetailVO.getSubjectParentId());
            detailExecutionVO.setMoney(planDetailVO.getHappenMny());
            detailExecutionVO.setTaxMoney(planDetailVO.getHappenTaxMny());
            detailList.add(detailExecutionVO);
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }
}

