package com.ejianc.business.procost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.sun.org.apache.bcel.internal.generic.NEW;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.procost.mapper.SettingMapper;
import com.ejianc.business.procost.bean.SettingEntity;
import com.ejianc.business.procost.service.ISettingService;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 成本设置
 * 
 * @author generator
 * 
 */
@Service("settingService")
public class SettingServiceImpl extends BaseServiceImpl<SettingMapper, SettingEntity> implements ISettingService{

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISettingService service;

    @Override
    public SettingVO queryByOrgId(Long orgId) {
        if (null == orgId || 0==orgId){
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findParentsByOrgId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败!");
        }
        List<Long> orgList = orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
//        orgList.add(orgId);
        orgList.sort(Comparator.reverseOrder());
        LambdaQueryWrapper<SettingEntity> lambda = Wrappers.lambdaQuery();
        List<SettingEntity> settingList = service.list(lambda.in(SettingEntity::getOrgId, orgList));
        SettingVO vo = new SettingVO();
        if (CollectionUtils.isNotEmpty(settingList)){
            Map<Long, SettingEntity> settingMap = settingList.stream().collect(Collectors.toMap(SettingEntity::getOrgId, Function.identity(), (key1, key2) -> key2));
            for (Long id : orgList) {
                SettingEntity entity = settingMap.get(id);
                if (!ObjectUtils.isEmpty(entity)){
                    vo = BeanMapper.map(entity,SettingVO.class);
                    break;
                }
            }
        }
        return vo;
    }
}
